package cn.com.duiba.nezha.alg.alg.predict;


import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickValuePredDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;


import java.util.List;

public class AdxClickValuePredict {


    /**
     * 接口1：预估点击价值接口
     *
     * @param mergeAdxClickAndJoinDo 点击、活动参与 融合数据；本地缓存获取
     * @param adxPredAdDoList        预发券Top3列表；接口调用获取
     * @return 点击价值
     */
    public static Double getPredClickValue(AdxClickAndJoinDo mergeAdxClickAndJoinDo,
                                           List<AdxPredAdDo> adxPredAdDoList) {

        Double ret = null;

        if (adxPredAdDoList == null) {
            return ret;
        }

        if (adxPredAdDoList.isEmpty()) {
            return 0.0;
        }

        double distictClickRatio = 1.0;
        double[] launchRatio = {0.7, 0.10, 0.05};

        if (mergeAdxClickAndJoinDo == null || mergeAdxClickAndJoinDo.getClickPv() <= 100) {
            ret = getPredClickValue(distictClickRatio, launchRatio, adxPredAdDoList);
        } else {

//            distictClickRatio = MathUtil.division(mergeAdxClickAndJoinDo.getDistictClickPv(), clickPv, 3);
            double firstLaunchRatio = MathUtil.division(mergeAdxClickAndJoinDo.getFirstJoinPv(), mergeAdxClickAndJoinDo.getClickPv(), 3);
            double secondLaunchRatio = MathUtil.division(mergeAdxClickAndJoinDo.getSecondJoinPv(), mergeAdxClickAndJoinDo.getClickPv(), 3);
            double thirdLaunchRatio = MathUtil.division(mergeAdxClickAndJoinDo.getThirdJoinPv(), mergeAdxClickAndJoinDo.getClickPv(), 3);

            launchRatio[0] = Math.min(firstLaunchRatio, 0.99);
            launchRatio[1] = Math.min(secondLaunchRatio, 0.25);
            launchRatio[2] = Math.min(thirdLaunchRatio, 0.10);

            ret = getPredClickValue(distictClickRatio, launchRatio, adxPredAdDoList);
        }
        return ret;
    }


    private static Double getPredClickValue(double distictClickRatio,
                                            double[] launchRatio,
                                            List<AdxPredAdDo> adxPredAdDoList
    ) {
        Double ret = null;

        if (AssertUtil.isEmpty(adxPredAdDoList)) {
            return ret;
        }

        System.out.println("distictClickRatio=" + distictClickRatio + ",launchRatio=" + JSON.toJSONString(launchRatio) + ",adxPredAdDoList=" + JSON.toJSONString(adxPredAdDoList));
        int size = Math.min(adxPredAdDoList.size(), 3);
        ret = 0.0;
        for (int i = 0; i < size; i++) {
            AdxPredAdDo adxPredAdDo = adxPredAdDoList.get(i);
            ret += MathUtil.dot(adxPredAdDo.getArpu(), launchRatio[i], 5);

        }
        return ret;
    }

    /**
     * 接口2：点击、活动参与，统计数据融合
     *
     * @param adxClickValuePredDo 点击、活动参与统计数据
     * @return 融合统计数据
     * <p>
     * 备注：数据本地缓存1分钟
     */
    public static AdxClickAndJoinDo getMergeStatClickValue(AdxClickValuePredDo adxClickValuePredDo) {

        AdxClickAndJoinDo ret = null;
        if (adxClickValuePredDo != null) {
            AdxClickAndJoinDo ideaAdxClickAndJoinDo = statMerge(adxClickValuePredDo.getIdeaLastNHoursDoList());
            AdxClickAndJoinDo resourceAdxClickAndJoinDo = statMerge(adxClickValuePredDo.getResourceLastNHoursDoList());
            ret = statMerge(ideaAdxClickAndJoinDo, resourceAdxClickAndJoinDo);
        }
        return ret;
    }


    /**
     * 维度数据融合
     *
     * @param ideaAdxClickAndJoinDo
     * @param resourceAdxClickAndJoinDo
     * @return
     * @throws Exception
     */
    public static AdxClickAndJoinDo statMerge(AdxClickAndJoinDo ideaAdxClickAndJoinDo, AdxClickAndJoinDo resourceAdxClickAndJoinDo) {

        AdxClickAndJoinDo ret = null;
        if (AssertUtil.isAllEmpty(ideaAdxClickAndJoinDo, resourceAdxClickAndJoinDo)) {
            return ret;
        }

        if (ideaAdxClickAndJoinDo == null) {
            return resourceAdxClickAndJoinDo;
        }
        if (resourceAdxClickAndJoinDo == null) {
            return ideaAdxClickAndJoinDo;
        }

        ret = new AdxClickAndJoinDo();


        Double resourceWeight = 1.0;

        if (resourceAdxClickAndJoinDo.getClickPv() > 1000L) {
            resourceWeight = MathUtil.division(1000L, resourceAdxClickAndJoinDo.getClickPv(), 4);
        }

        Long clickPv = MathUtil.dot(ideaAdxClickAndJoinDo.getClickPv(), 1.0) + MathUtil.dot(resourceAdxClickAndJoinDo.getClickPv(), resourceWeight);
        Long distictClickPv = MathUtil.dot(ideaAdxClickAndJoinDo.getDistictClickPv(), 1.0) + MathUtil.dot(resourceAdxClickAndJoinDo.getDistictClickPv(), resourceWeight);
        Long firstJoinPv = MathUtil.dot(ideaAdxClickAndJoinDo.getFirstJoinPv(), 1.0) + MathUtil.dot(resourceAdxClickAndJoinDo.getFirstJoinPv(), resourceWeight);
        Long secondJoinPv = MathUtil.dot(ideaAdxClickAndJoinDo.getSecondJoinPv(), 1.0) + MathUtil.dot(resourceAdxClickAndJoinDo.getSecondJoinPv(), resourceWeight);
        Long thirdJoinPv = MathUtil.dot(ideaAdxClickAndJoinDo.getThirdJoinPv(), 1.0) + MathUtil.dot(resourceAdxClickAndJoinDo.getThirdJoinPv(), resourceWeight);

        ret.setClickPv(clickPv);
        ret.setDistictClickPv(distictClickPv);
        ret.setFirstJoinPv(firstJoinPv);
        ret.setSecondJoinPv(secondJoinPv);
        ret.setThirdJoinPv(thirdJoinPv);

        return ret;
    }

    /**
     * 小时数据融合
     *
     * @param adxClickAndJoinDoList
     * @return
     * @throws Exception
     */
    private static AdxClickAndJoinDo statMerge(List<AdxClickAndJoinDo> adxClickAndJoinDoList) {

        AdxClickAndJoinDo ret = null;
        if (AssertUtil.isEmpty(adxClickAndJoinDoList)) {
            return ret;
        }

        ret = new AdxClickAndJoinDo();

        int size = Math.min(adxClickAndJoinDoList.size(), 6);


        Long clickPv = 0L;  // 点击次数
        Long distictClickPv = 0L; //adxrid去重次数
        Long firstJoinPv = 0L; //adxrid首次参与活动次数
        Long secondJoinPv = 0L; //adxrid第二次参与活动次数
        Long thirdJoinPv = 0L; //adxrid第二次参与活动次数

        for (int i = 0; i < size; i++) {
            AdxClickAndJoinDo adxClickAndJoinDo = adxClickAndJoinDoList.get(i);


            Double weight = 1 - i * 0.1;
            clickPv += MathUtil.dot(adxClickAndJoinDo.getClickPv(), weight);
            distictClickPv += MathUtil.dot(adxClickAndJoinDo.getDistictClickPv(), weight);
            firstJoinPv += MathUtil.dot(adxClickAndJoinDo.getFirstJoinPv(), weight);
            secondJoinPv += MathUtil.dot(adxClickAndJoinDo.getSecondJoinPv(), weight);
            thirdJoinPv += MathUtil.dot(adxClickAndJoinDo.getThirdJoinPv(), weight);

        }

        ret.setClickPv(clickPv);
        ret.setDistictClickPv(distictClickPv);
        ret.setFirstJoinPv(firstJoinPv);
        ret.setSecondJoinPv(secondJoinPv);
        ret.setThirdJoinPv(thirdJoinPv);

//        System.out.println("ret:"+ JSON.toJSONString(ret));
        return ret;
    }


}