package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class AdxRoiFactor {


    /**
     * 策略1-ROI调节因子(根据缓存数据，调用频率：1min调用1次)
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return ROI调节因子, 调节主要依据
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxRoiFactorDo ret = new AdxRoiFactorDo();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、获取上一次调节因子(初始值)
         * 步骤4、计算统计数据
         * 步骤5、判断调节因子是否重置
         * 步骤6、判断竞价成功率小于阈值，尝试加价; 大于阈值，尝试降价
         * 步骤7、在正常范围内，更新调节因子
         *
         */


        try {

            // 1、设置默认值
            Double defaultFactor = 1.0;                      // 默认ROI调节因子
            Double defaultMinRoi = 1.0;                      // 默认最低ROI
            Double lowerLimit = 0.3;                         // ROI调节因子下限
            Double upperLimit = 1.7;                         // ROI调节因子上限

            Double tryStep = 0.02;                           // 尝试出价步长
            Double sucAbsLowLimit = 0.05;                    // 竞价成功率绝对下限
            Double sucAbsUppLimit = 0.95;                    // 竞价成功率绝对上限
            Double sucOppLowLimit = 0.20;                    // 竞价成功率相对下限

            //ROI调节因子
            Double lastRoi = 0.0;
            Double factor = defaultFactor;

            //调节主要依据
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;

            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;


            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {

                //人工设置ROI
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                //扣费方式：1:一价扣费，2:二价扣费
                Integer feeType = adxRoiControlDoInfo.getFeeType();

                //3、获取上一次调节因子(初始值)
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty(lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);

                }


                //4、计算统计数据
                Long defaultConsume = 0L;
                Long defaultCnt = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());

                //策略1-实时-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗,广告消耗
                roiMs = StrategyBid.getRoi(strategyFirMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division(StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), 10000 * 1000L, 2);
                advertConsumeMs = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //策略1-全天累计-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗,广告消耗
                roiDay = StrategyBid.getRoi(strategyFirDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyFirDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division(StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), 10000 * 1000L, 2);
                advertConsumeDay = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //资源位维度-实时-ROI,竞价成功率
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }


                //5、判断调节因子是否重置
                //重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:01:00; 竞价量级为0;
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null
                        || (currentTime >= 0L && currentTime < 1L)
                        || bidCntMs == 0L) {

                    factor = defaultFactor;

                } else {

                    //6、判断竞价成功率小于阈值，尝试加价; 大于阈值，尝试降价；在正常范围内，更新调节因子
                    if (sucRateMs < sucAbsLowLimit || sucRateMs <= Math.max(resoSucRateMs, 0.10) * sucOppLowLimit) {
                        factor += -tryStep;

                    } else if (sucRateMs > sucAbsUppLimit) {
                        factor += tryStep;

                    } else {

                        //7、在正常范围内，更新调节因子(墨迹：参照max(历史策略ROI，实时策略ROI))
                        if (feeType != null && feeType == 1) {
                            Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi,0.97);
                            factor = getFactorUpdate(factor, roiStable, minRoi, sucRateMs, Math.max(resoSucRateMs, 0.10));

                        } else {
                            factor = getFactorUpdate(factor, roiMs, minRoi, sucRateMs, Math.max(resoSucRateMs, 0.10));

                        }

                    }

                }


                //更新上一次实际ROI
                lastRoi = roiMs;
            }

            //调节因子范围控制
            factor = DataUtil.formatDouble(StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit),6);

            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);

            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);

            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);


        } catch (Exception e) {
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }

        return ret;
    }


    /**
     * 调节因子更新（九宫格控制）
     *
     * @param lastValue     上一次调节因子
     * @param realRoi       实际roi
     * @param targetRoi     目标roi
     * @param realSucRate   实际竞价成功率
     * @param targetSucRate 目标竞价成功率
     * @return 更新后的调节因子
     */
    public static Double getFactorUpdate(Double lastValue,
                                         Double realRoi, Double targetRoi,
                                         Double realSucRate, Double targetSucRate) {

        Double ret = lastValue;

        Double roiLimit = 0.98;                        // ROI比例阈值
        Double[] roiInterval = {0.00, 0.90, 1.10};     // ROI分区间
        Double[] sucInterval = {0.00, 0.80, 0.95};     // 竞价成功率分区间
        Double[] diffList = {0.02, 0.05, 0.08, 0.10};  // ROI偏差分桶值

        Double[][] updateMatrix = {{0.03, 0.04, 0.05}, {-0.03, 0.01, 0.01}, {-0.03, -0.02, -0.01}};

        int i = DataUtil.toInt(StrategyBid.bucket(realRoi, targetRoi, roiInterval));
        int j = DataUtil.toInt(StrategyBid.bucket(realSucRate, targetSucRate, sucInterval));

        if ((i == 1 && j == 1) || (i == 1 && j == 2)) {

            Double diff = Math.abs(DataUtil.division(realRoi, targetRoi,3) - 1.0);
            Double coeff = DataUtil.division(diff, 0.1,3);

            if (realRoi > targetRoi * roiLimit) {
                ret += -updateMatrix[i][j] * coeff;
            } else if (realRoi < targetRoi * roiLimit) {
                ret += updateMatrix[i][j] * coeff;
            }

        } else {

            ret += updateMatrix[i][j];

        }

        return ret;
    }


    //单元测试
    public static void main(String[] args) {

        try {

            Double[] v1 = {0.2, 0.5, 0.8, 1.0};
            System.out.println("ret1:" + JSON.toJSONString(StrategyBid.bucket(0.0, v1)));

            Double v2 = 0.0;
            Double v3 = 1.00;
            Double[] v4 = {0.00, 0.90, 1.10};  // ROI分区间
            System.out.println("bucket2:" + JSON.toJSONString(StrategyBid.bucket(v2, v3, v4)));

            Double f1 = 1.00;
            Double roi1 = 1.177;
            Double roi2 = 1.20;
            Double suc1 = 0.80;
            Double suc2 = 0.80;
            System.out.println("getFactorUpdate:" + JSON.toJSONString(getFactorUpdate(f1, roi1, roi2, suc1, suc2)));


            String str =
                    "{\"adxRoiFactorDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.7,\"adxRoiFactor\":0.98,\"bidCntDay\":0,\"bidCntMs\":227,\"lastRealRoi\":1.38089,\"roiDay\":1.400002,\"roiMs\":1.38089,\"sucBidCntDay\":0,\"sucBidCntMs\":1,\"sucDay\":0.0,\"sucMs\":0.004406},\"defaultPrice\":701,\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":2,\"advertConsume\":0,\"adxConsume\":13770000,\"bid\":965,\"exp\":2,\"click\":0},\"lastMinRoi\":1.4,\"maxPrice\":1000,\"minPrice\":10,\"minRoi\":1.4,\"resourceIndexMap\":{\"bidSuc\":41,\"advertConsume\":21,\"adxConsume\":254320000,\"bid\":20475,\"exp\":41,\"click\":2},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6920000,\"bid\":305,\"exp\":1,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6850000,\"bid\":324,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6920000,\"bid\":305,\"exp\":1,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6850000,\"bid\":324,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";

            //JSONObject object = JSON.parseObject(str);
            AdxRoiControlDo adxRoiControlDoInfo2 = JSONObject.parseObject(str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString(adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));

            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
