package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxIdeaDQNRcmder {

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;

    /**
     * 预估/统计占比分配 top1>0
     */
    static double[] predBucket = {100, 1000, 5000, 10000, 50000};
    static double[] predWeight = {0.05, 0.2, 0.5, 0.8, 1};


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.7, 0.8, 0.90, 0.95, 1};
    static double[] pCpmWeight = {0.5, 1, 2, 10, 100};

    /**
     * pcpm权重分配1 top1<0
     */
    static double[] pCpmBucket2 = {1, 1.1, 1.3, 1.5, 2};
    static double[] pCpmWeight2 = {100, 10, 2, 1, 0.5};


    /**
     * 创意推荐 main2
     *
     * @param validIdeaList 有效创意集合
     * @param predRpmMap    资源位创意预估回报
     * @return 创意
     */
    public static Long ideaRcmd(List<Long> validIdeaList, Map<Long, Double> predRpmMap, Map<Long, AdxIdeaStatDo> adxDayStatDoMap) {


        Long ret = null;

        if (AssertUtil.isEmpty(validIdeaList)) {
            return ret;
        }

        //1 数据处理
        if (predRpmMap == null) {
            predRpmMap = new HashMap<>();
        }

        if (adxDayStatDoMap == null) {
            adxDayStatDoMap = new HashMap<>(MAP_DF_SIZE);
        }
        adxDayStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));


        //2 融合
        Map<Long, Double> rpmMap = getMergeRpm(validIdeaList, predRpmMap, adxDayStatDoMap);

        //3 最优融合收益
        Double bestRpm = getBestRpm(validIdeaList, rpmMap);


        //4 概率分配
        Map<Long, Double> weighMap = new HashMap<>(MAP_DF_SIZE);
        for (int i = 0, size = validIdeaList.size(); i < size; i++) {

            Long ideaId = validIdeaList.get(i);
            Double rpm = rpmMap.get(ideaId);

            Double weight = getRpmWeight(rpm, bestRpm);

            if (weight != null) {
                weighMap.put(ideaId, weight);
            } else {
                weighMap.put(ideaId, 10.0);
            }
        }


        //5 挑选创意
        System.out.println("weightMap=" + JSON.toJSONString(weighMap));
        ret = Roulette.doubleMap(weighMap);

        //6 返回创意

        if (ret == null) {
            ret = validIdeaList.get(0);
        }
        return ret;
    }


    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = null;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            } else {
                ret = MathBase.getConfidenceWeight(Math.max(ratio, 1.0), pCpmBucket2, pCpmWeight2);
            }
        }

        return ret;
    }


    /**
     * 计算最大CTR && PECPM
     *
     * @param predRpmMap
     * @return
     */
    private static Map<Long, Double> getMergeRpm(List<Long> ideaList, Map<Long, Double> predRpmMap, Map<Long, AdxIdeaStatDo> adxDayStatDoMap) {
        Map<Long, Double> ret = new HashMap<>(MAP_DF_SIZE);
        if (AssertUtil.isEmpty(predRpmMap)) {
            return null;
        }

        for (int i = 0, size = ideaList.size(); i < size; i++) {
            Long ideaId = ideaList.get(i);
            Double predRpm = predRpmMap.get(ideaId);

            AdxIdeaStatDo adxDayStatDo = adxDayStatDoMap.get(ideaId);
            Double rpm = getMergeRpm(predRpm, adxDayStatDo);

            ret.put(ideaId, rpm);
//            System.out.println("ideaId="+ideaId+",preRpm="+predRpm+",statRpm="+adxDayStatDo.getProfitEcpm()+",rpm="+rpm);
        }

        return ret;
    }

    /**
     * 计算最大CTR && PECPM
     *
     * @param rpmMap
     * @return
     */
    private static Double getBestRpm(List<Long> ideaList, Map<Long, Double> rpmMap) {
        Double ret = null;
        if (AssertUtil.isEmpty(rpmMap)) {
            return null;
        }

        for (int i = 0, size = ideaList.size(); i < size; i++) {
            Long ideaId = ideaList.get(i);
            Double rpm = rpmMap.get(ideaId);

            if (rpm != null) {
                if (ret == null || ret < rpm) {
                    ret = rpm;
                }
            }
        }
        return ret;
    }


    /**
     * 权重融合
     *
     * @return
     */
    public static Double getMergeRpm(Double predRpm, AdxIdeaStatDo adxDayStatDo) {
        Double ret = null;


        if (predRpm != null && adxDayStatDo != null && adxDayStatDo.getConfidence()) {
            Double statRpm = adxDayStatDo.getProfitEcpm();

            Long bid = adxDayStatDo.getBid();

            // 投放数据越充分，预估占比越大
            Double w1 = MathBase.getConfidenceWeight(bid, predBucket, predWeight);

            // 平滑限制预估与统计偏差范围[0.1～4]
            Double limitPredRpm = MathBase.noiseSmoother(predRpm, -1 * statRpm, 4 * statRpm);
            if (statRpm < 0) {
                limitPredRpm = MathBase.noiseSmoother(predRpm, 4 * statRpm, -1 * statRpm);
            }


            ret = w1 * limitPredRpm + (1 - w1) * statRpm;
        }
        return ret;
    }

}
