package cn.com.duiba.nezha.alg.alg.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;


public class AdxRoiControlDo implements Serializable{


    /**
     * 创意默认出价(分/cpm)
     */
    private Long defaultPrice;

    /**
     * 创意最低出价(分/cpm)
     */
    private Long minPrice;

    /**
     * 创意最高出价(分/cpm)
     */
    private Long maxPrice;

    /**
     * 策略
     */
    private String strategy;

    /**
     * 底价(分/cpm) 来源：adx请求
     */
    private Double basePrice;

    /**
     * 最低ROI-当前(小数，如1.50)
     */
    private Double minRoi;

    /**
     * 最低ROI-上一次(小数，如1.50)
     */
    private Double lastMinRoi;

    /**
     * ROI调节因子-当前
     */
    private AdxRoiFactorDo adxRoiFactorDo;

    /**
     * ROI调节因子-上一次
     */
    private AdxRoiFactorDo lastAdxRoiFactorDo;

    /**
     * 价格试探表-当前
     */
    private AdxPriceExplorationDo priceExplorationDo;

    /**
     * 价格试探表-上一次
     */
    private AdxPriceExplorationDo lastPriceExplorationDo;

    /**
     * 因子试探表-当前
     */
    private AdxFactorExplorationDo factorExplorationDo;

    /**
     * 因子试探表-上一次
     */
    private AdxFactorExplorationDo lastFactorExplorationDo;

    /**
     * 全天累计：分策略-分level-分指标-值
     */
    private ArrayList<AdxStrategyDo> strategyDayDoList;

    /**
     * 实时：分策略-分level-分指标-值
     */
    private ArrayList<AdxStrategyDo> strategyMsDoList;

    /**
     * 实时：统计指标数据-创意维度
     */
    private Map<String, Long> ideaIndexMap;

    /**
     * 实时：统计指标数据-资源维度
     */
    private Map<String, Long> resourceIndexMap;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;

    /**
     * 策略流量配比-当前
     */
    private AdxFlowRateDo adxFlowRateDo;



    public Long getDefaultPrice() {
        return defaultPrice;
    }

    public void setDefaultPrice(Long defaultPrice) {
        this.defaultPrice = defaultPrice;
    }

    public Long getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Long minPrice) {
        this.minPrice = minPrice;
    }

    public Long getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Long maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Double getBasePrice() {
        return basePrice;
    }

    public void setBasePrice(Double basePrice) {
        this.basePrice = basePrice;
    }

    public Double getMinRoi() {
        return minRoi;
    }

    public void setMinRoi(Double minRoi) {
        this.minRoi = minRoi;
    }

    public Double getLastMinRoi() {
        return lastMinRoi;
    }

    public void setLastMinRoi(Double lastMinRoi) {
        this.lastMinRoi = lastMinRoi;
    }

    public AdxRoiFactorDo getAdxRoiFactorDo() {
        return adxRoiFactorDo;
    }

    public void setAdxRoiFactorDo(AdxRoiFactorDo adxRoiFactorDo) {
        this.adxRoiFactorDo = adxRoiFactorDo;
    }

    public AdxRoiFactorDo getLastAdxRoiFactorDo() {
        return lastAdxRoiFactorDo;
    }

    public void setLastAdxRoiFactorDo(AdxRoiFactorDo lastAdxRoiFactorDo) {
        this.lastAdxRoiFactorDo = lastAdxRoiFactorDo;
    }

    public AdxPriceExplorationDo getPriceExplorationDo() {
        return priceExplorationDo;
    }

    public void setPriceExplorationDo(AdxPriceExplorationDo priceExplorationDo) {
        this.priceExplorationDo = priceExplorationDo;
    }

    public AdxPriceExplorationDo getLastPriceExplorationDo() {
        return lastPriceExplorationDo;
    }

    public void setLastPriceExplorationDo(AdxPriceExplorationDo lastPriceExplorationDo) {
        this.lastPriceExplorationDo = lastPriceExplorationDo;
    }

    public AdxFactorExplorationDo getFactorExplorationDo() {
        return factorExplorationDo;
    }

    public void setFactorExplorationDo(AdxFactorExplorationDo factorExplorationDo) {
        this.factorExplorationDo = factorExplorationDo;
    }

    public AdxFactorExplorationDo getLastFactorExplorationDo() {
        return lastFactorExplorationDo;
    }

    public void setLastFactorExplorationDo(AdxFactorExplorationDo lastFactorExplorationDo) {
        this.lastFactorExplorationDo = lastFactorExplorationDo;
    }

    public ArrayList<AdxStrategyDo> getStrategyDayDoList() {
        return strategyDayDoList;
    }

    public void setStrategyDayDoList(ArrayList<AdxStrategyDo> strategyDayDoList) {
        this.strategyDayDoList = strategyDayDoList;
    }

    public ArrayList<AdxStrategyDo> getStrategyMsDoList() {
        return strategyMsDoList;
    }

    public void setStrategyMsDoList(ArrayList<AdxStrategyDo> strategyMsDoList) {
        this.strategyMsDoList = strategyMsDoList;
    }

    public Map<String, Long> getIdeaIndexMap() {
        return ideaIndexMap;
    }

    public void setIdeaIndexMap(Map<String, Long> ideaIndexMap) {
        this.ideaIndexMap = ideaIndexMap;
    }

    public Map<String, Long> getResourceIndexMap() {
        return resourceIndexMap;
    }

    public void setResourceIndexMap(Map<String, Long> resourceIndexMap) {
        this.resourceIndexMap = resourceIndexMap;
    }

    public Integer getFeeType() { return feeType; }

    public void setFeeType(Integer feeType) { this.feeType = feeType; }

    public AdxFlowRateDo getAdxFlowRateDo() {
        return adxFlowRateDo;
    }

    public void setAdxFlowRateDo(AdxFlowRateDo adxFlowRateDo) {
        this.adxFlowRateDo = adxFlowRateDo;
    }
}
