/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(PriceExploration.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 10.0;
            Double defaultMinRoi = 1.0;
            Double[] stepList = new Double[]{0.95, 1.0, 1.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> priceMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Double upLimitBidFee = null;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                Double minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                Double maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), DataUtil.double2Long((Double)defaultPrice) + 1L));
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;
                Double uppValue = baseValue * 1.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultPrice;
                } else {
                    Object stepCon;
                    Double incre1 = 1.0;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                        Map<String, Double> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastPriceMap)) {
                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                                uppValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                            }
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastPriceMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = DataUtil.division((Double)baseValue, (Double)defaultPrice) - 1.0;
                        baseValue = baseValue - defaultPrice * baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)roiMs, (Double)(minRoi * 0.98), (int)3);
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.98);
                                incre2 = DataUtil.division((Double)roiStable, (Double)(minRoi * 0.98), (int)3);
                            }
                            Double weight2 = 1.0;
                            weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                            Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                            incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                            incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                            Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                            if (weight1 == 0.0 || diff > 1.3) {
                                incre = 1.0 + (incre2 - 1.0) * weight2;
                            }
                            Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                            if (tryLabel == 0L) {
                                Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                                baseValue = upLimitBidFee != null && feeType != null && feeType == 1 ? (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi ? Double.valueOf(Math.max(upLimitBidFee, baseValue)) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff))) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                            }
                            if (lastTryLabel == 1L && tryLabel == 0L) {
                                baseValue = uppValue;
                            }
                            if (basePrice != null && basePrice > 0.0 && diff > 1.3) {
                                baseValue = Math.max(basePrice, baseValue);
                            }
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                if (lastTryLabel == 1L && tryLabel == 1L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) > minRoi * 0.95) {
                                    baseValue = uppValue;
                                }
                                baseValue = Math.min(upLimitBidFee, baseValue);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double uppDiff = DataUtil.division((Double)uppValue, (Double)defaultPrice) - 1.0;
                        stepList[2] = DataUtil.division((Double)(uppValue - defaultPrice * uppDiff * 0.2), (Double)baseValue);
                        Double lowDiff = DataUtil.division((Double)lowValue, (Double)defaultPrice) - 1.0;
                        stepList[0] = DataUtil.division((Double)(lowValue - defaultPrice * lowDiff * 0.2), (Double)baseValue);
                    } else if (tryLabel == 1L) {
                        stepList[0] = DataUtil.division((Double)lowValue, (Double)baseValue);
                        stepCon = StrategyBid.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0.08);
                        Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.06 : 0.08)));
                        if (adxConsumeMs == 0.0) {
                            stepCon = 0.1;
                            stepRoi = 0.1;
                        }
                        stepList[2] = Math.max(DataUtil.division((Double)uppValue, (Double)baseValue) + 0.4 * (Double)stepCon + 0.6 * stepRoi, 1.0);
                    } else {
                        stepCon = stepList;
                        Double.valueOf(stepCon[2] + (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                        stepCon = stepList;
                        Double.valueOf(stepCon[0] - (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                    }
                    if (upLimitBidFee != null) {
                        stepList[2] = Math.min(stepList[2], DataUtil.division((Double)upLimitBidFee, (Double)baseValue));
                    }
                    if (basePrice != null && basePrice > 0.0) {
                        stepList[2] = Math.max(stepList[2], DataUtil.division((Double)basePrice, (Double)baseValue));
                    }
                    if (tryLabel == 2L) {
                        baseFlowRate[2] = 0.2;
                        baseFlowRate[0] = 0.2;
                    } else if (tryLabel == 1L) {
                        Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        baseFlowRate[2] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0.8);
                        baseFlowRate[0] = 0.2;
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiTryFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    } else {
                        if (diff < 0.9) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;
                        } else if (diff > 1.1) {
                            baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                            baseFlowRate[0] = 0.1;
                        } else if (diff > 0.95 && diff < 1.05) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = 0.1;
                        } else {
                            baseFlowRate[2] = 0.15;
                            baseFlowRate[0] = 0.15;
                        }
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiNormalFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    }
                    baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[0] - baseFlowRate[2]), (int)3);
                    for (int i = 1; i < AdxLevel.values().length; ++i) {
                        lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                        lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                        if (tryLabel != 1L) continue;
                        lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String((Integer)i));
                    }
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = DataUtil.formatDouble((Double)(baseValue * stepList[i - 1]), (int)3);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                priceMap.put(key, price);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.2);
            adxRoiControlDoInfo1.setMinRoi(1.2);
            HashMap<String, Long> ideaIndexMap1 = new HashMap<String, Long>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            HashMap<String, Long> resourceIndexMap1 = new HashMap<String, Long>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.438,\"roiDiffDayList\":[0.812,0.729,0.808],\"roiDiffMsList\":[0.791,0.747,0.667],\"scoreList\":[-0.701,-6.802,-3.188],\"secFlowRate\":0.262,\"sucRateDayList\":[0.045,0.076,0.024],\"sucRateMsList\":[0.013,0.057,0.056],\"thiFlowRate\":0.302},\"adxRoiFactorDo\":{\"advertConsumeDay\":29192.0,\"advertConsumeMs\":109.0,\"adxConsumeDay\":25831.94,\"adxConsumeMs\":39.82,\"adxRoiFactor\":0.860002,\"bidCntDay\":633370,\"bidCntMs\":7114,\"lastRealRoi\":1.987332,\"roiDay\":1.130075,\"roiMs\":1.987332,\"sucBidCntDay\":27739,\"sucBidCntMs\":46,\"sucDay\":0.043796,\"sucMs\":0.006467},\"basePrice\":900.0,\"defaultPrice\":900,\"factorExplorationDo\":{\"advertConsumeDay\":28029.0,\"advertConsumeMs\":429.0,\"adxConsumeDay\":24966.25,\"adxConsumeMs\":442.6,\"bidCntDay\":1149811,\"bidCntMs\":9321,\"factorExploreMap\":{\"1\":0.760084,\"2\":0.780084,\"3\":0.880084},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":1.081007,\"2\":1.267959,\"3\":1.384807},\"lastSucRateMap\":{\"1\":0.08099,\"2\":0.055079,\"3\":0.025656},\"roiDay\":1.122677,\"roiMs\":0.969286,\"sucBidCntDay\":26747,\"sucBidCntMs\":509,\"sucDay\":0.023263,\"sucMs\":0.054608,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":401,\"advertConsume\":540,\"adxConsume\":3281930000,\"bid\":15909,\"exp\":359,\"click\":83},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":29192.0,\"advertConsumeMs\":109.0,\"adxConsumeDay\":25831.94,\"adxConsumeMs\":39.82,\"adxRoiFactor\":0.860002,\"bidCntDay\":633370,\"bidCntMs\":7114,\"lastRealRoi\":1.987332,\"roiDay\":1.130075,\"roiMs\":1.987332,\"sucBidCntDay\":27739,\"sucBidCntMs\":46,\"sucDay\":0.043796,\"sucMs\":0.006467},\"lastFactorExplorationDo\":{\"advertConsumeDay\":28029.0,\"advertConsumeMs\":429.0,\"adxConsumeDay\":24966.25,\"adxConsumeMs\":442.6,\"bidCntDay\":1149811,\"bidCntMs\":9321,\"factorExploreMap\":{\"1\":0.760084,\"2\":0.780084,\"3\":0.880084},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":1.081007,\"2\":1.267959,\"3\":1.384807},\"lastSucRateMap\":{\"1\":0.08099,\"2\":0.055079,\"3\":0.025656},\"roiDay\":1.122677,\"roiMs\":0.969286,\"sucBidCntDay\":26747,\"sucBidCntMs\":509,\"sucDay\":0.023263,\"sucMs\":0.054608,\"tryLabel\":0},\"lastMinRoi\":1.39,\"lastPriceExplorationDo\":{\"advertConsumeDay\":20283.0,\"advertConsumeMs\":469.0,\"adxConsumeDay\":20044.01,\"adxConsumeMs\":452.7,\"bidCntDay\":311236,\"bidCntMs\":9318,\"lastRealRoiMap\":{\"1\":1.39,\"2\":0.740741,\"3\":1.078283},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.011602,\"3\":0.267817},\"priceExploreMap\":{\"1\":799.869,\"2\":841.25,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.625,\"3\":0.176},\"roiDay\":1.011925,\"roiMs\":1.036008,\"sucBidCntDay\":23659,\"sucBidCntMs\":532,\"sucDay\":0.076017,\"sucMs\":0.057094,\"tryLabel\":1},\"maxPrice\":2000,\"minPrice\":300,\"minRoi\":1.39,\"priceExplorationDo\":{\"advertConsumeDay\":20283.0,\"advertConsumeMs\":469.0,\"adxConsumeDay\":20044.01,\"adxConsumeMs\":452.7,\"bidCntDay\":311236,\"bidCntMs\":9318,\"lastRealRoiMap\":{\"1\":1.39,\"2\":0.740741,\"3\":1.078283},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.011602,\"3\":0.267817},\"priceExploreMap\":{\"1\":799.869,\"2\":841.25,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.625,\"3\":0.176},\"roiDay\":1.011925,\"roiMs\":1.036008,\"sucBidCntDay\":23659,\"sucBidCntMs\":532,\"sucDay\":0.076017,\"sucMs\":0.057094,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":24539,\"advertConsume\":7498,\"adxConsume\":215673960000,\"bid\":238892,\"exp\":22794,\"click\":5023},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":27776,\"advertConsume\":29236,\"adxConsume\":258633980000,\"bid\":634903,\"exp\":26043,\"click\":5318}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":63,\"advertConsume\":20,\"adxConsume\":553280000,\"bid\":66106,\"exp\":61,\"click\":16}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":6973,\"advertConsume\":7023,\"adxConsume\":59225710000,\"bid\":179582,\"exp\":6574,\"click\":1326}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":16805,\"advertConsume\":13527,\"adxConsume\":142182020000,\"bid\":70032,\"exp\":15791,\"click\":2866}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":12070,\"advertConsume\":12699,\"adxConsume\":113638540000,\"bid\":411618,\"exp\":11290,\"click\":2264}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":11650,\"advertConsume\":12176,\"adxConsume\":108064410000,\"bid\":516579,\"exp\":10834,\"click\":2200}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":3171,\"advertConsume\":3341,\"adxConsume\":29202380000,\"bid\":226540,\"exp\":2983,\"click\":577}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":70,\"advertConsume\":110,\"adxConsume\":585290000,\"bid\":6818,\"exp\":63,\"click\":12}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":938,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":9000000,\"bid\":2551,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":181,\"advertConsume\":265,\"adxConsume\":1503000000,\"bid\":695,\"exp\":167,\"click\":39}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":13,\"advertConsume\":22,\"adxConsume\":116610000,\"bid\":443,\"exp\":12,\"click\":1}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":109,\"advertConsume\":99,\"adxConsume\":913870000,\"bid\":2948,\"exp\":99,\"click\":20}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":21,\"advertConsume\":44,\"adxConsume\":190160000,\"bid\":1441,\"exp\":21,\"click\":10}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastPriceExplorationDo()));
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

