/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaBaseRcmder;
import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxIdeaDQNRcmder {
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] predBucket = new double[]{100.0, 1000.0, 5000.0, 10000.0, 50000.0};
    static double[] predWeight = new double[]{0.05, 0.2, 0.5, 0.8, 1.0};
    static double[] pCpmBucket = new double[]{0.7, 0.8, 0.9, 0.95, 1.0};
    static double[] pCpmWeight = new double[]{0.5, 1.0, 2.0, 10.0, 100.0};
    static double[] pCpmBucket2 = new double[]{1.0, 1.1, 1.3, 1.5, 2.0};
    static double[] pCpmWeight2 = new double[]{100.0, 10.0, 2.0, 1.0, 0.5};

    public static Long ideaRcmd(List<Long> validIdeaList, Map<Long, Double> predRpmMap, Map<Long, AdxIdeaStatDo> adxDayStatDoMap) {
        Long ret = null;
        if (AssertUtil.isEmpty(validIdeaList)) {
            return ret;
        }
        if (predRpmMap == null) {
            predRpmMap = new HashMap<Long, Double>();
        }
        if (adxDayStatDoMap == null) {
            adxDayStatDoMap = new HashMap<Long, AdxIdeaStatDo>(MAP_DF_SIZE);
        }
        adxDayStatDoMap.forEach((ideaId, adxStatDo) -> AdxIdeaBaseRcmder.ideaStatCompute(adxStatDo));
        Map<Long, Double> rpmMap = AdxIdeaDQNRcmder.getMergeRpm(validIdeaList, predRpmMap, adxDayStatDoMap);
        Double bestRpm = AdxIdeaDQNRcmder.getBestRpm(validIdeaList, rpmMap);
        HashMap<Long, Double> weighMap = new HashMap<Long, Double>(MAP_DF_SIZE);
        int size = validIdeaList.size();
        for (int i = 0; i < size; ++i) {
            Long ideaId2 = validIdeaList.get(i);
            Double rpm = rpmMap.get(ideaId2);
            Double weight = AdxIdeaDQNRcmder.getRpmWeight(rpm, bestRpm);
            if (weight != null) {
                weighMap.put(ideaId2, weight);
                continue;
            }
            weighMap.put(ideaId2, 10.0);
        }
        System.out.println("weightMap=" + JSON.toJSONString(weighMap));
        ret = (Long)Roulette.doubleMap(weighMap);
        if (ret == null) {
            ret = validIdeaList.get(0);
        }
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = null;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            ret = bestRpm >= 0.0 ? MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight) : MathBase.getConfidenceWeight(Math.max(ratio, 1.0), pCpmBucket2, pCpmWeight2);
        }
        return ret;
    }

    private static Map<Long, Double> getMergeRpm(List<Long> ideaList, Map<Long, Double> predRpmMap, Map<Long, AdxIdeaStatDo> adxDayStatDoMap) {
        HashMap<Long, Double> ret = new HashMap<Long, Double>(MAP_DF_SIZE);
        if (AssertUtil.isEmpty(predRpmMap)) {
            return null;
        }
        int size = ideaList.size();
        for (int i = 0; i < size; ++i) {
            Long ideaId = ideaList.get(i);
            Double predRpm = predRpmMap.get(ideaId);
            AdxIdeaStatDo adxDayStatDo = adxDayStatDoMap.get(ideaId);
            Double rpm = AdxIdeaDQNRcmder.getMergeRpm(predRpm, adxDayStatDo);
            ret.put(ideaId, rpm);
        }
        return ret;
    }

    private static Double getBestRpm(List<Long> ideaList, Map<Long, Double> rpmMap) {
        Double ret = null;
        if (AssertUtil.isEmpty(rpmMap)) {
            return null;
        }
        int size = ideaList.size();
        for (int i = 0; i < size; ++i) {
            Long ideaId = ideaList.get(i);
            Double rpm = rpmMap.get(ideaId);
            if (rpm == null || ret != null && !(ret < rpm)) continue;
            ret = rpm;
        }
        return ret;
    }

    public static Double getMergeRpm(Double predRpm, AdxIdeaStatDo adxDayStatDo) {
        Double ret = null;
        if (predRpm != null && adxDayStatDo != null && adxDayStatDo.getConfidence().booleanValue()) {
            Double statRpm = adxDayStatDo.getProfitEcpm();
            Long bid = adxDayStatDo.getBid();
            Double w1 = MathBase.getConfidenceWeight(bid.longValue(), predBucket, predWeight);
            Double limitPredRpm = MathBase.noiseSmoother(predRpm, -1.0 * statRpm, 4.0 * statRpm);
            if (statRpm < 0.0) {
                limitPredRpm = MathBase.noiseSmoother(predRpm, 4.0 * statRpm, -1.0 * statRpm);
            }
            ret = w1 * limitPredRpm + (1.0 - w1) * statRpm;
        }
        return ret;
    }
}

