package cn.com.duiba.nezha.alg.alg.base;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;

public class MathBase {




    /**
     * 结果平滑,限定调节范围
     *
     * @param point
     * @param upperLimit
     * @param lowerLimit
     * @return
     * @throws Exception
     */
    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = point;

        if (AssertUtil.isAnyEmpty(upperLimit, lowerLimit)) {
            //logger.warn("noiseSmoother input invalid,with upperLimit=" + upperLimit + ",lowerLimit=" + lowerLimit);
            return ret;
        }

        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }

        return ret;
    }

    /**
     * @param x
     * @param lowerLimit
     * @param upperLimit
     * @param zoom
     * @return
     */
    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {

        return lowerLimit + (upperLimit - lowerLimit) * sigmoidWithZoom(x, zoom);


    }


    /**
     * @param x
     * @param zoom
     * @return
     */
    public static Double sigmoidWithZoom(double x, double zoom) {
        return sigmoid(x * zoom);
    }


    /**
     * @param x
     * @return
     */
    public static Double sigmoid(double x) {
        return 1 / (1 + Math.exp(-x));
    }

}
