/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.plugins.ResPlugInStatModel;
import cn.com.duiba.nezha.alg.alg.vo.plug.PreSelectActResPlugDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActPlugInDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActPlugInDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.98, 1.0};
    static double[] pCpmWeight = new double[]{0.2, 1.0, 2.0, 3.0, 5.0, 100.0};

    public static Map<String, String> feaureParse(ActFeatureDo actFeatureDo) {
        Map staticFeatureMap = ActFeatureParse.generateFeatureMapStatic((ActFeatureDo)actFeatureDo);
        Map dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic((ActFeatureDo)actFeatureDo, (ActFeatureDo)actFeatureDo);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }

    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel) throws Exception {
        return ActPlugInDQNRcmder.rcmdIndexAndIdBase(plugList, actFeatureDo, coderModel, ltfModel, 1, 1.0);
    }

    public static ResPlugInRcmdDo rcmd2(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel) throws Exception {
        return ActPlugInDQNRcmder.rcmdIndexAndIdBase(plugList, actFeatureDo, coderModel, ltfModel, 2, 1.0);
    }

    public static ResPlugInRcmdDo rcmd3(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel, List<PreSelectActResPlugDo> preSelectActResPlugIndexDoList, List<PreSelectActResPlugDo> preSelectActResPlugIdDoList) throws Exception {
        return ActPlugInDQNRcmder.rcmdIndexAndIdBase(plugList, actFeatureDo, coderModel, ltfModel, 2, 1.0);
    }

    public static ResPlugInRcmdDo rcmdIndexAndIdBase(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo, CODER coderModel, LocalTFModel ltfModel, int rcmd_type, Double statWeight) throws Exception {
        ResPlugInRcmdDo ret = null;
        if (ActPlugInDQNRcmder.valid(plugList, actFeatureDo).booleanValue()) {
            Long days = LocalDateUtil.getIntervalDays((String)"2020-01-01", (DateStyle)DateStyle.YYYY_MM_DD);
            HashMap<String, Map> featureMap = new HashMap<String, Map>();
            Map staticFeatureMap = ActFeatureParse.generateFeatureMapStatic((ActFeatureDo)actFeatureDo);
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                resPlugInRcmdDo.setKey();
                String key = resPlugInRcmdDo.getKey();
                ResPlugInStatDo statDo = resPlugInRcmdDo.getResPlugInStatDo();
                resPlugInRcmdDo.setSRpm(ResPlugInStatModel.getRpm(statDo));
                resPlugInRcmdDo.setSRoi(ResPlugInStatModel.getRoi(statDo));
                ActFeatureDo dynamicDo = new ActFeatureDo();
                dynamicDo.setResPlugInId(resPlugInRcmdDo.getResPlugInId());
                dynamicDo.setResPlugInIndex(resPlugInRcmdDo.getResPlugInIndex());
                Map dynamicFeatureMap = ActFeatureParse.generateFeatureMapDynamic((ActFeatureDo)dynamicDo, (ActFeatureDo)actFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(key, dynamicFeatureMap);
            }
            Map pRpmMap = new HashMap();
            if (ActPlugInDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdIndexMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdPlugMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            HashMap<Long, List<ResPlugInRcmdDo>> rcmdPlugAllMap = new HashMap<Long, List<ResPlugInRcmdDo>>();
            HashMap<String, ResPlugInRcmdDo> rcmdMap = new HashMap<String, ResPlugInRcmdDo>();
            for (ResPlugInRcmdDo resPlugInRcmdDo : plugList) {
                String key = resPlugInRcmdDo.getKey();
                Double pRpm = (Double)pRpmMap.get(key);
                resPlugInRcmdDo.setPRpm(pRpm);
                Double mergeRpm = ActPlugInDQNRcmder.getMergeRpm(pRpm, resPlugInRcmdDo.getSRpm(), statWeight);
                resPlugInRcmdDo.setMergeRpm(mergeRpm);
                Long plugId = resPlugInRcmdDo.getResPlugInId();
                Long plugIndex = resPlugInRcmdDo.getResPlugInIndex();
                if (!rcmdIndexMap.containsKey(plugIndex)) {
                    rcmdIndexMap.put(plugIndex, new ArrayList());
                }
                if (plugId != null && !rcmdPlugMap.containsKey(plugId)) {
                    rcmdPlugMap.put(plugId, new ArrayList());
                }
                if (!rcmdPlugAllMap.containsKey(plugId)) {
                    rcmdPlugAllMap.put(plugId, new ArrayList());
                }
                if (plugId != null && plugIndex != null && plugIndex > 4L || plugId != null && plugIndex == null && plugIndex > 4L || plugId == null && plugIndex != null) continue;
                ((List)rcmdIndexMap.get(plugIndex)).add(resPlugInRcmdDo);
                if (plugId != null) {
                    ((List)rcmdPlugMap.get(plugId)).add(resPlugInRcmdDo);
                }
                ((List)rcmdPlugAllMap.get(plugId)).add(resPlugInRcmdDo);
                System.out.println(plugId + "-" + plugIndex);
                rcmdMap.put(plugId + "-" + plugIndex, resPlugInRcmdDo);
            }
            if (rcmd_type == 2) {
                ret = ActPlugInDQNRcmder.rcmdWithMap3(rcmdIndexMap, rcmdPlugMap, rcmdMap);
            }
            if (rcmd_type == 1) {
                ret = ActPlugInDQNRcmder.rcmdWithMap2041(rcmdPlugAllMap);
            }
        }
        return ret;
    }

    private static Boolean valid(List<ResPlugInRcmdDo> plugList, ActFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{plugList, actFeatureDo})) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ResPlugInRcmdDo.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap3(Map<Long, List<ResPlugInRcmdDo>> plugIndexMap, Map<Long, List<ResPlugInRcmdDo>> plugIdMap, Map<String, ResPlugInRcmdDo> rcmdMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{plugIndexMap, plugIdMap})) {
            HashMap<Long, ResPlugInStatDo> indexMap = new HashMap<Long, ResPlugInStatDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugIndexMap.entrySet()) {
                Long index = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                ResPlugInStatDo resPlugInStatDo = ResPlugInStatModel.mergeIndexList(plugIndexList);
                indexMap.put(index, resPlugInStatDo);
            }
            Long plugIndex = ActPlugInDQNRcmder.rcmdIndex(indexMap);
            List<ResPlugInRcmdDo> indexPlugList = plugIndexMap.get(plugIndex);
            if (plugIndex == null) {
                ret = ActPlugInDQNRcmder.rcmd(indexPlugList, false);
            } else {
                HashMap<Long, ResPlugInStatDo> idMap = new HashMap<Long, ResPlugInStatDo>();
                for (Map.Entry entry : plugIdMap.entrySet()) {
                    Long id = (Long)entry.getKey();
                    List plugIdList = (List)entry.getValue();
                    ResPlugInStatDo idStatDo = ResPlugInStatModel.mergeIdList(plugIdList);
                    idMap.put(id, idStatDo);
                }
                Long plugId = ActPlugInDQNRcmder.rcmdId(idMap);
                ret = rcmdMap.get(plugId + "-" + plugIndex);
            }
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap2(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            List<ResPlugInRcmdDo> plugIndexList;
            ArrayList<ResPlugInRcmdDo> plugList = new ArrayList<ResPlugInRcmdDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                ResPlugInRcmdDo plugRcmdDo;
                List<ResPlugInRcmdDo> plugIndexList2 = entry.getValue();
                if (AssertUtil.isEmpty(plugIndexList2)) continue;
                if (plugIndexList2.size() == 1) {
                    plugRcmdDo = plugIndexList2.get(0);
                    plugList.add(plugRcmdDo);
                    continue;
                }
                plugRcmdDo = ActPlugInDQNRcmder.getBestIndex(plugIndexList2);
                if (plugRcmdDo == null) continue;
                plugList.add(plugRcmdDo);
            }
            ret = ActPlugInDQNRcmder.rcmd(plugList, false);
            if (ret != null && ret.getResPlugInId() != null && (plugIndexList = plugMap.get(ret.getResPlugInId())) != null && plugIndexList.size() > 1) {
                ret = ActPlugInDQNRcmder.rcmd(plugIndexList, true);
            }
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            ArrayList<ResPlugInRcmdDo> plugList = new ArrayList<ResPlugInRcmdDo>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                ResPlugInRcmdDo plugRcmdDo;
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (plugIndexList != null && plugIndexList.size() == 1) {
                    plugRcmdDo = plugIndexList.get(0);
                    plugList.add(plugRcmdDo);
                    continue;
                }
                plugRcmdDo = ActPlugInDQNRcmder.rcmd(plugIndexList, true);
                if (plugRcmdDo == null) continue;
                plugList.add(plugRcmdDo);
            }
            ret = ActPlugInDQNRcmder.rcmd(plugList, false);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmdWithMap2041(Map<Long, List<ResPlugInRcmdDo>> plugMap) {
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isNotEmpty(plugMap)) {
            HashMap<Long, ResPlugInRcmdDo> plugIndexMap = new HashMap<Long, ResPlugInRcmdDo>();
            HashMap<ResPlugInRcmdDo, Double> weightMap = new HashMap<ResPlugInRcmdDo, Double>();
            for (Map.Entry<Long, List<ResPlugInRcmdDo>> entry : plugMap.entrySet()) {
                Long plugId = entry.getKey();
                List<ResPlugInRcmdDo> plugIndexList = entry.getValue();
                if (plugId == null) {
                    if (!AssertUtil.isNotEmpty(plugIndexList)) continue;
                    plugIndexMap.put(null, plugIndexList.get(0));
                    weightMap.put(plugIndexList.get(0), 1.0);
                    continue;
                }
                if (!plugId.equals(2041L) || !AssertUtil.isNotEmpty(plugIndexList)) continue;
                for (int i = 0; i < plugIndexList.size(); ++i) {
                    ResPlugInRcmdDo resPlugInRcmdDo = plugIndexList.get(i);
                    if (resPlugInRcmdDo == null) continue;
                    plugIndexMap.put(resPlugInRcmdDo.getResPlugInIndex(), resPlugInRcmdDo);
                    weightMap.put(resPlugInRcmdDo, 1.0);
                }
            }
            ret = (ResPlugInRcmdDo)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static ResPlugInRcmdDo getBestIndex(List<ResPlugInRcmdDo> plugIndexList) {
        ResPlugInRcmdDo ret = null;
        long size = plugIndexList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        int i = 0;
        while ((long)i < size) {
            ResPlugInRcmdDo plugDo = plugIndexList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
                ret = plugDo;
            }
            ++i;
        }
        if (ret == null && plugIndexList != null) {
            ret = plugIndexList.get(0);
        }
        return ret;
    }

    public static Long rcmdIndex(Map<Long, ResPlugInStatDo> indexMap) {
        Long ret = null;
        Double bestRpm = null;
        Long bestIndex = null;
        if (AssertUtil.isNotEmpty(indexMap)) {
            Double rpm;
            ArrayList<Long> indexList = new ArrayList<Long>(indexMap.keySet());
            int size = indexList.size();
            HashMap<Long, Double> indexRpmMap = new HashMap<Long, Double>();
            for (int i = 0; i < size; ++i) {
                Long index = (Long)indexList.get(i);
                ResPlugInStatDo statDo = indexMap.get(index);
                rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index, rpm);
                if (rpm == null || index == null || bestRpm != null && !(bestRpm < rpm)) continue;
                bestRpm = rpm;
                bestIndex = index;
            }
            HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
            for (int i = 0; i < size; ++i) {
                Long index = (Long)indexList.get(i);
                rpm = (Double)indexRpmMap.get(index);
                if (index != null && index.equals(bestIndex)) {
                    weightMap.put(index, 85.0);
                    continue;
                }
                weightMap.put(index, 3.0);
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static Long rcmdId(Map<Long, ResPlugInStatDo> indexMap) {
        Long ret = null;
        Double bestRpm = null;
        Long bestIndex = null;
        if (AssertUtil.isNotEmpty(indexMap)) {
            Long index;
            int i;
            ArrayList<Long> indexList = new ArrayList<Long>(indexMap.keySet());
            int size = indexList.size();
            HashMap<Long, Double> indexRpmMap = new HashMap<Long, Double>();
            for (int i2 = 0; i2 < size; ++i2) {
                Long index2 = (Long)indexList.get(i2);
                ResPlugInStatDo statDo = indexMap.get(index2);
                Double rpm = ResPlugInStatModel.getRpm(statDo);
                indexRpmMap.put(index2, rpm);
                if (rpm == null || bestRpm != null && !(bestRpm < rpm)) continue;
                bestRpm = rpm;
                bestIndex = index2;
            }
            HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
            Double weightSum = 0.0;
            for (i = 0; i < size; ++i) {
                index = (Long)indexList.get(i);
                Double rpm = (Double)indexRpmMap.get(index);
                Double weight = ActPlugInDQNRcmder.getRpmWeight(rpm, bestRpm);
                if (rpm == null) {
                    weight = 2.0;
                }
                if (weight != null) {
                    weightMap.put(index, weight);
                    weightSum = weightSum + weight;
                    continue;
                }
                weightMap.put(index, 1.0);
                weightSum = weightSum + 1.0;
            }
            for (i = 0; i < size; ++i) {
                Double weightOther;
                index = (Long)indexList.get(i);
                Double weight = (Double)weightMap.get(index);
                if (bestRpm == null) continue;
                if (bestIndex != null && bestIndex.equals(index) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.85 / 0.15000000000000002;
                    weightSum = weightOther + weight;
                    weightMap.put(index, weight);
                }
                if (bestIndex != null || index != null || !(weight < weightSum)) continue;
                weightOther = weightSum - weight;
                weight = weightOther * 0.85 / 0.15000000000000002;
                weightSum = weightOther + weight;
                weightMap.put(index, weight);
            }
            ret = (Long)Roulette.doubleMap(weightMap);
        }
        return ret;
    }

    public static ResPlugInRcmdDo rcmd(List<ResPlugInRcmdDo> plugList, boolean isIndex) {
        Double weight;
        ResPlugInRcmdDo ret = null;
        if (AssertUtil.isEmpty(plugList)) {
            return ret;
        }
        long size = plugList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        Double baseRpm = null;
        if (size == 1L) {
            return plugList.get(0);
        }
        int i = 0;
        while ((long)i < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            if (plugDo.getResPlugInId() == null && plugDo.getResPlugInIndex() == null) {
                baseRpm = plugDo.getMergeRpm();
            }
            ++i;
        }
        HashMap<ResPlugInRcmdDo, Double> weightMap = new HashMap<ResPlugInRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ResPlugInRcmdDo plugDo = plugList.get(i2);
            Double rpm = plugDo.getMergeRpm();
            weight = ActPlugInDQNRcmder.getRpmWeight(rpm, bestRpm);
            if (plugDo.getSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 1.0, 2.0);
            }
            if (plugDo.getSRpm() != null && weight < 1.0 && Math.random() > 0.5) {
                weight = 0.1;
            }
            if (weight != null) {
                weightMap.put(plugDo, weight);
                weightSum = weightSum + weight;
            } else {
                weightMap.put(plugDo, 1.0);
                weightSum = weightSum + 1.0;
            }
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            Double weightOther;
            ResPlugInRcmdDo plugDo = (ResPlugInRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (isIndex) {
                if (plugDo.getResPlugInIndex() == 3L && weight > weightSum * 0.05 && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.05 / 0.95;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
                if (bestRpmKey != null && plugDo != null && bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.9 / 0.09999999999999998;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
            }
            if (!isIndex) {
                if (plugDo.getResPlugInIndex() == null && weight > weightSum * 0.2 && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.2 / 0.8;
                    weightSum = weightOther + weight;
                    weightMap.put(plugDo, weight);
                }
                if (bestRpmKey != null && plugDo != null && plugDo.getSRpm() != null && bestRpmKey.equals(plugDo.getKey()) && weight < weightSum) {
                    weightOther = weightSum - weight;
                    weight = weightOther * 0.85 / 0.15000000000000002;
                    weightSum = weightOther + weight;
                }
            }
            weightMap.put(plugDo, weight);
        }
        ret = (ResPlugInRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    private static Double getMergeRpm(Double pRpm, Double sRpm, double statWeight) {
        Double ret = pRpm;
        if (pRpm == null) {
            ret = sRpm;
        }
        if (sRpm != null && pRpm != null) {
            if (sRpm <= 0.0) {
                sRpm = 0.0;
            } else {
                pRpm = MathBase.noiseSmoother(pRpm, 0.5 * sRpm, 2.0 * sRpm);
            }
            ret = (1.0 - statWeight) * pRpm + statWeight * sRpm;
        }
        return ret;
    }

    private static boolean filter(Long plugInId) {
        Long days = LocalDateUtil.getIntervalDays((String)"2020-01-01", (DateStyle)DateStyle.YYYY_MM_DD);
        return ActPlugInDQNRcmder.filter(plugInId, days, 1L);
    }

    private static boolean filter(Long plugInId, Long days, Long slotId) {
        boolean ret = true;
        if (plugInId != null && slotId != null && days != null) {
            Long dayRet = days % 4L;
            Long plugRet = plugInId % 2L;
            Long slotRet = slotId % 2L;
            if (slotRet == 0L) {
                if ((dayRet == 0L || dayRet == 1L) && plugRet == 1L) {
                    ret = false;
                }
                if ((dayRet == 2L || dayRet == 3L) && plugRet == 0L) {
                    ret = false;
                }
            } else {
                if ((dayRet == 0L || dayRet == 1L) && plugRet == 0L) {
                    ret = false;
                }
                if ((dayRet == 2L || dayRet == 3L) && plugRet == 1L) {
                    ret = false;
                }
            }
        }
        if (plugInId != null && plugInId.equals(2041L)) {
            ret = false;
        }
        return ret;
    }
}

