package cn.com.duiba.nezha.alg.alg.vo.adx.directly;

import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;

import java.util.ArrayList;
import java.util.Map;


/**
 * 出价统计信息
 * 参照指标key定义：\cn\com\duiba\nezha\alg\alg\enums\AdxIndex.java
 */

public class AdxDirectlyIdeaDo {


    /**
     * 创意最低出价(分/cpm)
     */
    private Long minPrice;

    /**
     * 创意最高出价(分/cpm)
     */
    private Long maxPrice;

    /**
     * 底价(分/cpm) 来源：adx请求
     */
    private Double basePrice;

    /**
     * 最低ROI-当前(小数，如1.50)
     */
    private Double minRoi;

    /**
     * 最低ROI-上一次(小数，如1.50)
     */
    private Double lastMinRoi;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;

    /**
     * 出价方式
     */
    private Integer priceType;

    /**
     * 直投CPC出价(分/单次点击)
     */
    private Double directlyCpcPrice;

    /**
     * 直投CTR预估
     */
    private Double directlyPreCtr;


    /**
     * 全天：分策略-分level-分指标-值
     */
    private ArrayList<AdxStrategyDo> strategyDayDoList;

    /**
     * 实时：分策略-分level-分指标-值
     */
    private ArrayList<AdxStrategyDo> strategyMsDoList;

    /**
     * 实时：创意维度统计数据
     */
    private Map<String, Long> ideaIndexMap;

    /**
     * 实时：资源维度统计数据（统计直投创意）
     */
    private Map<String, Long> resourceIndexMap;


    public Long getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Long minPrice) {
        this.minPrice = minPrice;
    }

    public Long getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Long maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Double getBasePrice() {
        return basePrice;
    }

    public void setBasePrice(Double basePrice) {
        this.basePrice = basePrice;
    }

    public Double getMinRoi() {
        return minRoi;
    }

    public void setMinRoi(Double minRoi) {
        this.minRoi = minRoi;
    }

    public Double getLastMinRoi() {
        return lastMinRoi;
    }

    public void setLastMinRoi(Double lastMinRoi) {
        this.lastMinRoi = lastMinRoi;
    }

    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType) {
        this.feeType = feeType;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public Double getDirectlyCpcPrice() {
        return directlyCpcPrice;
    }

    public void setDirectlyCpcPrice(Double directlyCpcPrice) {
        this.directlyCpcPrice = directlyCpcPrice;
    }

    public Double getDirectlyPreCtr() {
        return directlyPreCtr;
    }

    public void setDirectlyPreCtr(Double directlyPreCtr) {
        this.directlyPreCtr = directlyPreCtr;
    }

    public ArrayList<AdxStrategyDo> getStrategyDayDoList() {
        return strategyDayDoList;
    }

    public void setStrategyDayDoList(ArrayList<AdxStrategyDo> strategyDayDoList) {
        this.strategyDayDoList = strategyDayDoList;
    }

    public ArrayList<AdxStrategyDo> getStrategyMsDoList() {
        return strategyMsDoList;
    }

    public void setStrategyMsDoList(ArrayList<AdxStrategyDo> strategyMsDoList) {
        this.strategyMsDoList = strategyMsDoList;
    }

    public Map<String, Long> getIdeaIndexMap() {
        return ideaIndexMap;
    }

    public void setIdeaIndexMap(Map<String, Long> ideaIndexMap) {
        this.ideaIndexMap = ideaIndexMap;
    }

    public Map<String, Long> getResourceIndexMap() {
        return resourceIndexMap;
    }

    public void setResourceIndexMap(Map<String, Long> resourceIndexMap) {
        this.resourceIndexMap = resourceIndexMap;
    }
}
