/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleRcmdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActTitleFeatureParse;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActTitlePrizeDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActTitlePrizeDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.98, 1.0};
    static double[] pCpmWeight = new double[]{0.1, 1.0, 2.0, 5.0, 10.0, 100.0};

    public static ActTitleRcmdDo rcmd2(CODER coderModel, LocalTFModel ltfModel, ActTitleRcmdDo actTitleRcmdDo, List<Long> subTitlePrizeList) throws Exception {
        ActTitleRcmdDo ret = null;
        if (ActTitlePrizeDQNRcmder.valid(actTitleRcmdDo, subTitlePrizeList).booleanValue()) {
            HashMap<Long, Map> featureMap = new HashMap<Long, Map>();
            ArrayList actTitleRcmdDoList = new ArrayList();
            Map<String, String> staticFeatureMap = actTitleRcmdDo.getFeatureMap();
            for (Long subTitlePrizeId : subTitlePrizeList) {
                Map dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapPrizeId((Long)subTitlePrizeId);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(subTitlePrizeId, dynamicFeatureMap);
            }
            Map<Long, Double> pRpmMap = new HashMap<Long, Double>();
            if (ActTitlePrizeDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            Long bestPrizeId = ActTitlePrizeDQNRcmder.rcmdPrizeId(pRpmMap);
            actTitleRcmdDo.setActivitySubTitlePrizeId(bestPrizeId);
            actTitleRcmdDo.setpPrizeRpm(pRpmMap.get(bestPrizeId));
            ret = actTitleRcmdDo;
        }
        return ret;
    }

    public static Long rcmdPrizeId(Map<Long, Double> pRpmMap) {
        Long key;
        Long ret = null;
        if (AssertUtil.isEmpty(pRpmMap)) {
            return ret;
        }
        long size = pRpmMap.size();
        Double bestRpm = null;
        Long bestRpmKey = null;
        for (Map.Entry<Long, Double> entry : pRpmMap.entrySet()) {
            Long key2 = entry.getKey();
            Double d = entry.getValue();
            if (d == null || bestRpm != null && !(bestRpm < d)) continue;
            bestRpm = d;
            bestRpmKey = key2;
        }
        HashMap<Long, Double> weightMap = new HashMap<Long, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        for (Map.Entry<Long, Double> entry : pRpmMap.entrySet()) {
            key = entry.getKey();
            Double rpm = entry.getValue();
            Double weight = ActTitlePrizeDQNRcmder.getRpmWeight(rpm, bestRpm);
            if (rpm == null || weight == null) {
                weight = 1.0;
            }
            weightSum = weightSum + weight;
            weightMap.put(key, weight);
        }
        for (Map.Entry<Long, Double> entry : weightMap.entrySet()) {
            key = entry.getKey();
            Double weight = entry.getValue();
            if (bestRpmKey == null || !bestRpmKey.equals(key) || !(weight < weightSum * 0.8)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * 0.8 / 0.19999999999999996;
            weightSum = weightOther + weight;
            weightMap.put(key, weight);
        }
        ret = (Long)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getMergeRpm(ActTitleRcmdDo actTitleRcmdDo) {
        Double ret = null;
        if (actTitleRcmdDo != null) {
            Double actSRpm = actTitleRcmdDo.getCpv();
            Double actSubSRpm = actTitleRcmdDo.getSubCpv();
            Double pRpm = actTitleRcmdDo.getpRpm();
            if (pRpm == null) {
                return ret;
            }
            ret = pRpm;
            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            if (actSubSRpm == null) {
                actSubSRpm = actSRpm;
            }
            ret = 0.5 * pRpm + 0.3 * actSRpm + 0.2 * actSubSRpm;
        }
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    private static Boolean valid(ActTitleRcmdDo actTitleRcmdDo, List<Long> subTitlePriceList) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actTitleRcmdDo, subTitlePriceList})) {
            logger.error("ActTitlePrizeDQNRcmder.rcmd() input valid ,params actTitleRcmdDo, subTitlePriceListo is null");
            ret = false;
        }
        if (AssertUtil.isEmpty(actTitleRcmdDo.getFeatureMap())) {
            logger.error("ActTitlePrizeDQNRcmder.rcmd() input valid ,params featureMap  is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }
}

