/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo, Double roiFactor, Map<String, Long> advertConsume) {
        Double defaultMinRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double lowerLimit = 0.3;
        Double upperLimit = 1.7;
        Double defaultPreCtr = 0.07;
        Double defaultClickValue = 5.0;
        Long advertConsumeDayLimit = 500L;
        Long advertConsumeMsLimit = 500L;
        Long ret = Math.round(Math.floor(defaultPreCtr * defaultClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
        if (AssertUtil.isNotEmpty((Object)adxDoInfo)) {
            Double statCtr = adxDoInfo.getStatCtr();
            Double statCtrResource = adxDoInfo.getStatCtrResource();
            Double currentPreValue = adxDoInfo.getCurrentPreValue();
            Double statClickValue = adxDoInfo.getStatClickValue();
            Double statClickValueResource = adxDoInfo.getStatClickValueResource();
            Double predClickValue = adxDoInfo.getPredClickValue();
            if (statCtrResource == null || statCtrResource < 0.0) {
                statCtrResource = defaultPreCtr;
            }
            if (statCtr == null || statCtr < 0.0) {
                statCtr = statCtrResource;
            }
            if (statClickValueResource == null || statClickValueResource < 0.0) {
                statClickValueResource = defaultClickValue;
            }
            if (statClickValue == null || statClickValue < 0.0) {
                statClickValue = statClickValueResource;
            }
            Double preCtr = statCtr;
            Double preClickValue = statClickValue;
            if (AssertUtil.isNotEmpty(advertConsume)) {
                Long ideaAdvertConsumeDay = StrategyBid.nullToDefault(advertConsume.get("ideaDay"), 0L);
                Long ideaAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("ideaMs"), 0L);
                Long resoAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("resourceMs"), 0L);
                preCtr = DataUtil.division((Double)((double)ideaAdvertConsumeMs.longValue() * statCtr + (double)advertConsumeMsLimit.longValue() * statCtrResource), (Long)(ideaAdvertConsumeMs + advertConsumeMsLimit), (int)6);
                preClickValue = DataUtil.division((Double)((double)ideaAdvertConsumeMs.longValue() * statClickValue + (double)advertConsumeMsLimit.longValue() * statClickValueResource), (Long)(ideaAdvertConsumeMs + advertConsumeMsLimit), (int)6);
                if (ideaAdvertConsumeDay < advertConsumeDayLimit) {
                    preCtr = statCtrResource;
                    preClickValue = statClickValueResource;
                }
            }
            Double conCtr = AdxBidding.getConCtr(preCtr, currentPreValue);
            if (predClickValue != null && predClickValue >= 0.0) {
                preClickValue = StrategyBid.getNormalValue(predClickValue, preClickValue, preClickValue * 0.0, preClickValue * 4.0);
            }
            roiFactor = StrategyBid.getNormalValue(roiFactor, defaultRoiFactor, lowerLimit, upperLimit);
            Double minRoi = StrategyBid.nullToDefault(adxDoInfo.getMinRoi(), defaultMinRoi);
            ret = Math.round(Math.floor(conCtr * preClickValue * 1000.0 / (minRoi * roiFactor)));
        }
        return ret;
    }

    public static Double getConCtr(Double statValue, Double modelPreValue) {
        Double preCtrFactor = 0.5;
        Double defaultCtr = 0.07;
        Double fUpperLimit = 4.0;
        Double fLowerLimit = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        statValue = StrategyBid.getNormalValue(statValue, defaultCtr, vLowerLimit, vUpperLimit);
        modelPreValue = StrategyBid.getNormalValue(modelPreValue, statValue, statValue * fLowerLimit, statValue * fUpperLimit);
        Double ret = preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue;
        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Long> advertConsumeInfo = new HashMap<String, Long>();
            advertConsumeInfo.put("ideaDay", 2000L);
            advertConsumeInfo.put("ideaMs", 2000L);
            advertConsumeInfo.put("resourceMs", 2000L);
            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(1.0);
            adxDoInfo1.setCurrentPreValue(0.50164);
            adxDoInfo1.setStatCtr(0.953488372);
            adxDoInfo1.setStatClickValue(0.341463415);
            adxDoInfo1.setStatCtrResource(0.978723404);
            adxDoInfo1.setStatClickValueResource(0.25);
            adxDoInfo1.setPredClickValue(null);
            Double roiFactor = 1.0;
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo1, roiFactor, advertConsumeInfo);
            System.out.println("testGetAdxParPrice:" + JSON.toJSONString((Object)testParPrice));
            System.out.println("getConCtr:" + JSON.toJSONString((Object)AdxBidding.getConCtr(0.6, 0.1)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

