/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxRoiFactorDo ret = new AdxRoiFactorDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double tryStep = 0.03;
            Double sucAbsLowLimit = 0.05;
            Double sucAbsUppLimit = 0.95;
            Double sucOppLowLimit = 0.2;
            Double lastRoi = 0.0;
            Double factor = defaultFactor;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            Double adxConsumeTs = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty((Object)lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);
                }
                Long defaultConsume = 0L;
                Long defaultCnt = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                roiMs = StrategyBid.getRoi(strategyFirMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyFirDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyFirDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                if (AssertUtil.isNotEmpty((Object)lastRoiFactor)) {
                    Double lastAdxConsumeTs = lastRoiFactor.getAdxConsumeTs();
                    adxConsumeTs = StrategyBid.getSumDecayIndex(lastAdxConsumeTs, adxConsumeMs);
                }
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 5L || bidCntMs == 0L) {
                    factor = defaultFactor;
                } else {
                    Double confidentAdxConsume = StrategyBid.getConfidentAdxConsume(roiMs);
                    if (adxConsumeMs < confidentAdxConsume) {
                        factor = factor + -StrategyBid.getFirTryStep(adxConsumeMs, confidentAdxConsume).doubleValue();
                    } else if (feeType != null && feeType == 1) {
                        Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                        factor = AdxRoiFactor.getFactorUpdate(factor, roiStable, minRoi);
                    } else {
                        factor = AdxRoiFactor.getFactorUpdate(factor, roiMs, minRoi);
                    }
                }
                lastRoi = roiMs;
            }
            factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit), (int)6);
            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
            ret.setAdxConsumeTs(adxConsumeTs);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }
        return ret;
    }

    public static Double getFactorUpdate(Double lastValue, Double realRoi, Double targetRoi) {
        Double ret = lastValue;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{realRoi, targetRoi})) {
            Double diff = Math.abs(DataUtil.division((Double)realRoi, (Double)targetRoi, (int)3));
            ret = diff < 0.9 ? Double.valueOf(ret + (0.03 + Math.min(1.0 - diff / 0.9, 1.0) * 0.02)) : (diff < 0.98 ? Double.valueOf(ret + (0.01 + Math.min(1.0 - (diff - 0.9) / 0.07999999999999996, 1.0) * 0.01)) : (diff < 1.1 ? Double.valueOf(ret + (-0.01 - Math.min((diff - 0.98) / 0.1200000000000001, 1.0) * 0.01)) : Double.valueOf(ret + (-0.03 - Math.min(diff / 1.1, 1.0) * 0.02))));
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double[] v1 = new Double[]{0.2, 0.5, 0.8, 1.0};
            System.out.println("ret1:" + JSON.toJSONString((Object)StrategyBid.bucket(0.0, v1)));
            Double v2 = 0.0;
            Double v3 = 1.0;
            Double[] v4 = new Double[]{0.0, 0.9, 1.1};
            System.out.println("bucket2:" + JSON.toJSONString((Object)StrategyBid.bucket(v2, v3, v4)));
            Double f1 = 1.0;
            Double roi1 = 1.177;
            Double roi2 = 1.2;
            Double suc1 = 0.8;
            Double suc2 = 0.8;
            System.out.println("getFactorUpdate:" + JSON.toJSONString((Object)AdxRoiFactor.getFactorUpdate(f1, roi1, roi2)));
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.334,\"roiDiffDayList\":[0.829,0.804,0.892],\"roiDiffMsList\":[0.599,0.62,0.945],\"scoreList\":[-4.249,-7.882,2.724],\"secFlowRate\":0.101,\"sucRateDayList\":[0.049,0.089,0.031],\"sucRateMsList\":[0.056,0.102,0.032],\"thiFlowRate\":0.567},\"adxRoiFactorDo\":{\"advertConsumeDay\":24480.0,\"advertConsumeMs\":1546.0,\"adxConsumeDay\":21128.43,\"adxConsumeMs\":1527.32,\"adxRoiFactor\":0.693366,\"bidCntDay\":466430,\"bidCntMs\":26078,\"lastRealRoi\":1.012235,\"roiDay\":1.158629,\"roiMs\":1.012235,\"sucBidCntDay\":22940,\"sucBidCntMs\":1702,\"sucDay\":0.049183,\"sucMs\":0.065266},\"basePrice\":900.0,\"defaultPrice\":900,\"factorExplorationDo\":{\"advertConsumeDay\":11588.0,\"advertConsumeMs\":2060.0,\"adxConsumeDay\":9355.07,\"adxConsumeMs\":1569.43,\"bidCntDay\":334078,\"bidCntMs\":55315,\"factorExploreMap\":{\"1\":0.648287,\"2\":0.668287,\"3\":0.698287},\"factorFlowRateMap\":{\"1\":0.15,\"2\":0.7,\"3\":0.15},\"lastRealRoiMap\":{\"1\":1.321305,\"2\":1.767463,\"3\":1.947211},\"lastSucRateMap\":{\"1\":0.042533,\"2\":0.010043,\"3\":0.006962},\"roiDay\":1.238689,\"roiMs\":1.312587,\"sucBidCntDay\":10300,\"sucBidCntMs\":1712,\"sucDay\":0.030832,\"sucMs\":0.030951,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":2966,\"advertConsume\":2927,\"adxConsume\":26510350000,\"bid\":62164,\"exp\":2718,\"click\":568},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":24480.0,\"advertConsumeMs\":1546.0,\"adxConsumeDay\":21128.43,\"adxConsumeMs\":1527.32,\"adxRoiFactor\":0.693366,\"bidCntDay\":466430,\"bidCntMs\":26078,\"lastRealRoi\":1.012235,\"roiDay\":1.158629,\"roiMs\":1.012235,\"sucBidCntDay\":22940,\"sucBidCntMs\":1702,\"sucDay\":0.049183,\"sucMs\":0.065266},\"lastFactorExplorationDo\":{\"advertConsumeDay\":11588.0,\"advertConsumeMs\":2060.0,\"adxConsumeDay\":9355.07,\"adxConsumeMs\":1569.43,\"bidCntDay\":334078,\"bidCntMs\":55315,\"factorExploreMap\":{\"1\":0.648287,\"2\":0.668287,\"3\":0.698287},\"factorFlowRateMap\":{\"1\":0.15,\"2\":0.7,\"3\":0.15},\"lastRealRoiMap\":{\"1\":1.321305,\"2\":1.767463,\"3\":1.947211},\"lastSucRateMap\":{\"1\":0.042533,\"2\":0.010043,\"3\":0.006962},\"roiDay\":1.238689,\"roiMs\":1.312587,\"sucBidCntDay\":10300,\"sucBidCntMs\":1712,\"sucDay\":0.030832,\"sucMs\":0.030951,\"tryLabel\":0},\"lastMinRoi\":1.39,\"lastPriceExplorationDo\":{\"advertConsumeDay\":16172.0,\"advertConsumeMs\":860.0,\"adxConsumeDay\":14482.01,\"adxConsumeMs\":1041.3,\"bidCntDay\":192027,\"bidCntMs\":12193,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.825892},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.219328},\"priceExploreMap\":{\"1\":743.544,\"2\":808.202,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.705,\"3\":0.096},\"roiDay\":1.116698,\"roiMs\":0.825892,\"sucBidCntDay\":17036,\"sucBidCntMs\":1246,\"sucDay\":0.088717,\"sucMs\":0.10219,\"tryLabel\":1},\"maxPrice\":2000,\"minPrice\":300,\"minRoi\":1.39,\"priceExplorationDo\":{\"advertConsumeDay\":16172.0,\"advertConsumeMs\":860.0,\"adxConsumeDay\":14482.01,\"adxConsumeMs\":1041.3,\"bidCntDay\":192027,\"bidCntMs\":12193,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.825892},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.219328},\"priceExploreMap\":{\"1\":743.544,\"2\":808.202,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.705,\"3\":0.096},\"roiDay\":1.116698,\"roiMs\":0.825892,\"sucBidCntDay\":17036,\"sucBidCntMs\":1246,\"sucDay\":0.088717,\"sucMs\":0.10219,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":14193,\"advertConsume\":12491,\"adxConsume\":122151300000,\"bid\":267445,\"exp\":13164,\"click\":3057},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":23014,\"advertConsume\":24529,\"adxConsume\":211913100000,\"bid\":469784,\"exp\":21630,\"click\":4472}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":63,\"advertConsume\":20,\"adxConsume\":553280000,\"bid\":42598,\"exp\":61,\"click\":16}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":6907,\"advertConsume\":6981,\"adxConsume\":58649710000,\"bid\":114016,\"exp\":6510,\"click\":1313}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":10255,\"advertConsume\":9331,\"adxConsume\":87201020000,\"bid\":42253,\"exp\":9682,\"click\":1781}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":5542,\"advertConsume\":6753,\"adxConsume\":50788050000,\"bid\":165234,\"exp\":5218,\"click\":1102}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5083,\"advertConsume\":5003,\"adxConsume\":45821910000,\"bid\":133670,\"exp\":4783,\"click\":1009}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1316,\"advertConsume\":1403,\"adxConsume\":11800410000,\"bid\":72915,\"exp\":1239,\"click\":263}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1200,\"advertConsume\":1375,\"adxConsume\":10943270000,\"bid\":20214,\"exp\":1116,\"click\":227}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":1301,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":4299,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":178,\"advertConsume\":140,\"adxConsume\":1512000000,\"bid\":846,\"exp\":168,\"click\":30}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":280,\"advertConsume\":181,\"adxConsume\":2535760000,\"bid\":5381,\"exp\":259,\"click\":45}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1124,\"advertConsume\":1063,\"adxConsume\":10162870000,\"bid\":24090,\"exp\":1040,\"click\":228}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":186,\"advertConsume\":168,\"adxConsume\":1688910000,\"bid\":5221,\"exp\":172,\"click\":38}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(null);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

