/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.intercept.ActInterceptStatModel;
import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectActInterceptDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActInterceptFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActInterceptDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActInterceptDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.99, 1.0};
    static double[] pCpmWeight = new double[]{0.1, 1.0, 2.0, 2.0, 5.0, 100.0};

    public static Map<String, String> featureParse(ActInterceptFeatureDo actFeatureDo, Double rpm) {
        Map staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic((ActInterceptFeatureDo)actFeatureDo);
        Map dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamic((ActInterceptFeatureDo)actFeatureDo, (ActInterceptFeatureDo)actFeatureDo, (Double)rpm);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }

    public static ActInterceptRcmdDo rcmd(CODER coderModel, LocalTFModel ltfModel, List<Long> actInterceptDoList, List<PreSelectActInterceptDo> preSelectActInterceptDoList, Map<Long, ActInterceptStatDo> actInterceptStatDoMap, ActInterceptFeatureDo actFeatureDo) throws Exception {
        ActInterceptRcmdDo ret = null;
        if (ActInterceptDQNRcmder.valid(actInterceptDoList, actFeatureDo).booleanValue()) {
            HashMap<Long, Map> featureMap = new HashMap<Long, Map>();
            Map<Long, PreSelectActInterceptDo> actInterceptSelectDoListMap = ActInterceptDQNRcmder.getLastSelect(preSelectActInterceptDoList);
            if (actInterceptStatDoMap == null) {
                actInterceptStatDoMap = new HashMap<Long, ActInterceptStatDo>();
            }
            Map staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic((ActInterceptFeatureDo)actFeatureDo);
            ArrayList<ActInterceptRcmdDo> actRcmdDoList = new ArrayList<ActInterceptRcmdDo>();
            for (Long activityId : actInterceptDoList) {
                ActInterceptFeatureDo dynamicDo = new ActInterceptFeatureDo();
                dynamicDo.setActivityId(activityId);
                ActInterceptStatDo actInterceptStatDo = actInterceptStatDoMap.get(activityId);
                Double rpm = ActInterceptStatModel.getRpm(actInterceptStatDo);
                Map dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamic((ActInterceptFeatureDo)dynamicDo, (ActInterceptFeatureDo)actFeatureDo, (Double)rpm);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(activityId, dynamicFeatureMap);
            }
            Map pRpmMap = new HashMap();
            if (ActInterceptDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            for (Long activityId : actInterceptDoList) {
                ActInterceptRcmdDo actInterceptRcmdDo = new ActInterceptRcmdDo();
                actInterceptRcmdDo.setKey(activityId + "");
                actInterceptRcmdDo.setActivityId(activityId);
                if (actInterceptSelectDoListMap.containsKey(activityId)) {
                    actInterceptRcmdDo.setHasType(true);
                } else {
                    actInterceptRcmdDo.setHasType(false);
                }
                ActInterceptStatDo actInterceptStatDo = actInterceptStatDoMap.get(activityId);
                actInterceptRcmdDo.setsRpm(ActInterceptStatModel.getRpm(actInterceptStatDo));
                actInterceptRcmdDo.setJpv(ActInterceptStatModel.getJpv(actInterceptStatDo));
                actInterceptRcmdDo.setCpv(ActInterceptStatModel.getCpv(actInterceptStatDo));
                actInterceptRcmdDo.setApv(ActInterceptStatModel.getApv(actInterceptStatDo));
                Double pRpm = (Double)pRpmMap.get(activityId);
                actInterceptRcmdDo.setpRpm(pRpm);
                Double mergeRpm = ActInterceptDQNRcmder.getMergeRpm(actInterceptRcmdDo);
                actInterceptRcmdDo.setMergeRpm(mergeRpm);
                actRcmdDoList.add(actInterceptRcmdDo);
            }
            ret = ActInterceptDQNRcmder.rcmd(actRcmdDoList);
        }
        return ret;
    }

    public static ActInterceptRcmdDo rcmd(List<ActInterceptRcmdDo> rcmdList) {
        Double weight;
        ActInterceptRcmdDo ret = null;
        if (AssertUtil.isEmpty(rcmdList)) {
            return ret;
        }
        long size = rcmdList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        if (size == 1L) {
            return rcmdList.get(0);
        }
        int i = 0;
        while ((long)i < size) {
            ActInterceptRcmdDo plugDo = rcmdList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            ++i;
        }
        HashMap<ActInterceptRcmdDo, Double> weightMap = new HashMap<ActInterceptRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ActInterceptRcmdDo rcmdDo = rcmdList.get(i2);
            Double rpm = rcmdDo.getMergeRpm();
            weight = ActInterceptDQNRcmder.getRpmWeight(rpm, bestRpm);
            weight = 1.0;
            weightSum = weightSum + weight;
            weightMap.put(rcmdDo, weight);
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ActInterceptRcmdDo rcmdDo = (ActInterceptRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestRpmKey == null || !bestRpmKey.equals(rcmdDo.getKey()) || !(weight < weightSum * 0.8)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * 0.8 / 0.19999999999999996;
            weightSum = weightOther + weight;
            weightMap.put(rcmdDo, weight);
        }
        ret = (ActInterceptRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getMergeRpm(ActInterceptRcmdDo actRcmdDo) {
        Double ret = null;
        if (actRcmdDo != null) {
            Double actSRpm = actRcmdDo.getsRpm();
            Double pRpm = actRcmdDo.getpRpm();
            if (pRpm == null) {
                return ret;
            }
            ret = pRpm;
            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            ret = 0.5 * pRpm + 0.5 * actSRpm;
        }
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    public static Map<Long, PreSelectActInterceptDo> getLastSelect(List<PreSelectActInterceptDo> preSelectDoList) {
        Map<Long, PreSelectActInterceptDo> ret = new HashMap<Long, PreSelectActInterceptDo>();
        HashMap groupMap = new HashMap();
        String lastDateTime = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{preSelectDoList})) {
            for (int i = 0; i < preSelectDoList.size(); ++i) {
                PreSelectActInterceptDo preSelectDo = preSelectDoList.get(i);
                if (preSelectDo == null) continue;
                String cDateTime = preSelectDo.getDt();
                Long activityId = preSelectDo.getActivityId();
                if (!groupMap.containsKey(cDateTime)) {
                    groupMap.put(cDateTime, new HashMap());
                }
                if (activityId != null) {
                    ((Map)groupMap.get(cDateTime)).put(activityId, preSelectDo);
                }
                if (lastDateTime == null) {
                    lastDateTime = cDateTime;
                    continue;
                }
                if (lastDateTime.compareTo(cDateTime) >= 0) continue;
                lastDateTime = cDateTime;
            }
            ret = (Map)groupMap.get(lastDateTime);
        }
        return ret;
    }

    private static Boolean valid(List<Long> actInterceptDoList, ActInterceptFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actInterceptDoList, actFeatureDo})) {
            logger.error("ActInterceptDQNRcmder.rcmd() input valid ,params plugList or actFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }
}

