/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.sdk;

import cn.com.duiba.nezha.alg.alg.sdk.SdkStatData;
import cn.com.duiba.nezha.alg.alg.vo.sdk.PkInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkDirectlyPk {
    private static final Logger logger = LoggerFactory.getLogger(SdkDirectlyPk.class);

    public static SdkDirectlyPkDo getPk(PkInfoDo pkList, Map<Integer, SdkStatDo> ideaStatDoMap) {
        SdkDirectlyPkDo ret = new SdkDirectlyPkDo();
        try {
            Long adMaterId;
            Long actMaterId;
            Long winId = null;
            Integer winType = 0;
            Double actEcpm = null;
            Double adEcpm = null;
            if (AssertUtil.isNotEmpty((Object)pkList) && AssertUtil.isAllNotEmpty((Object[])new Object[]{actMaterId = pkList.getActivityMaterialId(), adMaterId = pkList.getAdvertMaterialId()})) {
                winId = actMaterId;
                double random1 = Math.random();
                if (random1 <= 0.5) {
                    winId = adMaterId;
                    winType = 3;
                }
                if (AssertUtil.isNotEmpty(ideaStatDoMap)) {
                    double random2;
                    SdkStatDo adMaterInfo;
                    SdkStatDo actMaterInfo = ideaStatDoMap.get(0);
                    if (AssertUtil.isAllNotEmpty((Object[])new Object[]{actMaterInfo, adMaterInfo = ideaStatDoMap.get(3)})) {
                        SdkIndexStatsDo actStats = actMaterInfo.getSlotHourStats();
                        SdkIndexStatsDo adStats = adMaterInfo.getSlotHourStats();
                        actEcpm = SdkStatData.sdkIndexCompute(actStats).getEcpm();
                        adEcpm = SdkStatData.sdkIndexCompute(adStats).getEcpm();
                    }
                    if (AssertUtil.isAllNotEmpty((Object[])new Object[]{actEcpm, adEcpm}) && SdkStatData.isLarger(adEcpm, actEcpm) && (random2 = Math.random()) <= 0.9) {
                        winId = adMaterId;
                        winType = 3;
                    }
                }
            }
            ret.setWinId(winId);
            ret.setWinType(winType);
            ret.setActivityEcpm(actEcpm);
            ret.setAdvertEcpm(adEcpm);
        }
        catch (Exception e) {
            logger.error("SdkDirectlyPk.getPk error:" + e);
        }
        return ret;
    }
}

