package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdControlTask {

    private static final Logger logger = LoggerFactory.getLogger(PdControlTask.class);


    /**
     * 定时任务–PD决策维稳(20min执行1次)
     *
     * @param pdControlRequestDo
     * @return
     */

    public static AdxPdControlDo getPdControl(AdxPdControlRequestDo pdControlRequestDo) {

        AdxPdControlDo ret = new AdxPdControlDo();

        try {

            Double controlFactor = 1.0;                 // 决策控制因子
            Double giveUpRate = 0.9;                    // 低质流量放弃比例
            Double targetRoi = 1.1501;                  // 目标ROI默认值
            boolean isConfident = false;                // 数据指标是否置信
            Double lowerLimit = 0.8;                    // 决策控制因子下限
            Double upperLimit = 1.5;                    // 决策控制因子上限


            if (AssertUtil.isNotEmpty(pdControlRequestDo)) {

                //1.统计指标计算
                AdxStatsDo ideaStats = pdControlRequestDo.getIdeaStats();
                AdxIndexStatDo last1DayStat = null, last20MinStat = null;
                if (AssertUtil.isNotEmpty(ideaStats)) {
                    last1DayStat = ideaStats.getLast1DayStat();
                    last20MinStat = ideaStats.getLast20MinStat();
                }
                AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);

                //2.获取上一次决策控制信息
                Double lastFactor = 1.0;
                Double lastGiveUpRate = 0.9;
                Double lastTargetRoi = 1.1501;
                AdxPdControlDo lastControlDo = pdControlRequestDo.getLastAdxPdControlInfo();
                if (AssertUtil.isNotEmpty(lastControlDo)) {
                    lastFactor = AdxStatData.nullToDefault(lastControlDo.getControlFactor(), 1.0);
                    lastGiveUpRate = AdxStatData.nullToDefault(lastControlDo.getGiveUpRate(), 0.9);
                    lastTargetRoi = AdxStatData.nullToDefault(lastControlDo.getTargetRoi(), 1.1501);

                }


                //3.计算决策维稳信息
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));
                targetRoi = AdxStatData.nullToMinDefault(pdControlRequestDo.getTargetRoi(),1.1501);

                //3.1 置信判断：创意整体当天/实时维度数据置信
                if (ideaStatsDay.getConfident()
                        && AdxStatData.isLarger(ideaStatsMin.getBidCnt(), 50L)
                        && AdxStatData.isLarger(ideaStatsMin.getAdxConsume(), 10L)) {
                    isConfident = true;
                }

                //3.2 更新调节
                if (targetRoi.compareTo(lastTargetRoi) != 0
                        || currentTime == null
                        || (currentTime >= 0L && currentTime < 20L)
                        || isConfident == false) {

                    // 重置：目标ROI与上一次ROI不相同; 更新时间为00:00:00-00:20:00;统计指标不置信;
                    controlFactor = 1.0;
                    giveUpRate = 0.9;

                } else {

                    Double conRoi = AdxStatData.getConRoi(ideaStatsMin, ideaStatsDay);
                    Double actualRoi = ideaStatsMin.getRoi();
                    if (AssertUtil.isEmpty(actualRoi)) {
                        actualRoi = conRoi;
                        if (AssertUtil.isEmpty(actualRoi)) {
                            actualRoi = ideaStatsDay.getRoi();
                        }
                    }

                    //更新控制因子
                    controlFactor = getFactorUpdate(lastFactor, actualRoi, targetRoi, lowerLimit, upperLimit);

                    //更新低质流量放弃比例
                    giveUpRate = lastGiveUpRate;
                    if (AssertUtil.isNotEmpty(actualRoi)) {
                        giveUpRate = actualRoi < 1.15 ? 0.95 : 0.90;
                    }
                }


                ret.setBidCntDay(ideaStatsDay.getBidCnt());
                ret.setBidCntMs(ideaStatsMin.getBidCnt());
                ret.setSucCntDay(ideaStatsDay.getSucCnt());
                ret.setSucCntMs(ideaStatsMin.getSucCnt());
                ret.setAdxCostDay(ideaStatsDay.getAdxConsume());
                ret.setAdxCostMs(ideaStatsMin.getAdxConsume());
                ret.setAdConsumeDay(ideaStatsDay.getAdvertConsume());
                ret.setAdConsumeMs(ideaStatsMin.getAdvertConsume());
                ret.setRoiDay(ideaStatsDay.getRoi());
                ret.setRoiMs(ideaStatsMin.getRoi());
                ret.setRpmDay(ideaStatsDay.getRpm());
                ret.setRpmMs(ideaStatsMin.getRpm());

            }

            ret.setControlFactor(controlFactor);
            ret.setGiveUpRate(giveUpRate);
            ret.setTargetRoi(targetRoi);
            ret.setConfidence(isConfident);


        } catch (Exception e) {

            logger.error("PdControlTask.getPdControl error", e);
        }
        return ret;
    }




    /**
     * 调节因子更新
     *
     * @param lastValue     上一次调节因子
     * @param realRoi       实际roi
     * @param targetRoi     目标roi
     * @return 更新后的调节因子
     */
    public static Double getFactorUpdate(Double lastValue,
                                         Double realRoi, Double targetRoi,
                                         Double lower, Double upper) {

        Double ret = AdxStatData.getNormalValue(lastValue,1.0, lower, upper);

        if (AssertUtil.isAllNotEmpty(realRoi, targetRoi)) {

            Double diff = Math.abs(DataUtil.division(realRoi, targetRoi,3));

            if (diff < 0.85) {
                ret += 0.04 + Math.min((1 - diff/0.85), 1) * 0.03;

            } else if (diff < 0.95) {
                ret += 0.02 + Math.min((1 - (diff-0.85)/(0.95-0.85)), 1) * 0.02;

            } else if (diff < 1.00) {
                ret += 0.01 + Math.min((1 - (diff-0.95)/(1.00-0.95)), 1) * 0.01;

            } else if (diff < 1.05) {
                ret -= 0.01 + Math.min((diff-1.00)/(1.05-1.00), 1) * 0.01;

            } else if (diff < 1.15) {
                ret -= 0.02 + Math.min((diff-1.05)/(1.15-1.05), 1) * 0.02;

            } else {
                ret -= 0.04 + Math.min((diff/1.15-1.00), 1) * 0.03;

            }

            ret = AdxStatData.getNormalValue(ret,1.0, lower, upper);
        }

        return DataUtil.formatDouble(ret,6);
    }
}
