package cn.com.duiba.nezha.alg.alg.vo;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;

import java.io.Serializable;
import java.util.Map;

public class AdxDo implements Serializable{


    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resourceId;

    /**
     * 创意ID
     */
    private Long ideaId;

    /**
     * 最低ROI(小数，如1.50)
     */
    private Double minRoi;

    /**
     * 模型CTR预估值
     */
    private Double currentPreValue ;

    /**
     * 统计CTR
     */
    private Double statCtr;

    /**
     * 统计点击价值(分/单次点击)
     */
    private Double statClickValue;

    /**
     * 预估点击价值(分/单次点击)
     */
    private Double predClickValue;

    /**
     * 统计CTR-资源维度
     */
    private Double statCtrResource;

    /**
     * 统计点击价值-资源维度(分/单次点击)
     */
    private Double statClickValueResource;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    Integer filterIndex;

    /**
     * 创意分filterIndex维度 统计数据--近1h（key：1对比组，2测试组）
     */
    private Map<Integer, AdxIndexStatDo> filterIndexHourStats;

    /**
     * 创意分filterIndex维度 统计数据--当天（key：1对比组，2测试组）
     */
    private Map<Integer, AdxIndexStatDo> filterIndexDayStats;





    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public Double getMinRoi() {
        return minRoi;
    }

    public void setMinRoi(Double minRoi) {
        this.minRoi = minRoi;
    }

    public Double getCurrentPreValue() {
        return currentPreValue;
    }

    public void setCurrentPreValue(Double currentPreValue) {
        this.currentPreValue = currentPreValue;
    }

    public Double getStatCtr() {
        return statCtr;
    }

    public void setStatCtr(Double statCtr) {
        this.statCtr = statCtr;
    }

    public Double getStatClickValue() {
        return statClickValue;
    }

    public void setStatClickValue(Double statClickValue) {
        this.statClickValue = statClickValue;
    }

    public Double getStatCtrResource() {
        return statCtrResource;
    }

    public void setStatCtrResource(Double statCtrResource) {
        this.statCtrResource = statCtrResource;
    }

    public Double getStatClickValueResource() {
        return statClickValueResource;
    }

    public void setStatClickValueResource(Double statClickValueResource) {
        this.statClickValueResource = statClickValueResource;
    }

    public Double getPredClickValue() {
        return predClickValue;
    }

    public void setPredClickValue(Double predClickValue) {
        this.predClickValue = predClickValue;
    }

    public Integer getFilterIndex() { return filterIndex; }

    public void setFilterIndex(Integer filterIndex) { this.filterIndex = filterIndex; }

    public Map<Integer, AdxIndexStatDo> getFilterIndexHourStats() { return filterIndexHourStats; }

    public void setFilterIndexHourStats(Map<Integer, AdxIndexStatDo> filterIndexHourStats) { this.filterIndexHourStats = filterIndexHourStats; }

    public Map<Integer, AdxIndexStatDo> getFilterIndexDayStats() { return filterIndexDayStats; }

    public void setFilterIndexDayStats(Map<Integer, AdxIndexStatDo> filterIndexDayStats) { this.filterIndexDayStats = filterIndexDayStats; }
}
