/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.dpa.PackageRecall;
import cn.com.duiba.nezha.alg.alg.dpa.PrizeRecall;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageRecallDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.CandidateActivityDo;
import cn.com.duiba.nezha.alg.feature.vo.PrizeDo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdReplacement {
    private static final Logger logger = LoggerFactory.getLogger(AdReplacement.class);
    private static final int AD_RANDOM_RANGE = 10;

    public static List<CandidateActivityDo> recallAdAndReplacePrize(List<CandidateActivityDo> activities, List<PackageInfoDo> adPks) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{activities})) {
            logger.error("AdReplacement recallAdAndReplacePrize input params activities is null");
            return activities;
        }
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adPks})) {
            logger.warn("AdReplacement recallAdAndReplacePrize input params adPks is null");
            return activities;
        }
        Map<Long, String> adIdx2Tag = PrizeRecall.preprocessAdList(adPks, null);
        List<PackageRecallDo> recallAdList = AdReplacement.recallAdPrize(adPks);
        List<PackageRecallDo> sortedAdPks = recallAdList.stream().sorted(Comparator.comparing(PackageRecallDo::getMatchScore).reversed()).collect(Collectors.toList());
        List<CandidateActivityDo> result = AdReplacement.replaceOverAll(activities, sortedAdPks);
        return result;
    }

    protected static List<PackageRecallDo> recallAdPrize(List<PackageInfoDo> pks) {
        int topN = Math.min(20, pks.size());
        return PackageRecall.ucbPackage(pks, topN, 2, 2);
    }

    private static List<CandidateActivityDo> replaceOverAll(List<CandidateActivityDo> activities, List<PackageRecallDo> adPks) {
        ArrayList<CandidateActivityDo> result = new ArrayList<CandidateActivityDo>(activities.size());
        AdTagInfo tagInfo = AdReplacement.getAdTagInfo(adPks);
        int idx = 0;
        for (CandidateActivityDo act : activities) {
            AdReplacement.doReplacement(adPks, act.getPrizeGroup(), tagInfo, idx++ % 2 + 1);
            result.add(act);
        }
        return result;
    }

    private static List<CandidateActivityDo> replaceOverSign(List<CandidateActivityDo> activities, List<PackageRecallDo> adPks) {
        ArrayList<CandidateActivityDo> result = new ArrayList<CandidateActivityDo>(activities.size());
        AdTagInfo tagInfo = AdReplacement.getAdTagInfo(adPks);
        GroupInfo groupInfo = AdReplacement.extractPrizeGroupInfo(activities);
        int idx = 0;
        for (List<PrizeDo> group : groupInfo.groups.values()) {
            AdReplacement.doReplacement(adPks, group, tagInfo, idx++ % 2 + 1);
        }
        for (String sign : groupInfo.groups.keySet()) {
            List<CandidateActivityDo> acts = groupInfo.groupBuckets.get(sign);
            List<PrizeDo> group = groupInfo.groups.get(sign);
            for (CandidateActivityDo act : acts) {
                act.setPrizeGroup(group);
                result.add(act);
            }
        }
        return result;
    }

    private static void doReplacement(List<PackageRecallDo> adPks, List<PrizeDo> group, AdTagInfo tagInfo, int k) {
        k = Math.min(k, tagInfo.tagBucket.size());
        List<Object> ads = new ArrayList<PackageRecallDo>(k);
        int range = Math.min(adPks.size(), 20);
        if (k == 1) {
            range = Math.min(adPks.size(), 4);
            PackageRecallDo ad = PrizeRecall.weightedRandomPickByMatchscore(adPks.subList(0, range));
            ads.add(ad);
        } else if (k == 2 && tagInfo.tagBucket.size() == 1) {
            PackageRecallDo top1 = adPks.get(0);
            PackageRecallDo top2Random = PrizeRecall.weightedRandomPickByMatchscore(adPks.subList(1, range));
            ads.add(top1);
            ads.add(top2Random);
        } else if (k > tagInfo.tagBucket.size()) {
            logger.warn("\u53ec\u56de\u7684tag\u57fa\u6570\u5c0f\u4e8e\u76ee\u6807\u66ff\u6362\u6570\uff0c\u6bcf\u4e2atag\u4e0b\u53ec\u56de\u4e00\u4e2a\u6539\u4e3a\u5168\u5c40\u968f\u673a\u53ec\u56de");
            ads = AdReplacement.fetchAdFromWeightedList(adPks, k);
        } else {
            ads = AdReplacement.fetchAdFromWeightedPickedTag(tagInfo, k);
        }
        for (int i = 0; i < ads.size(); ++i) {
            PrizeDo pd = AdReplacement.prizeDoFromAd((PackageRecallDo)ads.get(i));
            group.add(i, pd);
        }
    }

    private static PrizeDo prizeDoFromAd(PackageRecallDo ad) {
        PrizeDo pd = new PrizeDo(true, ad.getPackageInfoDo().getPackageIdDo().getAdPrizeId(), ad.getPackageInfoDo().getPackageIdDo().getPrizeTagId(), ad.getMatchScore());
        pd.setAdTagId(ad.getPackageInfoDo().getPackageIdDo().getAdPrizeType());
        return pd;
    }

    private static List<PackageRecallDo> fetchAdFromWeightedList(List<PackageRecallDo> adPks, int k) {
        return PrizeRecall.fetchPkrdFromWeightedList(adPks, k);
    }

    private static List<PackageRecallDo> fetchAdFromWeightedPickedTag(AdTagInfo adTagInfo, int k) {
        ArrayList<PackageRecallDo> result = new ArrayList<PackageRecallDo>();
        List<Long> choosenAdTags = PrizeRecall.weightedPickTags(adTagInfo.tagWeight, k);
        for (Long tagId : choosenAdTags) {
            PackageRecallDo pkrd = adTagInfo.tagBucket.get(tagId).get(0);
            result.add(pkrd);
        }
        return result;
    }

    public static GroupInfo extractPrizeGroupInfo(List<CandidateActivityDo> activities) {
        HashMap<String, List<CandidateActivityDo>> groupBuckets = new HashMap<String, List<CandidateActivityDo>>();
        HashMap<String, List<PrizeDo>> groups = new HashMap<String, List<PrizeDo>>();
        for (CandidateActivityDo act : activities) {
            List group = act.getPrizeGroup();
            String signature = PrizeRecall.groupSignature(group);
            if (groups.containsKey(signature)) {
                ((List)groupBuckets.get(signature)).add(act);
                continue;
            }
            ArrayList<CandidateActivityDo> bucket = new ArrayList<CandidateActivityDo>();
            bucket.add(act);
            groupBuckets.put(signature, bucket);
            groups.put(signature, group);
        }
        return new GroupInfo(groups, groupBuckets);
    }

    private static AdTagInfo getAdTagInfo(List<PackageRecallDo> prds) {
        HashMap<Long, List<PackageRecallDo>> tagBuckets = new HashMap<Long, List<PackageRecallDo>>();
        HashMap<Long, Double> tagWeight = new HashMap<Long, Double>();
        for (PackageRecallDo pkrd : prds) {
            Long prizeTagId = pkrd.getPackageInfoDo().getPackageIdDo().getPrizeTagId();
            if (tagBuckets.containsKey(prizeTagId)) {
                ((List)tagBuckets.get(prizeTagId)).add(pkrd);
            } else {
                ArrayList<PackageRecallDo> bucket = new ArrayList<PackageRecallDo>();
                bucket.add(pkrd);
                tagBuckets.put(prizeTagId, bucket);
            }
            tagWeight.put(prizeTagId, tagWeight.getOrDefault(prizeTagId, 0.0) + pkrd.getMatchScore());
        }
        return new AdTagInfo(tagBuckets, tagWeight);
    }

    private static class AdTagInfo {
        public Map<Long, List<PackageRecallDo>> tagBucket;
        public Map<Long, Double> tagWeight;

        public AdTagInfo(Map<Long, List<PackageRecallDo>> tagBucket, Map<Long, Double> tagWeight) {
            this.tagBucket = tagBucket;
            this.tagWeight = tagWeight;
        }
    }

    private static class GroupInfo {
        public Map<String, List<PrizeDo>> groups;
        public Map<String, List<CandidateActivityDo>> groupBuckets;

        public GroupInfo(Map<String, List<PrizeDo>> groups, Map<String, List<CandidateActivityDo>> groupBuckets) {
            this.groups = groups;
            this.groupBuckets = groupBuckets;
        }
    }
}

