package cn.com.duiba.nezha.alg.alg.vo.dpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author lijingzhe
 * @description 组件ID包
 * @date 2020/6/17
 */
public class PackageIdDo {
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动皮肤ID
     */
    private Long skinId;
    /**
     * 活动皮肤标签ID
     */
    private Long skinTagId;
    /**
     * 标题ID
     */
    private Long titleId;
    /**
     *标题标签ID，一对多，逗号分隔
     */
    private String titleTagId;
    /**
     * 副标题ID
     */
    private Long subTitleId;
    /**
     * 副标题标签ID，一对多，逗号分隔
     */
    private String subTitleTagId;
    /**
     * 奖品ID
     */
    private Long prizeId;
    /**
     * 奖品标签ID
     */
    private Long prizeTagId;
    /**
     * 奖品类型
     */
    private String prizeType;
    /**
     * 券奖品ID
     */
    private Long adPrizeId;
    /**
     * 券奖品类型
     */
    private String adPrizeType;
    /**
     * 奖品组合
     */
    private List<PrizeDo> prizeGroup = new ArrayList<>();

    /**
     * 创建时间
     */
    private Long createTime = 0l;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public Long getSkinTagId() {
        return skinTagId;
    }

    public void setSkinTagId(Long skinTagId) {
        this.skinTagId = skinTagId;
    }

    public Long getTitleId() {
        return titleId;
    }

    public void setTitleId(Long titleId) {
        this.titleId = titleId;
    }

    public String getTitleTagId() {
        return titleTagId;
    }

    public void setTitleTagId(String titleTagId) {
        this.titleTagId = titleTagId;
    }

    public Long getSubTitleId() {
        return subTitleId;
    }

    public void setSubTitleId(Long subTitleId) {
        this.subTitleId = subTitleId;
    }

    public String getSubTitleTagId() {
        return subTitleTagId;
    }

    public void setSubTitleTagId(String subTitleTagId) {
        this.subTitleTagId = subTitleTagId;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public Long getPrizeTagId() {
        return prizeTagId;
    }

    public void setPrizeTagId(Long prizeTagId) {
        this.prizeTagId = prizeTagId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public Long getAdPrizeId() {
        return adPrizeId;
    }

    public void setAdPrizeId(Long adPrizeId) {
        this.adPrizeId = adPrizeId;
    }

    public String getAdPrizeType() {
        return adPrizeType;
    }

    public void setAdPrizeType(String adPrizeType) {
        this.adPrizeType = adPrizeType;
    }

    public List<PrizeDo> getPrizeGroup() {
        return prizeGroup;
    }

    public void setPrizeGroup(List<PrizeDo> prizeGroup) {
        this.prizeGroup = prizeGroup;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PackageIdDo)) return false;
        PackageIdDo that = (PackageIdDo) o;
        return Objects.equals(getActivityId(), that.getActivityId()) &&
                Objects.equals(getSkinId(), that.getSkinId()) &&
                Objects.equals(getSkinTagId(), that.getSkinTagId()) &&
                Objects.equals(getTitleId(), that.getTitleId()) &&
                Objects.equals(getTitleTagId(), that.getTitleTagId()) &&
                Objects.equals(getSubTitleId(), that.getSubTitleId()) &&
                Objects.equals(getSubTitleTagId(), that.getSubTitleTagId()) &&
                Objects.equals(getPrizeId(), that.getPrizeId()) &&
                Objects.equals(getPrizeTagId(), that.getPrizeTagId()) &&
                Objects.equals(getPrizeType(), that.getPrizeType()) &&
                Objects.equals(getAdPrizeId(), that.getAdPrizeId()) &&
                Objects.equals(getAdPrizeType(), that.getAdPrizeType()) &&
                Objects.equals(getPrizeGroup(), that.getPrizeGroup()) &&
                Objects.equals(getCreateTime(), that.getCreateTime());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getActivityId(), getSkinId(), getSkinTagId(), getTitleId(), getTitleTagId(), getSubTitleId(), getSubTitleTagId(), getPrizeId(), getPrizeTagId(), getPrizeType(), getAdPrizeId(), getAdPrizeType(), getPrizeGroup(), getCreateTime());
    }
}