package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.HashMap;
import java.util.Map;

public class BidControl {


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     *
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象

     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     */

    /**
     * 批量接口
     *
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        Map<String, AdBidResultDo> ret = new HashMap<>();

        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {

            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();

            AdBidResultDo adBidResultDo = bidControl(adBidInputDo, paramsModel);

            ret.put(key, adBidResultDo);
        }

        return ret;
    }

    /**
     * 单广告接口
     *
     * @param adBidInputDo 竞价广告
     * @param paramsModel  控制参数对象
     */
    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();


        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        /**
         * cpc 广告
         */
        if (adBidInputDo.getChargeType() == 1) {

            adBidResultDo.setFee(adBidInputDo.getFee());
        }

        /**
         * ocpc广告
         */

        if (adBidInputDo.getChargeType() == 2) {

            long fee = getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());

            if (paramsModel == null) {

                adBidResultDo.setFee(fee);
                adBidResultDo.setFactor(1.0);

            } else {

                AdBidParamsDo adBidParamsDo = getBidParams(adBidInputDo, paramsModel, fee);

                adBidResultDo.setFee(adBidParamsDo.getFee());
                adBidResultDo.setFactor(adBidParamsDo.getFactor());
                adBidResultDo.setAdBidParamsDo(adBidParamsDo);

            }

        }


        return adBidResultDo;
    }


    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel, long fee) {

        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();

        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        long floorFee = adBidInputDo.getReserveFee();

        adBidInputDo.setFee(fee);

        OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);

        /**
         * 参数计算
         */

        if (ocpxControlSubModel != null) {

            OcpxControlParams pkParams = ocpxControlSubModel.getOcpxControlParams();

            OcpxControlParams slotParams = ocpxControlSubModel.getOcpxControlParams(slotId);

            /**
             * 成本维稳
             */
            costControl(adBidParamsDo, pkParams, slotParams);

            /**
             * 出价保护-过度出价
             *
             */
            protectControl(adBidParamsDo, pkParams, slotParams);

            /**
             * 出价试探-出价增长
             *
             */
//            exploreControl(adBidParamsDo, pkParams, slotParams);

            /**
             * 底价控制参数
             * todo
             */

//            floorPriceControl(adBidParamsDo, floorFee, pkParams, slotParams);
        }

        /**
         * 参数计算 出价保护-冷启动
         */
        coldControl(adBidParamsDo, paramsModel.getAdAndSlotControlParams(advertId,slotId), paramsModel.getSlotControlParams(slotId));


        /**
         * 返回结果封装
         */

        return adBidParamsDo;
    }


    /**
     * 策略：成本维稳
     *
     * @return
     */
    private static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {

        //维稳参数
        Long factorType = 3L;//维稳类型，1 配置  2 广告位 3 无

        Double factor = 1.0;// 维稳因子


        Long fee = adBidParamsDo.getFee();
        //维稳重置标记
        Integer resetType = null;//1:出价调节  2：管理后台调节

        Double slotFactor = OcpxControlParams.getCostFacor(slotParams);
        if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;

            resetType = OcpxControlParams.getResetType(slotParams);

        } else {

            Double pkFactor = OcpxControlParams.getCostFacor(pkParams);
            if (pkFactor != null) {
                factorType = 1L;
                factor = pkFactor;
                resetType = OcpxControlParams.getResetType(pkParams);
            }
        }

        Long feeNew = Math.round(fee * factor);
        //维稳参数
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor);
        adBidParamsDo.setFee(feeNew);

        //维稳重置标记
        adBidParamsDo.setResetType(resetType);

    }

    /**
     * 策略：冷启动控制
     *
     * @return
     */
    private static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams) {

        //出价保护-冷启动
        Boolean coldProject = null;// 出价保护- 是否冷启动保护

        Long coldProjectFeeDiff = null;// 出价保护-冷启动出价下降

        Long fee = adBidParamsDo.getFee();


        if (adControlParams == null || (adControlParams != null && adControlParams.isColdStart())) {
            coldProject = true;

            if (slotControlParams != null) {
                Long feeNew = SlotControlParams.getFee(fee, slotControlParams);
                coldProjectFeeDiff = fee - feeNew;

                fee = feeNew;

            }
        }

        //出价保护-冷启动
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);

    }

    /**
     * 策略：探索出价控制
     *
     * @return
     */
    private static void exploreControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {


        //出价试探-出价增长
        Boolean explore = null;// 出价试探-是否试探
        Long exploreFeeDiff = null;// 出价试探-出价增长


        //出价试探-出价增长
        adBidParamsDo.setExplore(explore);
        adBidParamsDo.setExploreFeeDiff(exploreFeeDiff);


    }

    /**
     * 策略：出价保护控制
     *
     * @return
     */
    private static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {

        //出价保护-过度出价
        Boolean secondPriceProject = null;// 出价保护，是否二阶保护

        Long secondPriceProjectFeeDiff = null;// 出价保护-二阶出价降价

        Long protectPriceThre = null;// 出价保护，二阶因子

        Long slotProtectPriceThre = OcpxControlParams.getProtectPriceThre(slotParams);
        if (slotProtectPriceThre != null) {
            protectPriceThre = slotProtectPriceThre;

        } else {
            Long pkProtectPriceThre = OcpxControlParams.getProtectPriceThre(pkParams);
            if (pkProtectPriceThre != null) {
                protectPriceThre = slotProtectPriceThre;
            }
        }

        if (protectPriceThre != null) {
            secondPriceProject = true;

            /**
             * 当前出价保护 后置 在最后环节计算
             */
        }


        //出价保护-过度出价
        adBidParamsDo.setSecondPriceProject(secondPriceProject);

        adBidParamsDo.setSecondPriceProjectFeeDiff(secondPriceProjectFeeDiff);

        adBidParamsDo.setProtectPriceThre(protectPriceThre);
    }

    /**
     * 策略：底价控制
     *
     * @return
     */
    private static void floorPriceControl(AdBidParamsDo adBidParamsDo, long floorFee, OcpxControlParams pkParams, OcpxControlParams slotParams) {

        //底价控制参数
        Boolean reserveFee = null;//底价

        Boolean reservePriceWhite = null;//底价生效白名单，白名单内不触发

        Long giveUpFee = null;// 底价放弃阈值-出价

        Double giveUpRatio = null;// 底价放弃阈值-概率


        //底价控制参数
        adBidParamsDo.setReserveFee(reserveFee);

        adBidParamsDo.setReservePriceWhite(reservePriceWhite);

        adBidParamsDo.setGiveUpFee(giveUpFee);

        adBidParamsDo.setGiveUpRatio(giveUpRatio);

    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {

        if (AssertUtil.isAllNotEmpty(advertId, packageId, type, paramsModel)) {

            OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);

            if (ocpxControlSubModel != null) {
                OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();

                if (ocpxControlParams != null) {
                    ocpxControlParams.setResetType(type);
                }
            }
        }


    }


    /**
     * 重新出价（出价保护）
     * 描述
     * 对在白名单，且排序Top的配置，调整价格，保护出价

     * 输入说明：
     * top1：ctr1、fee1
     * top2：ctr2、fee2
     * 维稳出价结果对象

     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     */

    /**
     * @param top1          排序第一的配置
     * @param top2          排序第二的配置
     * @param bidResultTop1 排序第一的出价结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {


        //异常处理
        if (top1 == null || top2 == null) {
            return bidResultTop1;
        }


        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {

            // 判断是否触发二价保护
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Long protectPriceThre = bidResultTop1.getAdBidParamsDo().getProtectPriceThre();
            if (isSecondPriceProject != null && isSecondPriceProject && protectPriceThre != null && protectPriceThre > top1.getFee()) {

                // 计算二价
                long secondFee = getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());

                // 新出价，二阶基、原出价基础上 平滑
                long feeNew = getFeeSmooth(secondFee, top1.getFee(), 0.8);
                bidResultTop1.setFee(feeNew);

                // 二价下调价格差
                long feeDiff = top1.getFee() - feeNew;
                bidResultTop1.getAdBidParamsDo().setSecondPriceProjectFeeDiff(feeDiff);

            }
        }
        return bidResultTop1;
    }


    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * fee2 / ctr1;
        return Math.round(feeNew) + 1;
    }

    private static long getFeeSmooth(long fee1, long fee2, double smoothFactor) {

        double feeNewTmp = fee1 * smoothFactor + fee2 * (1 - smoothFactor);

        long feeNew = Math.min(Math.round(feeNewTmp) + 1, fee2);

        return feeNew;
    }


    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {

        return appFee == null ? getOcpcFee(cvr, afee, specialAccountWeight) : getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * afee * specialAccountWeight);
    }
}
