package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;


public class AdxDirectlyBidding {


    /**
     * 算法接口2-直投算法出价
     *
     * @param directlyIdeaDoInfo 直投创意信息
     * @param directlyFactorInfo 直投ROI维稳因子试探表
     * @return
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo,
                                                  AdxDirectlyFactorDo directlyFactorInfo) {

        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();

        try {

            // 1.设置默认值
            Double roiFactor = 1.0;            // ROI调节因子
            Double lowerLimit = 0.3;           // ROI调节因子下限
            Double upperLimit = 1.7;           // ROI调节因子上限

            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();


            // 2.获取统计信息
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty(directlyIdeaInfo)) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(),0L);
            }


            // 3.获取level和调节因子
            if (AssertUtil.isNotEmpty(directlyFactorInfo) && ideaBidCntMs != 0L) {

                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);

                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double(result.get("factor")), 1.0, lowerLimit, upperLimit);

            }


            // 3.计算出价
            if (AssertUtil.isNotEmpty(directlyIdeaInfo)) {

                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);

                // 出价 = 广告计划CPC出价(分) * 直投CTR预估 * 1000 /（设置ROI * ROI调节因子）
                algoPrice = Math.round(Math.floor(DataUtil.division(cpcPrice * preCtr * 1000L, minRoi * roiFactor)));

            }

            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);


        } catch(Exception e){
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);

        }

        return ret;
    }

}
