package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * adx流量过滤入参对象
 */


@Data
public class FlowFilterRequestDo implements Serializable {

    private static final long serialVersionUID = 8790187003832578709L;

    /**
     * adx流量信息
     */
    private AdxFlowInfoDo flowInfo;

    /**
     * adx流量过滤1.0-定时任务结果
     */
    private AdxFilterInfoDo filterInfo1;

    /**
     * adx流量过滤2.0-定时任务结果
     */
    AdxFilterInfoDo filterInfo2;

    /**
     * 创意点击率-FM模型预估值
     */
    private Double preCtr;

    /**
     * 每pv发券编码器模型
     */
    private CODER launchPvCoderModel;

    /**
     * 每pv发券tf模型
     */
    private LocalTFModel launchPvLtfModel;

    /**
     * 流量特征对象
     */
    private AdxFeatureDo adxFeatureDo;

    /**
     * 算法出价模式(1-按roi出价, 2-按cpc出价)
     */
    private Integer algoBidMode;

    /**
     * 每pv发券阈值(小数)
     */
    private Double launchPvLimit;

    /**
     * 创意+filterType过滤竞价量级(key为filterType)
     */
    private Map<Integer, AdxFilterCntDo> ideafilterCntDo;

    /**
     * 资源位+filterType过滤竞价量级(key为filterType)
     */
    private Map<Integer, AdxFilterCntDo> resofilterCntDo;

    /**
     * 创意点击率-FM模型
     */
    private FM CtrFmModel;

    /**
     * 流量abtest组别
     * 1=adx非测试流量，2=无，3=每pv发券，4=每pv点券
     */
    private Integer flowGroup;

    /**
     * 非测试流量选择的过滤功能
     * 0=无，1=每pv发券，2=每pv点券（暂时不生效）
     */
    private Integer baseFilterFlag;

    /**
     * 每pv点券阈值
     */
    private Double chargePvLimit ;

    /**
     * 每pv点券-编码器模型
     */
    private CODER2 ChargePvCoderModel;

    /**
     * 每pv点券-tf模型
     */
    private LocalTFModel ChargePvLtfModel;

}
