package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class OcpxControlModel {

    /**
     * 广告-配置     维度 参数对象
     * Map<广告ID，Map<配置ID，参数>>
     */
    Map<Long, Map<Long, OcpxControlSubModel>> ocpxControlSubModelMap = new HashMap<>();




    /**
     * 广告,广告位 冷启动 控制参数
     */
    Map<Long, Map<Long, AdControlParams>> adAndSlotControlParamsHashMap = new HashMap<>();

    /**
     * 广告位  冷启动 控制参数
     */

    Map<Long, SlotControlParams> slotControlParamsMap = new HashMap<>();


    String updateTime;

    public OcpxControlSubModel getOcpxControlSubModel(Long adId, Long pkId) {

        if (!ocpxControlSubModelMap.containsKey(adId)) {
            ocpxControlSubModelMap.put(adId, new HashMap<>());
        }

        return ocpxControlSubModelMap.get(adId).get(pkId);
    }

    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public AdControlParams getAdAndSlotControlParams(Long adId, Long slotId) {


        if (!adAndSlotControlParamsHashMap.containsKey(adId)) {
            adAndSlotControlParamsHashMap.put(adId, new HashMap<>());
        }
        return adAndSlotControlParamsHashMap.get(adId).get(slotId);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public SlotControlParams getSlotControlParams(Long slotId) {

        return slotControlParamsMap.get(slotId);
    }

}
