package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

@Data
public class OcpxControlParams {

    // 维稳下限
    private Double mFactor;

    // 维稳重置
    private Integer resetType;


    // pid控制参数
//    private PidParams pidParams;

    private Double cFactor; //维稳因子
    private Boolean cConf; //维稳置信


    // 底价控制参数
//    private FloorPriceParams floorPriceParams;

    private Double fPriceThre;// 底价阈值
    private Double fGiveUpProb;// 放弃概率
    private Boolean fConf;// 底价置信


    // 出价保护控制参数
//    private PriceProtectParams priceProtectParams;

    private Long pPriceThre; //出价保护阈值
    private Boolean pConf; //出价保护置信

    // 探价控制参数
//    private PriceExploreParams priceExploreParams;

    private Double ePriceThre; // 探价阈值

    private Double eRate; //探价概率

    private boolean eConf;// 探价置信

    private String updateTime;// 更新时间


    /**
     * 获取出价保护阈值
     *
     * @param params
     * @return
     */
    public static Long getProtectPriceThre(OcpxControlParams params) {
        Long ret = null;

        if (params != null) {
            if (params.getPConf()) {
                ret = params.getPPriceThre();
            }
        }
        return ret;
    }

    /**
     * 获取维稳因子
     *
     * @param params
     * @return
     */
    public static Double getCostFacor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf()) {
                ret = params.getCFactor();

                if (params.getCFactor() != null && params.getMFactor() != null) {
                    ret = Math.max(params.getCFactor(), params.getMFactor());
                }
            }
        }

        return ret;
    }

    /**
     * 获取重置状态
     *
     * @param ocpxControlParams
     * @return
     */

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {

        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        } else {
            return null;
        }
    }


}

