/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;

public class BidControl {
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        HashMap<String, AdBidResultDo> ret = new HashMap<String, AdBidResultDo>();
        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {
            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();
            AdBidResultDo adBidResultDo = BidControl.bidControl(adBidInputDo, paramsModel);
            ret.put(key, adBidResultDo);
        }
        return ret;
    }

    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();
        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        if (adBidInputDo.getChargeType() == 1) {
            adBidResultDo.setFee(adBidInputDo.getFee());
        }
        if (adBidInputDo.getChargeType() == 2) {
            long fee = BidControl.getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());
            if (paramsModel == null) {
                adBidResultDo.setFee(fee);
                adBidResultDo.setFactor(1.0);
            } else {
                AdBidParamsDo adBidParamsDo = BidControl.getBidParams(adBidInputDo, paramsModel, fee);
                adBidResultDo.setFee(adBidParamsDo.getFee());
                adBidResultDo.setFactor(adBidParamsDo.getFactor());
                adBidResultDo.setAdBidParamsDo(adBidParamsDo);
            }
        }
        return adBidResultDo;
    }

    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel, long fee) {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        long floorFee = adBidInputDo.getReserveFee();
        adBidInputDo.setFee(fee);
        OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);
        if (ocpxControlSubModel != null) {
            OcpxControlParams pkParams = ocpxControlSubModel.getOcpxControlParams();
            OcpxControlParams slotParams = ocpxControlSubModel.getOcpxControlParams(slotId);
            BidControl.costControl(adBidParamsDo, pkParams, slotParams);
            BidControl.protectControl(adBidParamsDo, pkParams, slotParams);
        }
        BidControl.coldControl(adBidParamsDo, paramsModel.getAdAndSlotControlParams(advertId, slotId), paramsModel.getSlotControlParams(slotId));
        return adBidParamsDo;
    }

    private static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Long factorType = 3L;
        Double factor = 1.0;
        Long fee = adBidParamsDo.getFee();
        Integer resetType = null;
        Double slotFactor = OcpxControlParams.getCostFacor(slotParams);
        if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
            resetType = OcpxControlParams.getResetType(slotParams);
        } else {
            Double pkFactor = OcpxControlParams.getCostFacor(pkParams);
            if (pkFactor != null) {
                factorType = 1L;
                factor = pkFactor;
                resetType = OcpxControlParams.getResetType(pkParams);
            }
        }
        Long feeNew = Math.round((double)fee.longValue() * factor);
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor);
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setResetType(resetType);
    }

    private static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams) {
        Boolean coldProject = null;
        Long coldProjectFeeDiff = null;
        Long fee = adBidParamsDo.getFee();
        if (adControlParams == null || adControlParams != null && adControlParams.isColdStart()) {
            coldProject = true;
            if (slotControlParams != null) {
                Long feeNew = SlotControlParams.getFee(fee, slotControlParams);
                coldProjectFeeDiff = fee - feeNew;
                fee = feeNew;
            }
        }
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);
    }

    private static void exploreControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean explore = null;
        Long exploreFeeDiff = null;
        adBidParamsDo.setExplore(explore);
        adBidParamsDo.setExploreFeeDiff(exploreFeeDiff);
    }

    private static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean secondPriceProject = null;
        Long secondPriceProjectFeeDiff = null;
        Long protectPriceThre = null;
        Long slotProtectPriceThre = OcpxControlParams.getProtectPriceThre(slotParams);
        if (slotProtectPriceThre != null) {
            protectPriceThre = slotProtectPriceThre;
        } else {
            Long pkProtectPriceThre = OcpxControlParams.getProtectPriceThre(pkParams);
            if (pkProtectPriceThre != null) {
                protectPriceThre = slotProtectPriceThre;
            }
        }
        if (protectPriceThre != null) {
            secondPriceProject = true;
        }
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setSecondPriceProjectFeeDiff(secondPriceProjectFeeDiff);
        adBidParamsDo.setProtectPriceThre(protectPriceThre);
    }

    private static void floorPriceControl(AdBidParamsDo adBidParamsDo, long floorFee, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean reserveFee = null;
        Boolean reservePriceWhite = null;
        Long giveUpFee = null;
        Double giveUpRatio = null;
        adBidParamsDo.setReserveFee(reserveFee);
        adBidParamsDo.setReservePriceWhite(reservePriceWhite);
        adBidParamsDo.setGiveUpFee(giveUpFee);
        adBidParamsDo.setGiveUpRatio(giveUpRatio);
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {
        OcpxControlParams ocpxControlParams;
        OcpxControlSubModel ocpxControlSubModel;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, paramsModel}) && (ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId)) != null && (ocpxControlParams = ocpxControlSubModel.getOcpxControlParams()) != null) {
            ocpxControlParams.setResetType(type);
        }
    }

    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {
        if (top1 == null || top2 == null) {
            return bidResultTop1;
        }
        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Long protectPriceThre = bidResultTop1.getAdBidParamsDo().getProtectPriceThre();
            if (isSecondPriceProject != null && isSecondPriceProject.booleanValue() && protectPriceThre != null && protectPriceThre > top1.getFee()) {
                long secondFee = BidControl.getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                long feeNew = BidControl.getFeeSmooth(secondFee, top1.getFee(), 0.8);
                bidResultTop1.setFee(feeNew);
                long feeDiff = top1.getFee() - feeNew;
                bidResultTop1.getAdBidParamsDo().setSecondPriceProjectFeeDiff(feeDiff);
            }
        }
        return bidResultTop1;
    }

    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * (double)fee2 / ctr1;
        return Math.round(feeNew) + 1L;
    }

    private static long getFeeSmooth(long fee1, long fee2, double smoothFactor) {
        double feeNewTmp = (double)fee1 * smoothFactor + (double)fee2 * (1.0 - smoothFactor);
        long feeNew = Math.min(Math.round(feeNewTmp) + 1L, fee2);
        return feeNew;
    }

    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {
        return appFee == null ? BidControl.getOcpcFee(cvr, afee, specialAccountWeight) : BidControl.getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * (double)afee * specialAccountWeight);
    }
}

