/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.common.vo.GenericPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecallUtil {
    private static final Logger logger = LoggerFactory.getLogger(RecallUtil.class);

    protected static List<int[]> combination(int m, int n, int cNum) {
        ArrayList<int[]> result = new ArrayList<int[]>(cNum);
        int[] value = new int[n];
        for (int i = 0; i < n; ++i) {
            value[i] = i;
        }
        int count = 0;
        do {
            result.add((int[])value.clone());
        } while (++count < cNum && RecallUtil.move(value, m));
        return result;
    }

    private static boolean move(int[] value, int max) {
        int currentIndex = value.length - 1;
        while (currentIndex > -1) {
            int current = value[currentIndex];
            if (++current == max) {
                --currentIndex;
                continue;
            }
            value[currentIndex] = current;
            for (int i = currentIndex + 1; i < value.length; ++i) {
                value[i] = value[i - 1] + 1;
            }
            if (!Arrays.stream(value).noneMatch(x -> x >= max)) continue;
            return true;
        }
        return false;
    }

    protected static List<Integer> randKWithoutReplacement(List<Double> rates, int k) {
        if (null == rates || rates.isEmpty()) {
            logger.error("the rates list is null or empty");
            throw new RuntimeException("the rates list is null or empty");
        }
        if (k >= rates.size()) {
            logger.error("k is bigger than rates' size");
            throw new RuntimeException("k is bigger than rates' size");
        }
        ArrayList<HeapNode> nodes = new ArrayList<HeapNode>(rates.size());
        for (int index = 0; index < rates.size(); ++index) {
            nodes.add(new HeapNode(rates.get(index), index));
        }
        ArrayList<Integer> result = new ArrayList<Integer>(k);
        List<HeapNode> heap = RecallUtil.buildHeap(nodes);
        for (int index = 0; index < k; ++index) {
            result.add(RecallUtil.heapPop(heap));
        }
        return result;
    }

    private static List<HeapNode> buildHeap(List<HeapNode> nodes) {
        ArrayList<HeapNode> heap = new ArrayList<HeapNode>(nodes.size() + 1);
        heap.add(null);
        heap.addAll(nodes);
        for (int index = heap.size() - 1; index > 1; --index) {
            double curTW = ((HeapNode)heap.get((int)(index >> 1))).totalWeight;
            ((HeapNode)heap.get((int)(index >> 1))).totalWeight = curTW + ((HeapNode)heap.get((int)index)).totalWeight;
        }
        return heap;
    }

    private static int heapPop(List<HeapNode> heap) {
        double gas = heap.get((int)1).totalWeight * Math.random();
        int i = 1;
        while (gas > heap.get((int)i).weight) {
            gas -= heap.get((int)i).weight;
            i <<= 1;
            if (!(gas > heap.get((int)i).totalWeight)) continue;
            gas -= heap.get((int)i).totalWeight;
            ++i;
        }
        double weight = heap.get((int)i).weight;
        int value = heap.get((int)i).value;
        heap.get((int)i).weight = 0.0;
        while (i > 0) {
            heap.get((int)i).totalWeight -= weight;
            i >>= 1;
        }
        return value;
    }

    protected static List<Integer> argSort(List<Double> rates) {
        List<Object> idxWithRates = new ArrayList<GenericPair>(rates.size());
        for (int i = 0; i < rates.size(); ++i) {
            idxWithRates.add(new GenericPair((Comparable)Integer.valueOf(i), (Comparable)rates.get(i)));
        }
        idxWithRates = idxWithRates.stream().sorted().collect(Collectors.toList());
        return idxWithRates.stream().mapToInt(item -> (Integer)item.first).boxed().collect(Collectors.toList());
    }

    protected static List<Integer> randKWithReplacement(List<Double> rates, int k) {
        if (null == rates || rates.isEmpty()) {
            logger.error("the rates list is null or empty");
            throw new RuntimeException("the rates list is null or empty");
        }
        ArrayList<Integer> result = new ArrayList<Integer>(k);
        double sum = rates.stream().mapToDouble(v -> v).sum();
        for (int i = 0; i < k; ++i) {
            result.add(RecallUtil.weightedRandPick(rates, sum));
        }
        return result;
    }

    protected static int weightedRandPick(List<Double> rates, double sum) {
        double randomNum = Math.random() * sum;
        int findIdx = 0;
        for (int j = 0; j < rates.size(); ++j) {
            findIdx = j;
            if ((randomNum -= rates.get(j).doubleValue()) <= 0.0) break;
        }
        return findIdx;
    }

    protected static int weightedRandPick(List<Double> rates) {
        double sum = rates.stream().mapToDouble(v -> v).sum();
        return RecallUtil.weightedRandPick(rates, sum);
    }

    private static class HeapNode {
        double weight;
        int value;
        double totalWeight;

        public HeapNode(double weight, int value) {
            this.weight = weight;
            this.value = value;
            this.totalWeight = weight;
        }
    }
}

