package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIdeaInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;


public class AdxDirectlyPk {


    /**
     * 算法接口1-互动&直投PK
     *
     * @param ideaList      互动&直投创意(1个互动id，1个直投id)
     * @param pkType        PK评判标准：1=按出价高者胜出；2=按收益高者胜出
     * @param ideaStatDoMap 创意统计数据 (key:ideaId)
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyPk.class);

    public static AdxDirectlyPkDo getPk(List<Long> ideaList, Long pkType,
                                        Map<Long, AdxIdeaInfoDo> ideaStatDoMap) {

        AdxDirectlyPkDo ret = new AdxDirectlyPkDo();

        try {

            Long winIdeaId = null;
            Long interIdeaId = null, directlyIdeaId = null ;
            Long interPrice = null, directlyPrice = null;
            Double interRpm = null, directlyRpm = null;
            AdxIdeaInfoDo interIdeaInfo = null, directlyIdeaInfo = null;


            if (AssertUtil.isNotEmpty(ideaList)) {

                //默认胜出者
                winIdeaId = ideaList.get(0);

                if (ideaList.size() == 2L) {

                    //默认胜出者
                    double random1 = Math.random();
                    if (random1 <= 0.5) { winIdeaId = ideaList.get(1); }

                    if (AssertUtil.isNotEmpty(ideaStatDoMap)) {

                        // 获取互动、直投创意统计信息
                        for (Long ind : ideaList) {
                            AdxIdeaInfoDo ideaInfo = ideaStatDoMap.get(ind);
                            if (AssertUtil.isNotEmpty(ideaInfo)){

                                if (AssertUtil.isNotEmpty(ideaInfo.getPriceType())
                                        && ideaInfo.getPriceType() != 2) {

                                    interIdeaId = ind;
                                    interIdeaInfo = ideaInfo;
                                    AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(interIdeaInfo.getIdeaMinStatDoMap());
                                    interPrice = interIdeaInfo.getPrice();
                                    interRpm = interIndexStatMs.getRpm();


                                } else if (AssertUtil.isNotEmpty(ideaInfo.getPriceType())
                                        && ideaInfo.getPriceType() == 2) {

                                    directlyIdeaId = ind;
                                    directlyIdeaInfo = ideaInfo;
                                    AdxIndexStatsDo directlyIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaMinStatDoMap());
                                    directlyPrice = directlyIdeaInfo.getPrice();
                                    directlyRpm = directlyIndexStatMs.getRpm();

                                }

                            }

                        }


                        // PK评判：无法比较时,50%直投胜出,50%互动胜出; 1=按出价高者胜出; 2=按收益高者胜出;
                        if (AssertUtil.isAllNotEmpty(interIdeaId, directlyIdeaId)){
                            winIdeaId = interIdeaId;

                            if (AssertUtil.isEmpty(pkType) || pkType == 1L) {

                                if (AdxStatData.isEqual(directlyPrice, interPrice)
                                        || AssertUtil.isAnyEmpty(directlyPrice, interPrice)) {

                                    double random2 = Math.random();
                                    if (random2 <= 0.5) { winIdeaId = directlyIdeaId; }

                                } else if (AdxStatData.isLarger(directlyPrice, interPrice)) {
                                    winIdeaId = directlyIdeaId;
                                }

                            } else if (pkType == 2L) {

                                if (AdxStatData.isEqual(directlyRpm, interRpm)
                                        || AssertUtil.isAnyEmpty(directlyRpm, interRpm)) {

                                    double random3 = Math.random();
                                    if (random3 <= 0.5) { winIdeaId = directlyIdeaId; }

                                } else if (AdxStatData.isLarger(directlyRpm, interRpm)) {
                                    winIdeaId = directlyIdeaId;
                                }

                            }

                        }

                    }

                }

            }

            ret.setIdeaId(winIdeaId);
            ret.setInterPrice(interPrice);
            ret.setDirectlyPrice(directlyPrice);
            ret.setInterRpm(interRpm);
            ret.setDirectlyRpm(directlyRpm);


        } catch (Exception e) {
            logger.error("AdxDirectlyPk.getPk error:" + e);

        }

        return ret;
    }



}
