package cn.com.duiba.nezha.alg.alg.vo.adx.pd;


import java.io.Serializable;
import java.util.Map;

/**
 * PD决策维稳对象
 */
public class AdxPdControlDo implements Serializable {

    private static final long serialVersionUID = -3590439029284237675L;

    /**
     * 决策控制因子
     */
    private Double controlFactor;

    /**
     * 低质流量放弃比例
     */
    private Double giveUpRate;

    /**
     * 策略实时rpm
     */
    private Double rpmMs;

    /**
     * 策略累计rpm
     */
    private Double rpmDay;

    /**
     * 策略实时ROI
     */
    private Double roiMs;

    /**
     * 策略累计ROI
     */
    private Double roiDay;

    /**
     * 策略实时竞价成功率
     */
    private Double sucMs;

    /**
     * 策略累计竞价成功率
     */
    private Double sucDay;

    /**
     * 策略实时adx成本
     */
    private Long adxCostMs;

    /**
     * 策略累计adx成本
     */
    private Long adxCostDay;

    /**
     * 策略实时advert消耗
     */
    private Long adConsumeMs;

    /**
     * 策略累计advert消耗
     */
    private Long adConsumeDay;

    /**
     * 策略实时竞价量级
     */
    private Long bidCntMs;

    /**
     * 策略累计竞价量级
     */
    private Long bidCntDay;

    /**
     * 策略实时竞价成功量级
     */
    private Long sucCntMs;

    /**
     * 策略累计竞价成功量级
     */
    private Long sucCntDay;

    /**
     * 数据是否置信
     */
    private Boolean isConfidence;

    /**
     * PD目标ROI(小数：1.15)
     */
    private Double targetRoi;


    public Double getControlFactor() { return controlFactor; }

    public void setControlFactor(Double controlFactor) { this.controlFactor = controlFactor; }

    public Double getGiveUpRate() { return giveUpRate; }

    public void setGiveUpRate(Double giveUpRate) { this.giveUpRate = giveUpRate; }

    public Double getRpmMs() {
        return rpmMs;
    }

    public void setRpmMs(Double rpmMs) {
        this.rpmMs = rpmMs;
    }

    public Double getRpmDay() {
        return rpmDay;
    }

    public void setRpmDay(Double rpmDay) {
        this.rpmDay = rpmDay;
    }

    public Double getRoiMs() {
        return roiMs;
    }

    public void setRoiMs(Double roiMs) {
        this.roiMs = roiMs;
    }

    public Double getRoiDay() {
        return roiDay;
    }

    public void setRoiDay(Double roiDay) {
        this.roiDay = roiDay;
    }

    public Double getSucMs() {
        return sucMs;
    }

    public void setSucMs(Double sucMs) {
        this.sucMs = sucMs;
    }

    public Double getSucDay() {
        return sucDay;
    }

    public void setSucDay(Double sucDay) {
        this.sucDay = sucDay;
    }

    public Long getAdxCostMs() {
        return adxCostMs;
    }

    public void setAdxCostMs(Long adxCostMs) {
        this.adxCostMs = adxCostMs;
    }

    public Long getAdxCostDay() {
        return adxCostDay;
    }

    public void setAdxCostDay(Long adxCostDay) {
        this.adxCostDay = adxCostDay;
    }

    public Long getAdConsumeMs() {
        return adConsumeMs;
    }

    public void setAdConsumeMs(Long adConsumeMs) {
        this.adConsumeMs = adConsumeMs;
    }

    public Long getAdConsumeDay() {
        return adConsumeDay;
    }

    public void setAdConsumeDay(Long adConsumeDay) {
        this.adConsumeDay = adConsumeDay;
    }

    public Long getBidCntMs() {
        return bidCntMs;
    }

    public void setBidCntMs(Long bidCntMs) {
        this.bidCntMs = bidCntMs;
    }

    public Long getBidCntDay() {
        return bidCntDay;
    }

    public void setBidCntDay(Long bidCntDay) {
        this.bidCntDay = bidCntDay;
    }

    public Long getSucCntMs() {
        return sucCntMs;
    }

    public void setSucCntMs(Long sucCntMs) {
        this.sucCntMs = sucCntMs;
    }

    public Long getSucCntDay() {
        return sucCntDay;
    }

    public void setSucCntDay(Long sucCntDay) {
        this.sucCntDay = sucCntDay;
    }

    public Boolean getConfidence() {
        return isConfidence;
    }

    public void setConfidence(Boolean confidence) {
        isConfidence = confidence;
    }

    public Double getTargetRoi() { return targetRoi; }

    public void setTargetRoi(Double targetRoi) { this.targetRoi = targetRoi; }
}
