package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class OcpxControlModel {

    /**
     * 广告-配置     维度 参数对象
     * Map<广告ID，Map<配置ID，参数>>
     */
    Map<Long, Map<Long, OcpxControlSubModel>> ocpxControlSubModelMap = new HashMap<>();


    /**
     * 广告,广告位 冷启动 控制参数
     */
    Map<Long, Map<Long, AdControlParams>> adAndSlotControlParamsHashMap = new HashMap<>();

    /**
     * 广告位  冷启动 控制参数
     */

    Map<Long, SlotControlParams> slotControlParamsMap = new HashMap<>();


    String updateTime;

    public OcpxControlSubModel getOcpxControlSubModel(Long adId, Long pkId) {

        if (!ocpxControlSubModelMap.containsKey(adId)) {
            ocpxControlSubModelMap.put(adId, new HashMap<>());
        }


        if (ocpxControlSubModelMap.get(adId).get(pkId) == null) {
            ocpxControlSubModelMap.get(adId).put(pkId, new OcpxControlSubModel());
        }


        return ocpxControlSubModelMap.get(adId).get(pkId);
    }

    public void putOcpxControlSubModel(Long adId, Long pkId, OcpxControlSubModel ocpxControlSubModel) {

        if (!ocpxControlSubModelMap.containsKey(adId)) {
            ocpxControlSubModelMap.put(adId, new HashMap<>());
        }
        ocpxControlSubModelMap.get(adId).put(pkId, ocpxControlSubModel);

    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public AdControlParams getAdAndSlotControlParams(Long adId, Long slotId) {


        if (!adAndSlotControlParamsHashMap.containsKey(adId)) {
            adAndSlotControlParamsHashMap.put(adId, new HashMap<>());
        }

        if (adAndSlotControlParamsHashMap.get(adId).get(slotId) == null) {
            adAndSlotControlParamsHashMap.get(adId).put(slotId, new AdControlParams());
        }

        return adAndSlotControlParamsHashMap.get(adId).get(slotId);
    }


    /**
     * 广告参数
     *
     * @param adId
     * @return
     */
    public void putAdAndSlotControlParams(Long adId, Long slotId, AdControlParams adControlParams) {


        if (!adAndSlotControlParamsHashMap.containsKey(adId)) {
            adAndSlotControlParamsHashMap.put(adId, new HashMap<>());
        }

        adAndSlotControlParamsHashMap.get(adId).put(slotId, adControlParams);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public SlotControlParams getSlotControlParams(Long slotId) {

        if (slotControlParamsMap.get(slotId) == null) {
            slotControlParamsMap.put(slotId, new SlotControlParams());
        }
        return slotControlParamsMap.get(slotId);
    }

    /**
     * 广告位参数
     *
     * @param slotId
     * @return
     */
    public void putSlotControlParams(Long slotId, SlotControlParams slotControlParams) {

        slotControlParamsMap.put(slotId, slotControlParams);
    }
}
