/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaRcmdAlg;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeaRcmdAlg {
    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);
    static double[] weight = new double[]{100.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5};

    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();
        try {
            HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
            HashMap<Long, Double> preExpValueMap = new HashMap<Long, Double>();
            Map preCtrMap = new HashMap();
            HashMap<Long, Double> statCtrMap = new HashMap<Long, Double>();
            HashMap<Long, Double> statDayCtrMap = new HashMap<Long, Double>();
            Map preClickValueMap = new HashMap();
            HashMap<Long, Double> statClickValueMap = new HashMap<Long, Double>();
            HashMap<Long, Double> statDayClickValueMap = new HashMap<Long, Double>();
            Double statCtrResource = null;
            Double statClickValueResource = null;
            Double mergeRpm = null;
            Double pRpm = null;
            Double sRpm = null;
            Long giveUpType = IdeaRcmdAlg.getGiveUpType(rcmdRequestDo);
            rcmdRequestDo = Optional.ofNullable(rcmdRequestDo).orElse(new AdxIdeaRcmdRequestDo());
            Integer putType = Optional.ofNullable(rcmdRequestDo.getPutType()).orElse(3);
            if (AssertUtil.isEmpty((Object)giveUpType)) {
                LocalTFModel ltfModel;
                CODER2 coderModel;
                AdxFeatureDo adxFeatureDo = rcmdRequestDo.getAdxFeatureDo();
                Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
                List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                for (AdxIdeaFeatureDo ideaDo : ideaList) {
                    Long ideaId = ideaDo.getIdeaId();
                    AdxFeatureDo dynamicDo = new AdxFeatureDo();
                    dynamicDo.setIdeaId(ideaId);
                    dynamicDo.setButtonText(ideaDo.getButtonText());
                    dynamicDo.setIconH(ideaDo.getIconH());
                    dynamicDo.setIconW(ideaDo.getIconW());
                    dynamicDo.setMjPicType(ideaDo.getMjPicType());
                    dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1());
                    dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1());
                    dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2());
                    dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2());
                    dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3());
                    dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3());
                    dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum());
                    dynamicDo.setStyleStandard(ideaDo.getStyleStandard());
                    dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo());
                    dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo());
                    Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                    featureMapDo.setStaticFeatureMap(staticFeatureMap);
                    featureMap.put(ideaId, featureMapDo);
                }
                FM fmModel = rcmdRequestDo.getFmModel();
                preCtrMap = fmModel.predictsNew(featureMap);
                if (putType.equals(2) && AssertUtil.isAllNotEmpty((Object[])new Object[]{coderModel = rcmdRequestDo.getCoderModel(), ltfModel = rcmdRequestDo.getLtfModel()})) {
                    preClickValueMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                }
            }
            AdxStatsDo resoStats = Optional.ofNullable(rcmdRequestDo.getResoStats()).orElse(new AdxStatsDo());
            AdxIndexStatDo resoLast20MinStat = resoStats.getLast20MinStat();
            AdxIndexStatsDo resoStatsMin = AdxStatData.adxIndexCompute(resoLast20MinStat);
            statCtrResource = resoStatsMin.getCtr();
            statClickValueResource = resoStatsMin.getClickValue();
            Map<Long, AdxStatsDo> ideaStatsList = rcmdRequestDo.getIdeaStatsList();
            if (AssertUtil.isNotEmpty(ideaStatsList)) {
                for (Map.Entry<Long, AdxStatsDo> entry : ideaStatsList.entrySet()) {
                    Long ideaId = entry.getKey();
                    AdxStatsDo ideaStats = Optional.ofNullable(entry.getValue()).orElse(new AdxStatsDo());
                    AdxIndexStatDo ideaLast20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatDo ideaLast1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(ideaLast20MinStat);
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(ideaLast1DayStat);
                    statCtrMap.put(ideaId, ideaStatsMin.getCtr());
                    statClickValueMap.put(ideaId, ideaStatsMin.getClickValue());
                    statDayCtrMap.put(ideaId, ideaStatsDay.getCtr());
                    statDayClickValueMap.put(ideaId, ideaStatsDay.getClickValue());
                }
            }
            Long bestIdeaId = null;
            if (putType.equals(0) || putType.equals(1)) {
                bestIdeaId = rcmdRequestDo.getManualIdeaId();
            } else if (putType.equals(3)) {
                AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
                adxIdeaRcmdParam.setIdeaFeatureList(rcmdRequestDo.getIdeaFeatureList());
                adxIdeaRcmdParam.setAdxFeatureDo(rcmdRequestDo.getAdxFeatureDo());
                adxIdeaRcmdParam.setAdxResourceRcmdDo(rcmdRequestDo.getAdxResourceRcmdDo());
                AdxIdeaFeatureDo result = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
                if (AssertUtil.isNotEmpty((Object)result)) {
                    bestIdeaId = result.getIdeaId();
                    mergeRpm = result.getMergeRpm();
                    pRpm = result.getPRpm();
                    sRpm = result.getSRpm();
                    if (AssertUtil.isAllEmpty((Object[])new Object[]{giveUpType, bestIdeaId})) {
                        giveUpType = 7L;
                    }
                }
            } else if (putType.equals(2)) {
                Double preCtrWeight = 0.8;
                Double preCvaWeight = 0.2;
                List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                if (AssertUtil.isNotEmpty(ideaList)) {
                    for (AdxIdeaFeatureDo ideaDo : ideaList) {
                        Long ideaId = ideaDo.getIdeaId();
                        Double pCtr = (Double)preCtrMap.get(ideaId);
                        Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault((Double)statCtrMap.get(ideaId), (Double)statDayCtrMap.get(ideaId)), statCtrResource);
                        Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preCtrWeight, 0.0, 4.0, 0.01);
                        Double pClickValue = (Double)preClickValueMap.get(ideaId);
                        Double sClickValue = AdxStatData.nullToDefault(AdxStatData.nullToDefault((Double)statClickValueMap.get(ideaId), (Double)statDayClickValueMap.get(ideaId)), statClickValueResource);
                        Double conClickValue = AdxStatData.getConValue(pClickValue, sClickValue, preCvaWeight, 0.0, 2.0, 1.0);
                        Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conClickValue, 0.0);
                        preExpValueMap.put(ideaId, DataUtil.formatDouble((Double)preExpValue, (int)6));
                    }
                    bestIdeaId = IdeaRcmdAlg.getBestIdeaId(ideaList, preExpValueMap);
                }
            }
            HashMap<String, String> combineFeatureMap = new HashMap<String, String>();
            FeatureMapDo bestFeatureMap = (FeatureMapDo)featureMap.get(bestIdeaId);
            if (AssertUtil.isNotEmpty((Object)bestFeatureMap) && AssertUtil.isNotEmpty((Map)bestFeatureMap.getStaticFeatureMap()) && AssertUtil.isNotEmpty((Map)bestFeatureMap.getDynamicFeatureMap())) {
                combineFeatureMap.putAll(bestFeatureMap.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeatureMap.getDynamicFeatureMap());
            }
            ret.setIdeaId(bestIdeaId);
            ret.setGiveUpType(giveUpType);
            ret.setIdeaFeatureMap(combineFeatureMap);
            ret.setPreCtr((Double)preCtrMap.get(bestIdeaId));
            ret.setStatCtr((Double)statCtrMap.get(bestIdeaId));
            ret.setStatCtrResource(statCtrResource);
            ret.setPreClickValue((Double)preClickValueMap.get(bestIdeaId));
            ret.setStatClickValue((Double)statClickValueMap.get(bestIdeaId));
            ret.setStatClickValueResource(statClickValueResource);
            ret.setMergeRpm(mergeRpm);
            ret.setPRpm(pRpm);
            ret.setSRpm(sRpm);
            ret.setIdeaScoreMap(JSONObject.toJSONString(preExpValueMap));
        }
        catch (Exception e) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd error", (Throwable)e);
        }
        return ret;
    }

    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        Long ret = null;
        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxIdeaRcmdRequestDo is null");
            return 1L;
        }
        if (rcmdRequestDo.getPutType() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is null");
            return 1L;
        }
        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params fmModel is null");
            return 2L;
        }
        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getCoderModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params coderModel is null");
            return null;
        }
        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getLtfModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params ltfModel is null");
            return null;
        }
        if (AssertUtil.isEmpty(rcmdRequestDo.getIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params ideaFeatureList is empty");
            return 5L;
        }
        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxFeatureDo is null");
            return 6L;
        }
        return ret;
    }

    public static Long getBestIdeaId(List<AdxIdeaFeatureDo> ideaList, Map<Long, Double> valueMap) {
        Long ret = null;
        if (AssertUtil.isNotEmpty(ideaList)) {
            int size = ideaList.size();
            if (size == 1) {
                AdxIdeaFeatureDo bestIdeaDo = ideaList.get(0);
                ret = bestIdeaDo.getIdeaId();
            } else {
                ArrayList<Double> flowRateList = new ArrayList<Double>(size);
                if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {
                    Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
                    ArrayList<Long> sortedKeyList = new ArrayList<Long>(sortedMap.keySet());
                    ArrayList<Double> sortedValueList = new ArrayList<Double>(sortedMap.values());
                    Double maxExpValue = (Double)sortedValueList.get(0);
                    Double minExpValue = (Double)sortedValueList.get(size - 1);
                    for (int ind = 0; ind < size; ++ind) {
                        if (maxExpValue.equals(minExpValue)) {
                            flowRateList.add(weight[0]);
                            continue;
                        }
                        if (ind < weight.length) {
                            flowRateList.add(weight[ind]);
                        } else {
                            flowRateList.add(weight[weight.length - 1]);
                        }
                        if (ind < 1 || !((Double)sortedValueList.get(ind)).equals(sortedValueList.get(ind - 1))) continue;
                        flowRateList.set(ind, (Double)flowRateList.get(ind - 1));
                    }
                    Integer retIndex = AdxStatData.flowSplit(flowRateList);
                    ret = (Long)sortedKeyList.get(retIndex);
                }
            }
        }
        return ret;
    }
}

