/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BudgetSmooth {
    public static double[] reqDist = new double[]{0.0, 3.0, 4.5, 5.5, 6.5, 7.5, 9.5, 13.0, 17.5, 22.0, 27.0, 32.0, 37.0, 43.0, 48.5, 53.5, 58.5, 63.5, 68.5, 74.0, 79.5, 85.5, 91.0, 96.0, 100.0};

    public static <T> Map<T, BudgetSmoothDo> getBudgetRatio(Map<T, BudgetInfo> advertBudgetInfoMap) {
        HashMap ret = new HashMap();
        if (AssertUtil.isNotEmpty(advertBudgetInfoMap)) {
            advertBudgetInfoMap.forEach((advert, budgetInfo) -> ret.put(advert, BudgetSmooth.getRatio(budgetInfo)));
        }
        return ret;
    }

    public static BudgetSmoothDo getRatio(BudgetInfo advertBudget) {
        BudgetSmoothDo ret = null;
        if (advertBudget != null) {
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getAccountBudgetInfo(), false, 1L));
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getAdvertBudgetInfo(), false, 2L));
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationBudgetInfo(), false, 3L));
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationAndAppBudgetInfo(), false, 4L));
            ret = BudgetSmooth.getMaxRatio(ret, BudgetSmooth.getBudgetSmooth(advertBudget.getOrientationAndTimeBudgetInfo(), true, 5L));
        }
        return ret;
    }

    public static BudgetSmoothDo getMaxRatio(BudgetSmoothDo cMaxRatio, BudgetSmoothDo nRatio) {
        BudgetSmoothDo ret = cMaxRatio;
        if (nRatio != null) {
            if (cMaxRatio == null) {
                ret = nRatio;
            } else {
                if (cMaxRatio.getRatio() == null && nRatio.getRatio() != null) {
                    ret = nRatio;
                }
                if (cMaxRatio.getRatio() != null && nRatio.getRatio() != null) {
                    ret = cMaxRatio.getRatio() > nRatio.getRatio() ? cMaxRatio : nRatio;
                }
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budget, boolean isHour, Long type) {
        BudgetSmoothDo ret = null;
        if (budget != null) {
            ret = new BudgetSmoothDo();
            Double timeRatio = null;
            Double budgetRatio = null;
            timeRatio = isHour ? BudgetSmooth.getTimeRatio(budget.getTime(), budget.getStartTime(), budget.getEndTime()) : BudgetSmooth.getTimeRatio(budget.getTime());
            budgetRatio = BudgetSmooth.getBudgetRatio(budget.getBudget(), budget.getConsumeTotal());
            Double ratio = BudgetSmooth.getRatio(budgetRatio, timeRatio);
            ret.setBudgetDo(budget);
            ret.setBudgetRatio(budgetRatio);
            ret.setTimeRatio(timeRatio);
            ret.setType(type);
            if (!BudgetSmooth.isDelay(budget.getTime())) {
                ret.setRatio(ratio);
            }
        }
        return ret;
    }

    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;
        if (budgetRatio != null && timeRatio != null && timeRatio > 0.0 && budgetRatio > 0.0) {
            ret = DataUtil.division((Double)budgetRatio, (Double)timeRatio, (int)5);
        }
        return ret;
    }

    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10L) {
            Long consume = Math.max(1L, consumeTotal);
            ret = DataUtil.division((Long)consume, (Long)budget, (int)5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime, String startHour, String endHour) {
        Double ret = null;
        if (updateTime != null) {
            Date updateDate = DateUtil.getDate((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            String updateHour = DateUtil.getTimeString((Date)updateDate, (DateStyle)DateStyle.HH_MM);
            Integer totalMinutes = DateUtil.getIntervalMinutes((String)startHour, (String)endHour, (DateStyle)DateStyle.HH_MM);
            Integer usedMinutes = DateUtil.getIntervalMinutes((String)startHour, (String)updateHour, (DateStyle)DateStyle.HH_MM);
            if (totalMinutes != null && usedMinutes != null && totalMinutes >= 30) {
                ret = ((double)usedMinutes.intValue() + 1.0) / ((double)totalMinutes.intValue() + 1.0);
            }
        }
        return DataUtil.formatDouble(ret, (int)5);
    }

    public static boolean isDelay(String updateTime) {
        boolean ret = true;
        if (updateTime != null) {
            String currentTime = DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer delayMinutes = DateUtil.getIntervalMinutes((String)updateTime, (String)currentTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer updateHour = DateUtil.getHour((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer currentHour = DateUtil.getHour((String)currentTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (delayMinutes != null && updateHour != null && currentHour != null && delayMinutes <= 3 && updateHour == currentHour) {
                ret = false;
            }
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime) {
        Double ret = null;
        if (updateTime != null) {
            Integer hour = DateUtil.getHour((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer minute = DateUtil.getMinute((String)updateTime, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (hour != null && minute != null) {
                double ratio1 = reqDist[hour];
                double ratio2 = (reqDist[hour + 1] - reqDist[hour]) * ((double)minute.intValue() + 1.0) / 61.0;
                ret = (ratio1 + ratio2) / 100.0;
            }
        }
        return DataUtil.formatDouble(ret, (int)5);
    }

    public static void main(String[] args) {
        BudgetInfo budget = new BudgetInfo();
        BudgetDo acc = new BudgetDo();
        acc.setBudget(10000L);
        acc.setConsumeTotal(1000L);
        acc.setPeriodId(null);
        acc.setTime("2018-10-08 11:50:20");
        budget.setAccountBudgetInfo(acc);
        BudgetSmoothDo ret = BudgetSmooth.getRatio(budget);
        for (int ii = 0; ii < 20; ++ii) {
            System.out.println(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
            for (int i = 0; i < 2000; ++i) {
                BudgetSmooth.getRatio(budget);
            }
        }
        System.out.println("ret = " + JSON.toJSONString((Object)ret));
    }
}

