/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.correct;

import cn.com.duiba.nezha.alg.alg.vo.CorrectionInfo;
import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Arrays;
import java.util.List;

public class ModelPredCorrect {
    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {
        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            if (info == null) continue;
            info.setCorrectionFactor(1.0);
            info.setReconstructionFactor(1.0);
            ModelPredCorrect.setCorrectionFactor(info);
        }
    }

    public static void setCorrectionFactor(CorrectionInfo info) throws Exception {
        if (info == null) {
            return;
        }
        if (info.getCurrentPreValue() == null) {
            return;
        }
        if (info.getCurrentPreValue() < 1.0E-10) {
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();
        Double avgPreValue = null;
        Double avgFeedbackValue = null;
        Double vUpperLimit = null;
        Double vLowerLimit = null;
        Double fUpperLimit = null;
        Double fLowerLimit = null;
        Long launchCnt = 0L;
        if (type.equals(1L)) {
            avgPreValue = nezhaStatDto.getPreCtrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCtrAvg();
            launchCnt = nezhaStatDto.getCtrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 0.01;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        if (type.equals(2L)) {
            avgPreValue = nezhaStatDto.getPreCvrAvg();
            avgFeedbackValue = nezhaStatDto.getStatCvrAvg();
            launchCnt = nezhaStatDto.getCvrLaunchCnt();
            vUpperLimit = 0.9999;
            vLowerLimit = 5.0E-4;
            fUpperLimit = 3.0;
            fLowerLimit = 0.2;
        }
        Double newCurrentPreValue = ModelPredCorrect.correctionValue(currentPreValue, avgPreValue, avgFeedbackValue, vLowerLimit, vUpperLimit);
        Double currentPreFactor = ModelPredCorrect.noiseSmoother(newCurrentPreValue / currentPreValue, fLowerLimit, fUpperLimit);
        info.setCorrectionFactor(currentPreFactor);
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static Double correctionValue(Double currentPreValue, Double avgPreValue, Double avgFeedbackValue, Double lowerLimit, Double upperLimit) throws Exception {
        Double ret = currentPreValue;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{currentPreValue, avgPreValue, avgFeedbackValue, upperLimit, lowerLimit})) {
            return ret;
        }
        if (currentPreValue > 0.0 && avgPreValue > 0.0 && avgFeedbackValue > 0.0) {
            Double lndValue = ModelPredCorrect.noiseSmoother(currentPreValue * avgFeedbackValue / avgPreValue, lowerLimit, upperLimit);
            Double ndValue = ModelPredCorrect.noiseSmoother(currentPreValue + avgFeedbackValue - avgPreValue, lowerLimit, upperLimit);
            ret = avgPreValue > avgFeedbackValue ? Double.valueOf(Math.max(lndValue, ndValue)) : Double.valueOf(Math.min(lndValue, ndValue));
            ret = 0.8 * ret + 0.19999999999999996 * currentPreValue;
        }
        return ret;
    }

    public static Double sigmoidWithZoomAndIntervalMap(double x, double lowerLimit, double upperLimit, double zoom) {
        return lowerLimit + (upperLimit - lowerLimit) * ModelPredCorrect.sigmoidWithZoom(x, zoom);
    }

    public static Double sigmoidWithZoom(double x, double zoom) {
        return ModelPredCorrect.sigmoid(x * zoom);
    }

    public static Double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static void main(String[] args) {
        try {
            NezhaStatDto nezhaStatDto = new NezhaStatDto();
            nezhaStatDto.setAdvertId(13675L);
            nezhaStatDto.setCtrLaunchCnt(1000000L);
            nezhaStatDto.setCvrLaunchCnt(1000000L);
            nezhaStatDto.setAlgType(206L);
            nezhaStatDto.setAppId(20453L);
            nezhaStatDto.setPreCtrAvg(0.15);
            nezhaStatDto.setStatCtrAvg(0.14);
            nezhaStatDto.setPreCvrAvg(0.16);
            nezhaStatDto.setStatCvrAvg(0.09);
            CorrectionInfo info = new CorrectionInfo();
            info.setAdvertId(13675L);
            info.setType(1L);
            info.setCurrentPreValue(0.059);
            info.setNezhaStatDto(nezhaStatDto);
            ModelPredCorrect.getCorrectionFactor(Arrays.asList(info));
            System.out.println("testGetCorrectionFactor CTR info.getCorrectionFactor()" + info.getCorrectionFactor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

