package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

@Data
public class AdxBaseStatDo {
    /**
     * 竞价请求次数
     */
    private long reqCnt;

    /**
     * 竞价返回次数
     */
    private long bidCnt;

    /**
     * 曝光次数
     */
    private long impCnt;

    /**
     * 点击次数
     */
    private long clickCnt;

    /**
     * 媒体消耗
     */
    private long adxFee;

    /**
     * 广告消耗
     */
    private long adFee;


    /**
     * 计算分成比例
     * @param adxBaseStatDo
     * @return
     */
    public static Double getShareRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = 1.;

        if(adxBaseStatDo != null) {
            if(adxBaseStatDo.adFee > 200) {
                ret = DataUtil.division(adxBaseStatDo.adxFee, adxBaseStatDo.adFee, 3);
            }
        }
        return ret;
    }

    /**
     * 计算竞价成功率
     */
    public static Double getSucRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = null;
        if(adxBaseStatDo != null) {
            if(adxBaseStatDo.bidCnt > 100) {
                ret = DataUtil.division(adxBaseStatDo.impCnt, adxBaseStatDo.bidCnt, 3);
            }
        }
        return ret;
    }

}
