/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;

public class BidControl {
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        HashMap<String, AdBidResultDo> ret = new HashMap<String, AdBidResultDo>();
        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {
            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();
            AdBidResultDo adBidResultDo = BidControl.bidControl(adBidInputDo, paramsModel);
            ret.put(key, adBidResultDo);
        }
        return ret;
    }

    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();
        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        if (adBidInputDo.getChargeType() == 1) {
            adBidResultDo.setFee(adBidInputDo.getFee());
        }
        if (adBidInputDo.getChargeType() == 2) {
            AdBidParamsDo adBidParamsDo;
            long fee = BidControl.getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());
            adBidResultDo.setFee(fee);
            adBidResultDo.setFactor(1.0);
            if (AssertUtil.isNotEmpty((Object)paramsModel) && AssertUtil.isNotEmpty((Object)(adBidParamsDo = BidControl.getBidParams(adBidInputDo, paramsModel, fee)))) {
                adBidResultDo.setFee(adBidParamsDo.getFee());
                adBidResultDo.setFactor(adBidParamsDo.getFactor());
                adBidResultDo.setAdBidParamsDo(adBidParamsDo);
                adBidResultDo.setReservePriceGiveUp(adBidParamsDo.getIsGiveUp());
            }
        }
        return adBidResultDo;
    }

    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel, long fee) {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        Long cpcFee = adBidInputDo.getFee();
        OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setFactor(1.0);
        adBidParamsDo.setDeepControlTestId(adBidInputDo.getDeepControlTestId());
        adBidParamsDo.setIsDeepControl(adBidInputDo.getIsDeepControl());
        adBidParamsDo.setReservePriceWhite(adBidInputDo.getReservePriceWhite());
        adBidParamsDo.setIsAutoTarget(adBidInputDo.getIsAutoTarget());
        if (ocpxControlSubModel != null) {
            OcpxControlParams pkParams = ocpxControlSubModel.getOcpxControlParams();
            OcpxControlParams atPkParams = ocpxControlSubModel.getAtOcpxControlParams();
            OcpxControlParams slotParams = ocpxControlSubModel.getOcpxControlParams(slotId);
            BidControl.costControl(adBidParamsDo, pkParams, slotParams, atPkParams);
            BidControl.deepControl(adBidParamsDo, slotParams);
            BidControl.floorPriceControl(adBidParamsDo, pkParams, slotParams);
            BidControl.protectControl(adBidParamsDo, pkParams, slotParams, atPkParams);
        }
        BidControl.coldControl(adBidParamsDo, paramsModel.getAdAndSlotControlParams(advertId, slotId), paramsModel.getSlotControlParams(slotId), cpcFee);
        return adBidParamsDo;
    }

    public static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {
        Long factorType = 3L;
        Double factor = 1.0;
        Long fee = adBidParamsDo.getFee();
        Integer resetType = OcpxControlParams.getResetType(pkParams);
        Double slotFactor = OcpxControlParams.getCostFactor(slotParams);
        Double pkFactor = OcpxControlParams.getCostFactor(pkParams);
        Double atPkFactor = OcpxControlParams.getCostFactor(atPkParams);
        if (atPkFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget().booleanValue()) {
            factorType = 3L;
            factor = atPkFactor;
        } else if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
        } else if (pkFactor != null) {
            factorType = 1L;
            factor = pkFactor;
        }
        Long feeNew = Math.round((double)fee.longValue() * factor);
        adBidParamsDo.setResetType(resetType);
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor);
        adBidParamsDo.setFee(feeNew);
    }

    public static void deepControl(AdBidParamsDo adBidParamsDo, OcpxControlParams slotParams) {
        Double factor;
        Long fee = adBidParamsDo.getFee();
        if (adBidParamsDo.getIsDeepControl() == null || !adBidParamsDo.getIsDeepControl().booleanValue()) {
            return;
        }
        if (adBidParamsDo.getDeepControlTestId() != null && adBidParamsDo.getDeepControlTestId().equals(1L) && (factor = OcpxControlParams.getDeepFactor(slotParams)) != null) {
            Long feeNew = Math.round((double)fee.longValue() * factor);
            adBidParamsDo.setDeepFactor(factor);
            adBidParamsDo.setFee(feeNew);
        }
    }

    public static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams, Long cpcFee) {
        Boolean coldProject = null;
        Long coldProjectFeeDiff = null;
        Long fee = adBidParamsDo.getFee();
        if (slotControlParams != null && (adControlParams == null || adControlParams != null && adControlParams.getIsColdStart() != null && adControlParams.getIsColdStart().booleanValue())) {
            coldProject = true;
            Long feeNew = SlotControlParams.getFee(fee, cpcFee, slotControlParams);
            coldProjectFeeDiff = fee - feeNew;
            fee = feeNew;
        }
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);
    }

    public static void exploreControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Long fee;
        Long feeNew = fee = adBidParamsDo.getFee();
        Long exploreFeeDiff = null;
        if (slotParams != null && slotParams.getEConf().booleanValue()) {
            feeNew = OcpxControlParams.getExplorePrice(slotParams, fee);
        } else if (pkParams != null && pkParams.getEConf().booleanValue()) {
            feeNew = OcpxControlParams.getExplorePrice(pkParams, fee);
        } else {
            return;
        }
        exploreFeeDiff = feeNew - fee;
        adBidParamsDo.setExplore(true);
        adBidParamsDo.setExploreFeeDiff(exploreFeeDiff);
        adBidParamsDo.setFee(feeNew);
    }

    public static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {
        Boolean secondPriceProject = null;
        Double secondProtectPriceFactor = null;
        Double slotProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(slotParams);
        Double pkProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(pkParams);
        Double atProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(atPkParams);
        if (atProtectPriceFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget().booleanValue()) {
            secondProtectPriceFactor = atProtectPriceFactor;
        } else if (slotProtectPriceFactor != null) {
            secondProtectPriceFactor = slotProtectPriceFactor;
        } else if (pkProtectPriceFactor != null) {
            secondProtectPriceFactor = pkProtectPriceFactor;
        }
        if (secondProtectPriceFactor != null) {
            secondPriceProject = true;
        }
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setCFactor(secondProtectPriceFactor);
        adBidParamsDo.setSecondPriceProjectFactor(secondProtectPriceFactor);
    }

    public static void floorPriceControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean isGiveUp = null;
        if (adBidParamsDo.getReservePriceWhite() != null && adBidParamsDo.getReservePriceWhite().booleanValue()) {
            adBidParamsDo.setReservePriceWhite(true);
            return;
        }
        Long giveUpFee = null;
        Double giveUpRatio = null;
        if (slotParams != null && slotParams.getFConf() != null && slotParams.getFConf().booleanValue()) {
            giveUpFee = slotParams.getFPriceThre();
            giveUpRatio = slotParams.getFGiveUpProb();
        } else if (pkParams != null && pkParams.getFConf() != null && pkParams.getFConf().booleanValue()) {
            giveUpFee = pkParams.getFPriceThre();
            giveUpRatio = pkParams.getFGiveUpProb();
        } else {
            return;
        }
        double rate = Math.random();
        if (giveUpRatio != null && giveUpFee != null && rate < giveUpRatio && adBidParamsDo.getFee() <= giveUpFee) {
            isGiveUp = true;
        }
        adBidParamsDo.setIsGiveUp(isGiveUp);
        adBidParamsDo.setGiveUpFee(giveUpFee);
        adBidParamsDo.setGiveUpRatio(giveUpRatio);
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {
        OcpxControlParams ocpxControlParams;
        OcpxControlSubModel ocpxControlSubModel;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, paramsModel}) && (ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId)) != null && (ocpxControlParams = ocpxControlSubModel.getOcpxControlParams()) != null) {
            ocpxControlParams.setResetType(type);
        }
    }

    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {
        if (AssertUtil.isEmpty((Object)top1)) {
            return bidResultTop1;
        }
        if (bidResultTop1 != null) {
            bidResultTop1.setFee(top1.getFee());
        }
        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Double protectPriceFactor = bidResultTop1.getAdBidParamsDo().getCFactor();
            if (isSecondPriceProject != null && isSecondPriceProject.booleanValue() && protectPriceFactor != null) {
                if (protectPriceFactor < 0.5) {
                    protectPriceFactor = 0.1;
                }
                long protectFee = top1.getFee();
                if (top1.getFee() > 15L) {
                    protectFee = Math.round((double)top1.getFee().longValue() * protectPriceFactor);
                    protectFee = Math.max(protectFee, 15L);
                }
                long secondFee = protectFee;
                if (!AssertUtil.isEmpty((Object)top2)) {
                    secondFee = BidControl.getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                }
                long feeNew = Math.max(secondFee, protectFee);
                feeNew = Math.min(feeNew, top1.getFee());
                bidResultTop1.setFee(feeNew);
            }
        }
        return bidResultTop1;
    }

    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * (double)fee2 / ctr1;
        return Math.round(feeNew) + 1L;
    }

    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {
        return appFee == null ? BidControl.getOcpcFee(cvr, afee, specialAccountWeight) : BidControl.getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * (double)afee * specialAccountWeight);
    }
}

