/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterCntDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AdxStatData {
    private static long ADX_MULTIPLIER = 10000000L;

    public static Map<String, Long> getStrategyStatData(String strategy, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long defaultCnt = 0L;
        Long defaultConsume = 0L;
        Long bidCnt = defaultCnt;
        Long sucCnt = defaultCnt;
        Long expCnt = defaultCnt;
        Long clickCnt = defaultCnt;
        Long adxConsume = defaultConsume;
        Long advertConsume = defaultConsume;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{strategy, strategyDoList})) {
            List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
            bidCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID.getCode(), defaultCnt);
            sucCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.BID_SUC.getCode(), defaultCnt);
            expCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.EXP.getCode(), defaultCnt);
            clickCnt = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.CLICK.getCode(), defaultCnt);
            adxConsume = DataUtil.double2Long((double)(StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADX_CONSUME.getCode(), defaultConsume) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = StrategyBid.getSumLevelIndex(strategyDo, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
        }
        retMap.put(AdxIndex.BID.getCode(), bidCnt);
        retMap.put(AdxIndex.BID_SUC.getCode(), sucCnt);
        retMap.put(AdxIndex.EXP.getCode(), expCnt);
        retMap.put(AdxIndex.CLICK.getCode(), clickCnt);
        retMap.put(AdxIndex.ADX_CONSUME.getCode(), adxConsume);
        retMap.put(AdxIndex.ADVERT_CONSUME.getCode(), advertConsume);
        return retMap;
    }

    public static List<AdxLevelDo> getStrategyInfo(Map<String, AdxStrategyDo> strategyInfo, String strategy) {
        AdxStrategyDo strategyDo;
        List<AdxLevelDo> ret = new ArrayList<AdxLevelDo>();
        if (AssertUtil.isNotEmpty(strategyInfo) && AssertUtil.isNotEmpty((Object)(strategyDo = strategyInfo.get(strategy)))) {
            ret = strategyDo.getLevelDoList();
        }
        return ret;
    }

    public static AdxIndexStatsDo getStrategyIndex(List<AdxLevelDo> levelDoList, String timeIndex) {
        AdxIndexStatDo sumLevelStatDo = new AdxIndexStatDo();
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        Long advertLaunch = 0L;
        Long advertClick = 0L;
        Double preClickValueSum = 0.0;
        if (AssertUtil.isNotEmpty(levelDoList)) {
            for (AdxLevelDo levelDo : levelDoList) {
                if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
                AdxIndexStatDo adxIndexStatDo = new AdxIndexStatDo();
                if (timeIndex.equals("20min")) {
                    adxIndexStatDo = levelDo.getLast20MinStat();
                } else if (timeIndex.equals("1day")) {
                    adxIndexStatDo = levelDo.getLast1DayStat();
                }
                AdxIndexStatsDo indexCompute = AdxStatData.adxIndexCompute(adxIndexStatDo);
                bidCnt = bidCnt + indexCompute.getBidCnt();
                sucCnt = sucCnt + indexCompute.getSucCnt();
                expCnt = expCnt + indexCompute.getExpCnt();
                clickCnt = clickCnt + indexCompute.getClickCnt();
                adxConsume = adxConsume + indexCompute.getAdxConsume();
                advertConsume = advertConsume + indexCompute.getAdvertConsume();
                advertLaunch = advertLaunch + indexCompute.getAdvertLaunch();
                advertClick = advertClick + indexCompute.getAdvertClick();
                preClickValueSum = preClickValueSum + indexCompute.getPreClickValueSum();
            }
        }
        sumLevelStatDo.setBid(bidCnt);
        sumLevelStatDo.setBidSuc(sucCnt);
        sumLevelStatDo.setExp(expCnt);
        sumLevelStatDo.setClick(clickCnt);
        sumLevelStatDo.setAdxConsume(adxConsume);
        sumLevelStatDo.setAdvertConsume(advertConsume);
        sumLevelStatDo.setAdvertLaunch(advertLaunch);
        sumLevelStatDo.setAdvertClick(advertClick);
        sumLevelStatDo.setPreClickValue(preClickValueSum);
        sumLevelStatDo.setAdxConsume(AdxStatData.multiply(sumLevelStatDo.getAdxConsume(), ADX_MULTIPLIER));
        AdxIndexStatsDo ret = AdxStatData.adxIndexCompute(sumLevelStatDo);
        return ret;
    }

    public static Map<String, Long> getLevelIndex(List<AdxLevelDo> levelDoList, String statIndex, String timeIndex, Long label) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        if (AssertUtil.isNotEmpty(levelDoList)) {
            for (AdxLevelDo levelDo : levelDoList) {
                if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
                String key = levelDo.getLevel();
                AdxIndexStatDo adxIndexStatDo = new AdxIndexStatDo();
                if (timeIndex.equals("20min")) {
                    adxIndexStatDo = levelDo.getLast20MinStat();
                } else if (timeIndex.equals("1day")) {
                    adxIndexStatDo = levelDo.getLast1DayStat();
                }
                AdxIndexStatsDo indexCompute = AdxStatData.adxIndexCompute(adxIndexStatDo);
                Long ret = 0L;
                if (statIndex.equals(AdxIndex.BID.getCode())) {
                    ret = indexCompute.getBidCnt();
                } else if (statIndex.equals(AdxIndex.BID_SUC.getCode())) {
                    ret = indexCompute.getSucCnt();
                } else if (statIndex.equals(AdxIndex.EXP.getCode())) {
                    ret = indexCompute.getExpCnt();
                } else if (statIndex.equals(AdxIndex.CLICK.getCode())) {
                    ret = indexCompute.getClickCnt();
                } else if (statIndex.equals(AdxIndex.ADX_CONSUME.getCode())) {
                    ret = indexCompute.getAdxConsume();
                } else if (statIndex.equals(AdxIndex.ADVERT_CONSUME.getCode())) {
                    ret = indexCompute.getAdvertConsume();
                }
                retMap.put(key, ret);
            }
        }
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (retMap.get(key) != null) continue;
            retMap.put(key, 0L);
        }
        return retMap;
    }

    public static Map<String, Double> getLevelIndex(List<AdxLevelDo> levelDoList, String statIndex, String timeIndex) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (AssertUtil.isNotEmpty(levelDoList)) {
            for (AdxLevelDo levelDo : levelDoList) {
                if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
                String key = levelDo.getLevel();
                AdxIndexStatDo adxIndexStatDo = new AdxIndexStatDo();
                if (timeIndex.equals("20min")) {
                    adxIndexStatDo = levelDo.getLast20MinStat();
                } else if (timeIndex.equals("1day")) {
                    adxIndexStatDo = levelDo.getLast1DayStat();
                }
                AdxIndexStatsDo indexCompute = AdxStatData.adxIndexCompute(adxIndexStatDo);
                Double ret = null;
                if (statIndex.equals("roi")) {
                    ret = indexCompute.getRoi();
                } else if (statIndex.equals("sucRate")) {
                    ret = indexCompute.getSucRate();
                } else if (statIndex.equals("ctr")) {
                    ret = indexCompute.getCtr();
                } else if (statIndex.equals("rpm")) {
                    ret = indexCompute.getRpm();
                } else if (statIndex.equals("clickValue")) {
                    ret = indexCompute.getClickValue();
                } else if (statIndex.equals("launchPv")) {
                    ret = indexCompute.getLaunchPv();
                } else if (statIndex.equals("cpc")) {
                    ret = indexCompute.getCpc();
                }
                retMap.put(key, ret);
            }
        }
        return retMap;
    }

    public static Map<String, Long> getlevelIndexStat(String strategy, String indexLabel, ArrayList<AdxStrategyDo> strategyDoList) {
        HashMap<String, Long> retMap = new HashMap();
        Long defaultValue = 0L;
        List<AdxLevelDo> strategyDo = StrategyBid.getStrategyInfo(strategyDoList, strategy);
        retMap = StrategyBid.getLevelIndex(strategyDo, indexLabel, defaultValue);
        if (indexLabel.equals(AdxIndex.ADX_CONSUME.getCode())) {
            retMap.replaceAll((k, v) -> DataUtil.double2Long((Double)DataUtil.division((Long)v, (Long)ADX_MULTIPLIER)));
        }
        return retMap;
    }

    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 50L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) : DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxConsume + defaultAdxConsume), (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getLevelRoi(Map<String, Long> adxMap, Map<String, Long> advertMap, Double targetRoi) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultAdxConsume = 25L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxMap, advertMap})) {
                if (adxMap.get(key) >= defaultAdxConsume) {
                    ret = DataUtil.division((Long)advertMap.get(key), (Long)adxMap.get(key), (int)6);
                    retMap.put(key, ret);
                    continue;
                }
                ret = DataUtil.division((Double)((double)advertMap.get(key).longValue() + (double)defaultAdxConsume.longValue() * targetRoi), (Long)(adxMap.get(key) + defaultAdxConsume), (int)6);
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getRoiFactorRectify(Map<String, Double> roiMap, Map<String, Long> adxConsumeLevelMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long adxConsumeLimit = 50L;
        Long adxConsumeBaseLimit = 25L;
        Double baseRoi = AdxStatData.nullToMinDefault(roiMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 0.0);
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            retMap.put(key, roiMap.get(key));
        }
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo)) {
            Map<String, Double> factorMap = directlyFactorDoInfo.getFactorExploreMap();
            Double baseFactor = 1.0;
            if (AssertUtil.isNotEmpty(factorMap)) {
                baseFactor = AdxStatData.nullToMinDefault(factorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), 1.0);
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || !AssertUtil.isNotEmpty(adxConsumeLevelMs) || adxConsumeLevelMs.get(key) >= adxConsumeLimit || adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < adxConsumeBaseLimit) continue;
                Double diff = DataUtil.division((Double)factorMap.get(key), (Double)baseFactor);
                Double roi = baseRoi * diff;
                retMap.put(key, DataUtil.formatDouble((Double)roi, (int)6));
            }
        }
        return retMap;
    }

    public static Double getSucRate(Map<String, Long> mapInfo, Long defaultCnt) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long sucCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID_SUC.getCode()), defaultValue);
            if (bidCnt >= defaultCnt) {
                ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6), 0.0, 0.0, 1.0);
            }
        }
        return ret;
    }

    public static Map<String, Double> getLevelSucRate(Map<String, Long> bidCntMap, Map<String, Long> sucCntMap) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultCnt = 10L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidCntMap, sucCntMap})) {
                if (bidCntMap.get(key) >= defaultCnt) {
                    ret = AdxStatData.getNormalValue(DataUtil.division((Long)sucCntMap.get(key), (Long)bidCntMap.get(key), (int)6), 0.0, 0.0, 1.0);
                    retMap.put(key, ret);
                    continue;
                }
                retMap.put(key, 0.0);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Map<String, Double> getFlowRateAdjust(Map<String, Double> flowRateMap, Integer ind, Double step) {
        Double defaultFlowRate;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double firFlowRate = defaultFlowRate = Double.valueOf(0.33);
        Double secFlowRate = defaultFlowRate;
        Double thiFlowRate = defaultFlowRate;
        if (AssertUtil.isNotEmpty(flowRateMap)) {
            firFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_FIR.getCode()), defaultFlowRate, 0.1, 0.8);
            secFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_SEC.getCode()), defaultFlowRate, 0.1, 0.8);
            thiFlowRate = AdxStatData.getNormalValue(flowRateMap.get(AdxStrategy.ADX_STRATEGY_THI.getCode()), defaultFlowRate, 0.1, 0.8);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ind, step})) {
            if (ind == 1) {
                firFlowRate = firFlowRate + step;
            } else if (ind == 2) {
                secFlowRate = secFlowRate + step;
            } else if (ind == 3) {
                thiFlowRate = thiFlowRate + step;
            }
        }
        retMap.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlowRate);
        retMap.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlowRate);
        return retMap;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Integer nullToDefault(Integer value, Integer defaultValue) {
        Integer ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static Double nullToMinDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToMinDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper, int newScala) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return DataUtil.formatDouble((Double)ret, (int)newScala);
    }

    public static Long getNormalValue(Long value, Long defaultValue, Long lower, Long upper) {
        Long ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static boolean isLarger(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isLarger(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Long value1, Long value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEqual(Double value1, Double value2) {
        boolean ret = false;
        if (value1 != null && value2 != null && value1.equals(value2)) {
            ret = true;
        }
        return ret;
    }

    public static Double getFlowRateScore(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long bidCntLimit = 20L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long adxConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = AdxStatData.nullToMinDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            if (bidCnt >= bidCntLimit) {
                ret = DataUtil.division((Double)((double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue()), (Long)bidCnt) * 1000.0;
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static Double getTryFlowRate(Double roiMsDiff, Long adxConsumeTryMs, AdxDirectlyFactorDo directlyFactorDoInfo) {
        Map<String, Double> flowRateMap;
        Double ret = 0.2;
        Double lastRate = 0.2;
        if (AssertUtil.isNotEmpty((Object)directlyFactorDoInfo) && AssertUtil.isNotEmpty(flowRateMap = directlyFactorDoInfo.getFactorFlowRateMap())) {
            lastRate = AdxStatData.getNormalValue(flowRateMap.get(AdxLevel.ADX_LEVEL_ONE.getCode()), lastRate, 0.02, 1.0);
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roiMsDiff, adxConsumeTryMs})) {
            Long adxConsumeMs = AdxStatData.nullToDefault(adxConsumeTryMs, 0L);
            Double baseRate = AdxStatData.getNormalValue(DataUtil.division((Double)100.0, (Long)adxConsumeMs) * lastRate, lastRate, 0.02, 0.8);
            ret = roiMsDiff > 0.98 ? Double.valueOf(baseRate + Math.min(DataUtil.division((Double)roiMsDiff, (Double)0.98) - 1.0, 1.0) * (1.0 - baseRate)) : (adxConsumeMs < 100L ? baseRate : (adxConsumeMs > 1000L ? Double.valueOf(baseRate * 1.5) : Double.valueOf(baseRate * 1.2)));
        }
        return AdxStatData.getNormalValue(ret, 0.2, 0.02, 1.0);
    }

    public static Double getTryFlowRate(Double tryDiff, Long tryAdxCost, Double lastTryRate) {
        Double ret = 0.2;
        Long adxCost = AdxStatData.nullToDefault(tryAdxCost, 0L);
        if (AssertUtil.isNotEmpty((Object)tryDiff)) {
            Double baseRate = AdxStatData.getNormalValue(DataUtil.division((Double)200.0, (Long)adxCost) * lastTryRate, lastTryRate, 0.02, 0.8);
            ret = tryDiff < 0.98 ? Double.valueOf(baseRate + Math.min(1.0 - DataUtil.division((Double)tryDiff, (Double)0.98), 1.0) * (1.0 - baseRate)) : (adxCost < 200L ? baseRate : (adxCost > 1000L ? Double.valueOf(baseRate * 1.5) : Double.valueOf(baseRate * 1.2)));
        }
        return AdxStatData.getNormalValue(ret, 0.2, 0.02, 1.0);
    }

    public static Double getConfidentAdxConsume(Double roi) {
        Double ret = 100.0;
        if (AssertUtil.isNotEmpty((Object)roi)) {
            ret = 100.0 + DataUtil.division((Double)(roi - 1.0), (Double)0.1499999999999999) * 100.0;
        }
        return AdxStatData.getNormalValue(ret, 100.0, 100.0, 200.0);
    }

    public static Double getTryUppStepCon(Long adxConsume, Double roi, Double limit) {
        Double ret = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxConsume, roi, limit})) {
            Double confidentConsume = AdxStatData.getConfidentAdxConsume(roi);
            ret = (double)adxConsume.longValue() <= confidentConsume ? Double.valueOf((1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume)) * limit) : Double.valueOf(Math.max(1.0 - DataUtil.division((Long)adxConsume, (Double)confidentConsume), -1.0) * limit);
        }
        return DataUtil.formatDouble((Double)AdxStatData.getNormalValue(ret, 0.0, -limit.doubleValue(), limit), (int)3);
    }

    public static String selectBestLevel(Map<String, Long> bidMap, Map<String, Long> adxMap, Map<String, Long> advertMap) {
        String ret = AdxLevel.ADX_LEVEL_TWO.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidMap, adxMap, advertMap})) {
            Double tmpRpm = -1.0E7;
            for (AdxLevel adxLevel : AdxLevel.values()) {
                Double profit;
                Double rpm;
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Long bid = AdxStatData.nullToMinDefault(bidMap.get(key), 0L);
                Long adx = AdxStatData.nullToMinDefault(adxMap.get(key), 0L);
                Long advert = AdxStatData.nullToMinDefault(advertMap.get(key), 0L);
                if (!AdxStatData.isLarger(bid, 10L) || !AdxStatData.isLarger(adx, 25L) || !AdxStatData.isLarger(advert, 25L) || !((rpm = MathUtil.division((Double)((profit = Double.valueOf((double)advert.longValue() / 1.15 - (double)adx.longValue())) * 1000.0), (Long)bid, (int)6)) > tmpRpm)) continue;
                ret = key;
                tmpRpm = rpm;
            }
        }
        return ret;
    }

    public static String selectCpcBestLevel(Map<String, Long> bidMap, Map<String, Long> clickMap, Map<String, Long> adxCostMap, Double targetCpc) {
        String ret = AdxLevel.ADX_LEVEL_TWO.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{bidMap, clickMap, adxCostMap})) {
            Double tmpAbsDiff = 1.0E7;
            for (AdxLevel adxLevel : AdxLevel.values()) {
                Double cpc;
                Double absDiff;
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Long bid = AdxStatData.nullToMinDefault(bidMap.get(key), 0L);
                Long click = AdxStatData.nullToMinDefault(clickMap.get(key), 0L);
                Long adxCost = AdxStatData.nullToMinDefault(adxCostMap.get(key), 0L);
                if (!AdxStatData.isLarger(bid, 20L) || !AdxStatData.isLarger(click, 5L) || !AdxStatData.isLarger(adxCost, 25L) || !((absDiff = Double.valueOf(Math.abs((cpc = DataUtil.division((Long)adxCost, (Long)click)) / targetCpc - 1.0))) < tmpAbsDiff)) continue;
                ret = key;
                tmpAbsDiff = absDiff;
            }
        }
        return ret;
    }

    public static AdxIndexStatsDo indexStatCompute(Map<String, Long> indexStatInfo) {
        AdxIndexStatsDo ret = new AdxIndexStatsDo();
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        if (AssertUtil.isNotEmpty(indexStatInfo)) {
            bidCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID.getCode()), 0L);
            sucCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.BID_SUC.getCode()), 0L);
            expCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.EXP.getCode()), 0L);
            clickCnt = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.CLICK.getCode()), 0L);
            adxConsume = DataUtil.double2Long((double)(AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADX_CONSUME.getCode()), 0L) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = AdxStatData.nullToMinDefault(indexStatInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), 0L);
            if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(sucCnt, 20L) && AdxStatData.isLarger(expCnt, 10L) && AdxStatData.isLarger(clickCnt, 2L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double roi = MathUtil.division((Long)advertConsume, (Long)adxConsume, (int)6);
                Double sucRate = MathUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double profit = (double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue();
                Double rpm = MathUtil.division((Double)(profit * 1000.0), (Long)bidCnt, (int)6);
                ret.setRoi(roi);
                ret.setSucRate(sucRate);
                ret.setCtr(ctr);
                ret.setRpm(rpm);
            }
        }
        ret.setConfident(isConfident);
        ret.setBidCnt(bidCnt);
        ret.setSucCnt(sucCnt);
        ret.setExpCnt(expCnt);
        ret.setClickCnt(clickCnt);
        ret.setAdxConsume(adxConsume);
        ret.setAdvertConsume(advertConsume);
        return ret;
    }

    public static Integer getPreInterval(Double preValue) {
        Integer ret = null;
        Double[] preList = new Double[]{0.002, 0.003, 0.005, 0.007, 0.01};
        if (AssertUtil.isNotEmpty((Object)preValue) && preValue >= 0.0) {
            ret = preValue < preList[0] ? 1 : (preValue < preList[1] ? 2 : (preValue < preList[2] ? 3 : (preValue < preList[3] ? 4 : (preValue < preList[4] ? 5 : 6))));
        }
        return ret;
    }

    public static AdxIndexStatsDo adxIndexCompute(AdxIndexStatDo adxIndexStats) {
        AdxIndexStatsDo ret = new AdxIndexStatsDo();
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        Long advertLaunch = 0L;
        Long advertClick = 0L;
        Double preClickValueSum = 0.0;
        if (AssertUtil.isNotEmpty((Object)adxIndexStats)) {
            bidCnt = AdxStatData.nullToMinDefault(adxIndexStats.getBid(), 0L);
            sucCnt = AdxStatData.nullToMinDefault(adxIndexStats.getBidSuc(), 0L);
            expCnt = AdxStatData.nullToMinDefault(adxIndexStats.getExp(), 0L);
            clickCnt = AdxStatData.nullToMinDefault(adxIndexStats.getClick(), 0L);
            adxConsume = DataUtil.double2Long((double)(AdxStatData.nullToMinDefault(adxIndexStats.getAdxConsume(), 0L) / ADX_MULTIPLIER), (Long)1L);
            advertConsume = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertConsume(), 0L);
            advertLaunch = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertLaunch(), 0L);
            advertClick = AdxStatData.nullToMinDefault(adxIndexStats.getAdvertClick(), 0L);
            preClickValueSum = AdxStatData.nullToMinDefault(adxIndexStats.getPreClickValue(), 0.0);
            if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(sucCnt, 20L) && AdxStatData.isLarger(expCnt, 10L) && AdxStatData.isLarger(clickCnt, 2L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
                isConfident = true;
            }
            if (isConfident) {
                Double roi = MathUtil.division((Long)advertConsume, (Long)adxConsume, (int)6);
                Double sucRate = MathUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
                Double ctr = MathUtil.division((Long)clickCnt, (Long)expCnt, (int)6);
                Double profit = (double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue();
                Double rpm = MathUtil.division((Double)(profit * 1000.0), (Long)bidCnt, (int)6);
                Double clickValue = MathUtil.division((Long)advertConsume, (Long)clickCnt, (int)6);
                Double launchPv = MathUtil.division((Long)advertLaunch, (Long)clickCnt, (int)6);
                Double cpc = MathUtil.division((Long)adxConsume, (Long)clickCnt, (int)6);
                Double chargePv = MathUtil.division((Long)advertClick, (Long)clickCnt, (int)6);
                ret.setRoi(AdxStatData.nullToMinDefault(roi, 0.0));
                ret.setSucRate(AdxStatData.getNormalValue(sucRate, 0.0, 0.0, 1.0));
                ret.setCtr(AdxStatData.getNormalValue(ctr, 0.0, 0.0, 1.0));
                ret.setRpm(rpm);
                ret.setClickValue(AdxStatData.nullToMinDefault(clickValue, 0.0));
                ret.setLaunchPv(AdxStatData.nullToMinDefault(launchPv, 0.0));
                ret.setCpc(cpc);
                ret.setChargePv(AdxStatData.nullToMinDefault(chargePv, 0.0));
            }
        }
        ret.setConfident(isConfident);
        ret.setBidCnt(bidCnt);
        ret.setSucCnt(sucCnt);
        ret.setExpCnt(expCnt);
        ret.setClickCnt(clickCnt);
        ret.setAdxConsume(adxConsume);
        ret.setAdvertConsume(advertConsume);
        ret.setAdvertLaunch(advertLaunch);
        ret.setAdvertClick(advertClick);
        ret.setPreClickValueSum(preClickValueSum);
        return ret;
    }

    public static AdxIndexStatsDo getAdxTimeIndex(AdxStatsDo statsDo, String timeIndex) {
        AdxStatsDo adxStatsDo = Optional.ofNullable(statsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo adxIndexStatDo = new AdxIndexStatDo();
        if (timeIndex.equals("20min")) {
            adxIndexStatDo = adxStatsDo.getLast20MinStat();
        } else if (timeIndex.equals("1hour")) {
            adxIndexStatDo = adxStatsDo.getLast1HourStat();
        } else if (timeIndex.equals("1day")) {
            adxIndexStatDo = adxStatsDo.getLast1DayStat();
        } else if (timeIndex.equals("3day")) {
            adxIndexStatDo = adxStatsDo.getLast3DayStat();
        } else if (timeIndex.equals("7day")) {
            adxIndexStatDo = adxStatsDo.getLast7DayStat();
        }
        AdxIndexStatsDo ret = AdxStatData.adxIndexCompute(adxIndexStatDo);
        return ret;
    }

    public static Map<Integer, AdxIndexStatsDo> intervalIndexCompute(Map<Integer, AdxIndexStatDo> intervalStats) {
        Integer preIntervalSize = 5;
        HashMap<Integer, AdxIndexStatsDo> retMap = new HashMap<Integer, AdxIndexStatsDo>(preIntervalSize);
        boolean isConfident = false;
        Long bidCnt = 0L;
        Long sucCnt = 0L;
        Long expCnt = 0L;
        Long clickCnt = 0L;
        Long adxConsume = 0L;
        Long advertConsume = 0L;
        for (int key = 1; key <= preIntervalSize; ++key) {
            AdxIndexStatDo intervalInfo;
            AdxIndexStatsDo ret = new AdxIndexStatsDo();
            if (AssertUtil.isNotEmpty(intervalStats) && AssertUtil.isNotEmpty((Object)(intervalInfo = intervalStats.get(key)))) {
                ret = AdxStatData.adxIndexCompute(intervalInfo);
            }
            ret.setConfident(isConfident);
            ret.setBidCnt(bidCnt);
            ret.setSucCnt(sucCnt);
            ret.setExpCnt(expCnt);
            ret.setClickCnt(clickCnt);
            ret.setAdxConsume(adxConsume);
            ret.setAdvertConsume(advertConsume);
            retMap.put(key, ret);
        }
        return retMap;
    }

    public static Double getConRoi(AdxIndexStatsDo hourDo, AdxIndexStatsDo dayDo) {
        Double ret = null;
        Double conWeight = 0.5;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{hourDo, dayDo})) {
            Long hourAdx = AdxStatData.nullToMinDefault(hourDo.getAdxConsume(), 0L);
            Long hourAdvert = AdxStatData.nullToMinDefault(hourDo.getAdvertConsume(), 0L);
            Long dayAdx = AdxStatData.nullToMinDefault(dayDo.getAdxConsume(), 0L);
            Long dayAdvert = AdxStatData.nullToMinDefault(dayDo.getAdvertConsume(), 0L);
            Double conAdx = conWeight * (double)hourAdx.longValue() + (1.0 - conWeight) * (double)dayAdx.longValue();
            Double conAdvert = conWeight * (double)hourAdvert.longValue() + (1.0 - conWeight) * (double)dayAdvert.longValue();
            if (AdxStatData.isLarger(conAdx, 25.0) && AdxStatData.isLarger(conAdvert, 25.0)) {
                ret = MathUtil.division((Double)conAdvert, (Double)conAdx, (int)6);
            }
        }
        return ret;
    }

    public static Double getConCpc(AdxIndexStatsDo statsDo1, AdxIndexStatsDo statsDo2, Double targetCpc, Double conWeight) {
        Double ret = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{statsDo1, statsDo2})) {
            Long clickCnt1 = AdxStatData.nullToMinDefault(statsDo1.getClickCnt(), 0L);
            Long adxCost1 = AdxStatData.nullToMinDefault(statsDo1.getAdxConsume(), 0L);
            Long clickCnt2 = AdxStatData.nullToMinDefault(statsDo2.getClickCnt(), 0L);
            Long adxCost2 = AdxStatData.nullToMinDefault(statsDo2.getAdxConsume(), 0L);
            Double conClickCnt = conWeight * (double)clickCnt1.longValue() + (1.0 - conWeight) * (double)clickCnt2.longValue();
            Double conAdxCost = conWeight * (double)adxCost1.longValue() + (1.0 - conWeight) * (double)adxCost2.longValue();
            ret = AdxStatData.isLarger(clickCnt1, 5L) && AdxStatData.isLarger(adxCost1, 25L) ? MathUtil.division((Long)adxCost1, (Long)clickCnt1, (int)6) : (AdxStatData.isLarger(conClickCnt, 5.0) && AdxStatData.isLarger(conAdxCost, 25.0) ? MathUtil.division((Double)conAdxCost, (Double)conClickCnt, (int)6) : DataUtil.formatDouble((Double)DataUtil.division((Double)((double)adxCost1.longValue() + 5.0 * targetCpc), (Double)((double)clickCnt1.longValue() + 5.0)), (int)6));
        }
        return ret;
    }

    public static Map<String, Double> getConCpcLevel(Map<String, Long> clickLevel, Map<String, Long> adxCostLevel, Double targetCpc) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (!key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) {
                Long clickCnt = AdxStatData.nullToMinDefault(clickLevel.get(key), 0L);
                Long adxCost = AdxStatData.nullToMinDefault(adxCostLevel.get(key), 0L);
                ret = AdxStatData.isLarger(clickCnt, 5L) && AdxStatData.isLarger(adxCost, 25L) ? MathUtil.division((Long)adxCost, (Long)clickCnt, (int)6) : DataUtil.formatDouble((Double)DataUtil.division((Double)((double)adxCost.longValue() + 5.0 * targetCpc), (Double)((double)clickCnt.longValue() + 5.0)), (int)6);
            }
            retMap.put(key, ret);
        }
        return retMap;
    }

    public static Long multiply(Long v1, Long v2) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{v1, v2})) {
            ret = v1 * v2;
        }
        return ret;
    }

    public static Long multiply(Long v1, Double v2) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{v1, v2})) {
            ret = DataUtil.double2Long((Double)((double)v1.longValue() * v2));
        }
        return ret;
    }

    public static Double getConCtr(Double preValue, Double statValue, Double preWeight) {
        Double fUpperLimit = 2.0;
        Double fLowerLimit = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double defaultValue = 0.001;
        Double ret = (preValue = AdxStatData.getNormalValue(preValue, statValue = AdxStatData.getNormalValue(statValue, defaultValue, vLowerLimit, vUpperLimit), statValue * fLowerLimit, statValue * fUpperLimit)) * preWeight + statValue * (1.0 - preWeight);
        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);
        return ret;
    }

    public static Double getConCtr(Double preValue, Double statValue, Double preWeight, Double fLowerLimit, Double fUpperLimit, Double defaultValue) {
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double ret = (preValue = AdxStatData.getNormalValue(preValue, statValue = AdxStatData.getNormalValue(statValue, defaultValue, vLowerLimit, vUpperLimit), statValue * fLowerLimit, statValue * fUpperLimit)) * preWeight + statValue * (1.0 - preWeight);
        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);
        return ret;
    }

    public static Double getConValue(Double preValue, Double statValue, Double preWeight, Double fLowerLimit, Double fUpperLimit, Double defaultValue) {
        statValue = AdxStatData.nullToDefault(statValue, defaultValue);
        preValue = AdxStatData.getNormalValue(preValue, statValue, statValue * fLowerLimit, statValue * fUpperLimit);
        Double ret = preValue * preWeight + statValue * (1.0 - preWeight);
        return ret;
    }

    public static Double getConClickValue(Double preValue, Double statValue, Double preWeight) {
        Double fUpperLimit = 2.0;
        Double fLowerLimit = 0.0;
        Double defaultValue = 1.0;
        statValue = AdxStatData.nullToDefault(statValue, defaultValue);
        preValue = AdxStatData.getNormalValue(preValue, statValue, statValue * fLowerLimit, statValue * fUpperLimit);
        Double ret = preValue * preWeight + statValue * (1.0 - preWeight);
        return ret;
    }

    public static Integer bucket(Double value, int[] bucketList) {
        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{value, bucketList}) && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (!(value < (double)bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Integer bucket(Double value, double[] bucketList) {
        Integer ret = 0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{value, bucketList}) && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value < bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Double bucket(Double value, Double[] bucketList) {
        Double ret = 0.0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = bound;
                break;
            }
            if (value > bucketList[bucketList.length - 1]) {
                ret = bucketList[bucketList.length - 1];
            }
        }
        return ret;
    }

    public static Integer flowSplit(List<Double> flowRateList) {
        Integer ret = 0;
        Double sumRate = 0.0;
        if (AssertUtil.isNotEmpty(flowRateList)) {
            int size = flowRateList.size();
            Double[] sumRateList = new Double[size];
            for (int ind = 0; ind < size; ++ind) {
                sumRateList[ind] = sumRate = Double.valueOf(sumRate + AdxStatData.nullToDefault(flowRateList.get(ind), 0.0));
            }
            double random = Math.random();
            for (int ind = 0; ind < size; ++ind) {
                double bound = DataUtil.division((Double)sumRateList[ind], (Double)sumRateList[size - 1]);
                if (!(random <= bound)) continue;
                ret = ind;
                break;
            }
        }
        return ret;
    }

    public static Integer getFlowSplit(List<Long> flowRateList) {
        Integer ret = 0;
        Long sumRate = 0L;
        if (AssertUtil.isNotEmpty(flowRateList)) {
            int size = flowRateList.size();
            Long[] sumRateList = new Long[size];
            for (int ind = 0; ind < size; ++ind) {
                sumRateList[ind] = sumRate = Long.valueOf(sumRate + AdxStatData.nullToDefault(flowRateList.get(ind), 0L));
            }
            double random = Math.random();
            for (int ind = 0; ind < size; ++ind) {
                double bound = DataUtil.division((Long)sumRateList[ind], (Long)sumRateList[size - 1]);
                if (!(random <= bound)) continue;
                ret = ind;
                break;
            }
        }
        return ret;
    }

    public static Double getRectifyFactor(Long clickCnt, Long adConsume, Double preClickValueSum) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{clickCnt, adConsume, preClickValueSum}) && AdxStatData.isLarger(clickCnt, 10L) && AdxStatData.isLarger(adConsume, 100L) && AdxStatData.isLarger(preClickValueSum, 0.0)) {
            ret = DataUtil.division((Double)preClickValueSum, (Long)adConsume, (int)6);
            ret = AdxStatData.getNormalValue(ret, 1.0, 0.5, 1.5);
        }
        return ret;
    }

    public static Double getConRectifyFactor(AdxIndexStatsDo hourDo, AdxIndexStatsDo dayDo) {
        Double ret = null;
        Double conWeight = 0.5;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{hourDo, dayDo})) {
            Long hourClick = hourDo.getClickCnt();
            Long hourAdvert = hourDo.getAdvertConsume();
            Double hourPreClickValueSum = hourDo.getPreClickValueSum();
            Double hourFactor = AdxStatData.getRectifyFactor(hourClick, hourAdvert, hourPreClickValueSum);
            Long dayClick = dayDo.getClickCnt();
            Long dayAdvert = dayDo.getAdvertConsume();
            Double dayPreClickValueSum = dayDo.getPreClickValueSum();
            Double dayFactor = AdxStatData.getRectifyFactor(dayClick, dayAdvert, dayPreClickValueSum);
            Long conClick = DataUtil.double2Long((Double)(conWeight * (double)hourClick.longValue() + (1.0 - conWeight) * (double)dayClick.longValue()));
            Long conAdvert = DataUtil.double2Long((Double)(conWeight * (double)hourAdvert.longValue() + (1.0 - conWeight) * (double)dayAdvert.longValue()));
            Double conPreClickValueSum = conWeight * hourPreClickValueSum + (1.0 - conWeight) * dayPreClickValueSum;
            Double conFactor = AdxStatData.getRectifyFactor(conClick, conAdvert, conPreClickValueSum);
            ret = hourFactor;
            if (AssertUtil.isEmpty((Object)hourFactor)) {
                ret = conFactor;
                if (AssertUtil.isEmpty((Object)conFactor)) {
                    ret = dayFactor;
                }
            }
        }
        return ret;
    }

    public static Double getClickValueRectifyFactor(Integer clickValueLevel, ClickValueRectifyDo clickValueRectify) {
        Map<Integer, Double> rectifyFactorMap;
        Double ret = 1.0;
        if (AssertUtil.isNotEmpty((Object)clickValueRectify) && AssertUtil.isNotEmpty(rectifyFactorMap = clickValueRectify.getRectifyFactorMap())) {
            ret = AdxStatData.getNormalValue(rectifyFactorMap.get(clickValueLevel), 1.0, 0.5, 1.5);
        }
        return ret;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValueDescend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return -compare;
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValueAscend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return compare;
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static Double getFilterRate(Map<Integer, AdxFilterCntDo> ideafilterDo, String timeIndex, Integer filterType) {
        Double ret = 0.0;
        if (AssertUtil.isNotEmpty(ideafilterDo)) {
            AdxFilterCntDo filterCntDo1 = Optional.ofNullable(ideafilterDo.get(0)).orElse(new AdxFilterCntDo());
            AdxFilterCntDo filterCntDo2 = Optional.ofNullable(ideafilterDo.get(1)).orElse(new AdxFilterCntDo());
            AdxFilterCntDo filterCntDo3 = Optional.ofNullable(ideafilterDo.get(2)).orElse(new AdxFilterCntDo());
            AdxFilterCntDo filterCntDo4 = Optional.ofNullable(ideafilterDo.get(3)).orElse(new AdxFilterCntDo());
            Long cnt1 = 0L;
            Long cnt2 = 0L;
            Long cnt3 = 0L;
            Long cnt4 = 0L;
            if (timeIndex.equals("20min")) {
                cnt1 = AdxStatData.nullToMinDefault(filterCntDo1.getLast20MinCnt(), 0L);
                cnt2 = AdxStatData.nullToMinDefault(filterCntDo2.getLast20MinCnt(), 0L);
                cnt3 = AdxStatData.nullToMinDefault(filterCntDo3.getLast20MinCnt(), 0L);
                cnt4 = AdxStatData.nullToMinDefault(filterCntDo4.getLast20MinCnt(), 0L);
            } else if (timeIndex.equals("1day")) {
                cnt1 = AdxStatData.nullToMinDefault(filterCntDo1.getLast1DayCnt(), 0L);
                cnt2 = AdxStatData.nullToMinDefault(filterCntDo2.getLast1DayCnt(), 0L);
                cnt3 = AdxStatData.nullToMinDefault(filterCntDo3.getLast1DayCnt(), 0L);
                cnt4 = AdxStatData.nullToMinDefault(filterCntDo4.getLast1DayCnt(), 0L);
            }
            if (filterType.equals(1) && AdxStatData.isLarger(cnt2, 10L) && AdxStatData.isLarger(cnt1 + cnt2 + cnt3 + cnt4, 40L)) {
                ret = DataUtil.division((Long)cnt2, (Long)(cnt1 + cnt2 + cnt3 + cnt4), (int)5);
            } else if (filterType.equals(2) && AdxStatData.isLarger(cnt3, 10L) && AdxStatData.isLarger(cnt1 + cnt2 + cnt3 + cnt4, 40L)) {
                ret = DataUtil.division((Long)cnt3, (Long)(cnt1 + cnt2 + cnt3 + cnt4), (int)5);
            } else if (filterType.equals(3) && AdxStatData.isLarger(cnt4, 10L) && AdxStatData.isLarger(cnt1 + cnt2 + cnt3 + cnt4, 40L)) {
                ret = DataUtil.division((Long)cnt4, (Long)(cnt1 + cnt2 + cnt3 + cnt4), (int)5);
            }
        }
        return AdxStatData.getNormalValue(ret, 0.0, 0.0, 1.0);
    }

    public static Double getWilsonScore(Long pos, Long total) {
        if (total == 0L) {
            total = 1L;
        }
        if (pos > total) {
            pos = total;
        }
        double p = (double)pos.longValue() * 1.0 / (double)total.longValue() * 1.0;
        double z = 1.96;
        double zSquare = z * z;
        Double score = (p + zSquare / (double)(2L * total) - z * Math.sqrt((double)(4L * total) * p * (1.0 - p) + zSquare) / (double)(2L * total)) / (1.0 + zSquare / (double)total.longValue());
        return DataUtil.formatDouble((Double)score, (int)6);
    }

    public static Double getRpm(Long bidCnt, Long adxConsume, Long advertConsume) {
        Double ret = 0.0;
        if (AdxStatData.isLarger(bidCnt, 50L) && AdxStatData.isLarger(adxConsume, 50L) && AdxStatData.isLarger(advertConsume, 50L)) {
            ret = DataUtil.division((Double)((double)advertConsume.longValue() / 1.15 - (double)adxConsume.longValue()), (Long)bidCnt) * 1000.0;
        }
        return DataUtil.formatDouble((Double)ret, (int)6);
    }
}

