/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxStrategyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxBaseStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxControlReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlySlotDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxSubStatDo;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyFactor.class);

    public static AdxMeiTuanFactorDo getExploreFactor(AdxControlReqDo adxControlReqDo) {
        AdxMeiTuanFactorDo ret = null;
        try {
            AdxStatDo adxStatDo = adxControlReqDo.getAdxStatDo();
            AdxDirecetlySlotDo adxDirecetlySlotDo = adxControlReqDo.getAdxDirecetlySlotDo();
            AdxMeiTuanFactorDo lastAdxRoiFactor = adxControlReqDo.getLastAdxRoiFactor();
            AdxSubStatDo adxSubStatDo1 = adxStatDo.getAdxSubStatDo1();
            AdxBaseStatDo slotStatMins = adxSubStatDo1.getSlotStat();
            Map<Long, AdxBaseStatDo> adStatMins = adxSubStatDo1.getSlotAdvertStat();
            AdxSubStatDo adxSubStatDo2 = adxStatDo.getAdxSubStatDo2();
            AdxBaseStatDo slotStatDay = adxSubStatDo2.getSlotStat();
            Map<Long, AdxBaseStatDo> adStatDay = adxSubStatDo2.getSlotAdvertStat();
            AdxSubStatDo adxSubStatDo3 = adxStatDo.getAdxSubStatDo3();
            AdxBaseStatDo slotStatLast3Days = adxSubStatDo3.getSlotStat();
            Map<Long, Double> advertShareRateMap = adxDirecetlySlotDo.getAdvertShareRateMap();
            if (advertShareRateMap == null) {
                return ret;
            }
            Map<Long, AdxMeiTuanFactorSubDo> slotAdvFactorDoMap = lastAdxRoiFactor.getSlotAdvFactorDoMap();
            advertShareRateMap.forEach((adId, shareRate) -> {
                if (shareRate == null) {
                    return;
                }
                AdxBaseStatDo adxBaseStatDoMins = (AdxBaseStatDo)adStatMins.get(adId);
                AdxBaseStatDo adxBaseStatDoDay = (AdxBaseStatDo)adStatDay.get(adId);
                AdxMeiTuanFactorSubDo adxMeiTuanFactorSubDo = (AdxMeiTuanFactorSubDo)slotAdvFactorDoMap.get(adId);
                AdxDirectlyFactor.getFactor(adxBaseStatDoMins, adxBaseStatDoDay, shareRate, adxMeiTuanFactorSubDo);
            });
            Double shareRate2 = adxDirecetlySlotDo.getShareRate();
            AdxMeiTuanFactorSubDo slotFactorDo = lastAdxRoiFactor.getSlotFactorDo();
            AdxDirectlyFactor.getFactor(slotStatMins, slotStatDay, shareRate2, slotFactorDo);
            AdxDirectlyFactor.getSucRateFactor(slotStatMins, slotStatLast3Days, slotFactorDo);
            ret = lastAdxRoiFactor;
        }
        catch (Exception e) {
            logger.error("AdxDirectlyFactor.getExploreFactor" + e);
        }
        return ret;
    }

    public static void getFactor(AdxBaseStatDo StatMins, AdxBaseStatDo StatDay, Double shareRate, AdxMeiTuanFactorSubDo adxMeiTuanFactorSubDo) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{StatMins, StatDay, shareRate})) {
            return;
        }
        if (adxMeiTuanFactorSubDo == null) {
            adxMeiTuanFactorSubDo = new AdxMeiTuanFactorSubDo();
        }
        if (adxMeiTuanFactorSubDo.getShareRate() != null && adxMeiTuanFactorSubDo.getShareRate() != shareRate) {
            adxMeiTuanFactorSubDo.setRoiFactor(1.0);
            adxMeiTuanFactorSubDo.setShareRate(shareRate);
            adxMeiTuanFactorSubDo.setConfident(true);
            return;
        }
        if (StatMins.getAdxFee() < 200L) {
            adxMeiTuanFactorSubDo.setConfident(false);
            return;
        }
        Double roiFactor = adxMeiTuanFactorSubDo.getRoiFactor();
        if (roiFactor == null) {
            roiFactor = 1.0;
        }
        Double shareRateMins = AdxBaseStatDo.getShareRate(StatMins);
        Double shareRateDay = AdxBaseStatDo.getShareRate(StatDay);
        PidController pidController = new PidController();
        double signal = pidController.runPid(shareRate.doubleValue(), shareRateMins.doubleValue(), shareRateDay.doubleValue());
        roiFactor = roiFactor * (1.0 + signal);
        roiFactor = MathUtil.stdwithBoundary((double)roiFactor, (double)0.95, (double)1.05);
        adxMeiTuanFactorSubDo.setRoiFactor(roiFactor);
        adxMeiTuanFactorSubDo.setShareRate(shareRate);
        adxMeiTuanFactorSubDo.setConfident(true);
    }

    public static void getSucRateFactor(AdxBaseStatDo StatMins, AdxBaseStatDo StatLast3Days, AdxMeiTuanFactorSubDo adxMeiTuanFactorSubDo) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{StatMins, StatLast3Days})) {
            return;
        }
        Double sucRateMins = AdxBaseStatDo.getSucRate(StatMins);
        Double sucRateDay = AdxBaseStatDo.getSucRate(StatLast3Days);
        if (sucRateMins == null || sucRateDay == null) {
            return;
        }
        Double sucFactor = DataUtil.division((Double)(sucRateDay - sucRateMins), (Double)sucRateDay, (int)3);
        sucFactor = MathUtil.stdwithBoundary((double)sucFactor, (double)0.0, (double)0.2);
        adxMeiTuanFactorSubDo.setSucFactor(sucFactor);
    }

    public static AdxDirectlyFactorDo getExploreFactor(AdxDirectlyIdeaDo directlyIdeaInfo, AdxDirectlyFactorDo lastDirectlyFactorInfo) {
        AdxDirectlyFactorDo ret = new AdxDirectlyFactorDo();
        try {
            Double minRoi = 1.0;
            Double defaultFactor = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            int levelSize = AdxLevel.values().length - 1;
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(levelSize);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(levelSize);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(levelSize);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(levelSize);
            Long tryLabel = 0L;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucCntMs = 0L;
            Long adxConsumeMs = 0L;
            Long advertConsumeMs = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Long bidCntDay = 0L;
            Long sucCntDay = 0L;
            Long adxConsumeDay = 0L;
            Long advertConsumeDay = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)directlyIdeaInfo)) {
                Object stepCon;
                Integer feeType = directlyIdeaInfo.getFeeType();
                minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                ArrayList<AdxStrategyDo> StrategyMsDoList = directlyIdeaInfo.getStrategyMsDoList();
                Map<String, Long> strategyMsIndex = AdxStatData.getStrategyStatData(strategy, StrategyMsDoList);
                ArrayList<AdxStrategyDo> StrategyDayDoList = directlyIdeaInfo.getStrategyDayDoList();
                Map<String, Long> strategyDayIndex = AdxStatData.getStrategyStatData(strategy, StrategyDayDoList);
                Map<String, Long> bidCntLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.BID.getCode(), StrategyMsDoList);
                Map<String, Long> sucCntLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.BID_SUC.getCode(), StrategyMsDoList);
                Map<String, Long> adxConsumeLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.ADX_CONSUME.getCode(), StrategyMsDoList);
                Map<String, Long> advertConsumeLevelMs = AdxStatData.getlevelIndexStat(strategy, AdxIndex.ADVERT_CONSUME.getCode(), StrategyMsDoList);
                Map<String, Double> sucRateLevelMs = AdxStatData.getLevelSucRate(bidCntLevelMs, sucCntLevelMs);
                Map<String, Double> roiRealLevelMs = AdxStatData.getLevelRoi(adxConsumeLevelMs, advertConsumeLevelMs, minRoi);
                Map<String, Double> roiLevelMs = AdxStatData.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, lastDirectlyFactorInfo);
                bidCntMs = strategyMsIndex.get(AdxIndex.BID.getCode());
                sucCntMs = strategyMsIndex.get(AdxIndex.BID_SUC.getCode());
                adxConsumeMs = strategyMsIndex.get(AdxIndex.ADX_CONSUME.getCode());
                advertConsumeMs = strategyMsIndex.get(AdxIndex.ADVERT_CONSUME.getCode());
                sucRateMs = AdxStatData.getSucRate(strategyMsIndex, 50L);
                roiMs = AdxStatData.getRoi(strategyMsIndex, minRoi);
                bidCntDay = strategyDayIndex.get(AdxIndex.BID.getCode());
                sucCntDay = strategyDayIndex.get(AdxIndex.BID_SUC.getCode());
                adxConsumeDay = strategyDayIndex.get(AdxIndex.ADX_CONSUME.getCode());
                advertConsumeDay = strategyDayIndex.get(AdxIndex.ADVERT_CONSUME.getCode());
                sucRateDay = AdxStatData.getSucRate(strategyDayIndex, 50L);
                roiDay = AdxStatData.getRoi(strategyDayIndex, minRoi);
                Map<String, Long> resoMapInfo = directlyIdeaInfo.getResourceIndexMap();
                Double resoSucRateMs = AdxStatData.getSucRate(resoMapInfo, 50L);
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.02 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 100L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.02 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 100L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;
                Double uppValue = baseValue - 0.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = AdxStatData.nullToDefault(directlyIdeaInfo.getLastMinRoi(), 1.0);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultFactor;
                } else {
                    Double incre1 = 1.0;
                    if (AssertUtil.isNotEmpty((Object)lastDirectlyFactorInfo)) {
                        Map<String, Double> lastFactorMap = lastDirectlyFactorInfo.getFactorExploreMap();
                        String bestLevel = AdxStatData.selectBestLevel(bidCntLevelMs, adxConsumeLevelMs, advertConsumeLevelMs);
                        lastTryLabel = AdxStatData.nullToDefault(lastDirectlyFactorInfo.getTryLabel(), 0L);
                        if (AssertUtil.isNotEmpty(lastFactorMap)) {
                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                            }
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastFactorMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = baseValue - defaultFactor;
                        baseValue = baseValue - baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.02 || sucRateMs < resoSucRateMs * 0.02 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiMs, (int)3);
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiStable, (int)3);
                            }
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.02 || sucRateMs < resoSucRateMs * 0.02 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, DataUtil.toDouble((Long)adxConsumeDay));
                        incre1 = AdxStatData.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = AdxStatData.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel == 0L) {
                            baseValue = AdxStatData.getNormalValue(baseValue * incre, defaultFactor, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }
                        baseValue = DataUtil.formatDouble((Double)AdxStatData.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
                    }
                }
                if (tryLabel == 2L) {
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.2 - baseValue;
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.2 - baseValue;
                } else if (tryLabel == 1L) {
                    stepList[2] = lowValue - baseValue;
                    stepCon = AdxStatData.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), 0.1);
                    Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.1 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.07 : 0.1)));
                    if ((double)adxConsumeMs.longValue() == 0.0) {
                        stepCon = 0.15;
                        stepRoi = 0.15;
                    }
                    stepList[0] = Math.min(uppValue - baseValue - (0.4 * (Double)stepCon + 0.6 * stepRoi), 0.0);
                } else {
                    stepCon = stepList;
                    Double.valueOf(stepCon[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    stepCon = stepList;
                    Double.valueOf(stepCon[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (tryLabel == 2L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (tryLabel == 1L) {
                    Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    baseFlowRate[0] = AdxStatData.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), lastDirectlyFactorInfo);
                    baseFlowRate[2] = baseFlowRate[0] > 0.8 ? 0.0 : 0.2;
                } else if (diff < 0.9) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;
                } else if (diff > 1.1) {
                    baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                    baseFlowRate[2] = 0.1;
                } else if (diff > 0.95 && diff < 1.05) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = 0.1;
                } else {
                    baseFlowRate[0] = 0.15;
                    baseFlowRate[2] = 0.15;
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[2] - baseFlowRate[0]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                    if (tryLabel != 1L) continue;
                    lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = DataUtil.formatDouble((Double)AdxStatData.getNormalValue(baseValue + stepList[i - 1], defaultFactor, lowerLimit, upperLimit), (int)6);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setCurrentMinRoi(minRoi);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucCntDay(sucCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucCntMs(sucCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyFactor.getExploreFactor error:" + e);
        }
        return ret;
    }
}

