package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class OcpxControlSubModel {

    /**
     * 配置维度 abtest参数对象
     */
//    ABTestParams abTestParams = new ABTestParams();


    /**
     * 常规模式
     */


    // 配置维度 参数对象
    OcpxControlParams ocpxControlParams = new OcpxControlParams();


    //配置维度 参数对象 拓展流量
    OcpxControlParams atOcpxControlParams = new OcpxControlParams();

    //广告位维度 参数对象
    Map<Long, OcpxControlParams> ocpxControlParamsMap = new HashMap<>();


    /**
     * 跑量模式
     */

    //配置维度 参数对象  跑量模式
    OcpxControlParams ocpx2ControlParams = new OcpxControlParams();

    // 配置维度 参数对象 拓展流量   跑量模式
    OcpxControlParams atOcpx2ControlParams = new OcpxControlParams();

    //广告位维度 参数对象   跑量模式
    Map<Long, OcpxControlParams> ocpx2ControlParamsMap = new HashMap<>();


    /**
     * 深度双出价控制参数
     */

    DeepControlParams deepControlParams = new DeepControlParams();


    /**
     * 广告位维度 深度双出价控制参数
     */
    Map<Long, DeepControlParams> deepControlParamsMap = new HashMap<>();

    public OcpxControlParams getOcpxControlParams(Long slotId) {
        if (ocpxControlParamsMap.get(slotId) == null) {
            ocpxControlParamsMap.put(slotId, new OcpxControlParams());
        }
        return ocpxControlParamsMap.get(slotId);
    }


    public void putOcpxControlParams(Long slotId, OcpxControlParams ocpxControlParams) {
        ocpxControlParamsMap.put(slotId, ocpxControlParams);
    }


    public OcpxControlParams getOcpx2ControlParams(Long slotId) {
        if (ocpx2ControlParamsMap.get(slotId) == null) {
            ocpx2ControlParamsMap.put(slotId, new OcpxControlParams());
        }
        return ocpx2ControlParamsMap.get(slotId);
    }


    public void putOcpx2ControlParams(Long slotId, OcpxControlParams ocpxControlParams) {
        ocpx2ControlParamsMap.put(slotId, ocpxControlParams);
    }


    public DeepControlParams getDeepControlParams(Long slotId) {
        if (deepControlParamsMap.get(slotId) == null) {
            deepControlParamsMap.put(slotId, new DeepControlParams());
        }
        return deepControlParamsMap.get(slotId);
    }


    public void putDeepControlParams(Long slotId, DeepControlParams deepControlParams) {
        deepControlParamsMap.put(slotId, deepControlParams);
    }


}
