/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

public class OcpxControlParams {
    private Integer resetType;
    private Boolean cConf;
    private Double fcFactor = 1.0;
    private Double cFactor;
    private Double pcFactor = 1.0;
    private Boolean fConf;
    private Long fPriceThre;
    private Double fGiveUpProb;
    private Boolean eConf;
    private Long ePriceThre;
    private Double eRate;

    public static Double getCostAtFactor(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            ret = params.getCFactor();
            if (params.getCFactor() != null && params.getPcFactor() != null) {
                if (params.getFcFactor() == null) {
                    params.setFcFactor(1.0);
                }
                ret = Math.max(params.getCFactor(), params.getPcFactor());
            }
        }
        return ret;
    }

    public static Double getCostFactor(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            ret = params.getPcFactor() * params.getFcFactor();
        }
        return ret;
    }

    public static Double getCostFactorWithProtect(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue() && params.getCFactor() != null) {
            ret = params.getCFactor();
        }
        return ret;
    }

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        }
        return null;
    }

    public static Long getExplorePrice(OcpxControlParams ocpxControlParams, Long fee) {
        Long ePriceThre;
        Double adjustFee = fee.doubleValue();
        if (ocpxControlParams != null && ocpxControlParams.getEConf() != null && ocpxControlParams.eConf.booleanValue() && (ePriceThre = ocpxControlParams.getEPriceThre()) != null && fee < ePriceThre) {
            adjustFee = adjustFee + ((double)ePriceThre.longValue() - adjustFee) * 0.5;
        }
        return adjustFee.longValue();
    }

    public static Double getExploreRate(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null && ocpxControlParams.getEConf() != null && ocpxControlParams.getEConf().booleanValue()) {
            return ocpxControlParams.getERate();
        }
        return null;
    }

    public Integer getResetType() {
        return this.resetType;
    }

    public Boolean getCConf() {
        return this.cConf;
    }

    public Double getFcFactor() {
        return this.fcFactor;
    }

    public Double getCFactor() {
        return this.cFactor;
    }

    public Double getPcFactor() {
        return this.pcFactor;
    }

    public Boolean getFConf() {
        return this.fConf;
    }

    public Long getFPriceThre() {
        return this.fPriceThre;
    }

    public Double getFGiveUpProb() {
        return this.fGiveUpProb;
    }

    public Boolean getEConf() {
        return this.eConf;
    }

    public Long getEPriceThre() {
        return this.ePriceThre;
    }

    public Double getERate() {
        return this.eRate;
    }

    public void setResetType(Integer resetType) {
        this.resetType = resetType;
    }

    public void setCConf(Boolean cConf) {
        this.cConf = cConf;
    }

    public void setFcFactor(Double fcFactor) {
        this.fcFactor = fcFactor;
    }

    public void setCFactor(Double cFactor) {
        this.cFactor = cFactor;
    }

    public void setPcFactor(Double pcFactor) {
        this.pcFactor = pcFactor;
    }

    public void setFConf(Boolean fConf) {
        this.fConf = fConf;
    }

    public void setFPriceThre(Long fPriceThre) {
        this.fPriceThre = fPriceThre;
    }

    public void setFGiveUpProb(Double fGiveUpProb) {
        this.fGiveUpProb = fGiveUpProb;
    }

    public void setEConf(Boolean eConf) {
        this.eConf = eConf;
    }

    public void setEPriceThre(Long ePriceThre) {
        this.ePriceThre = ePriceThre;
    }

    public void setERate(Double eRate) {
        this.eRate = eRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcpxControlParams)) {
            return false;
        }
        OcpxControlParams other = (OcpxControlParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$resetType = this.getResetType();
        Integer other$resetType = other.getResetType();
        if (this$resetType == null ? other$resetType != null : !((Object)this$resetType).equals(other$resetType)) {
            return false;
        }
        Boolean this$cConf = this.getCConf();
        Boolean other$cConf = other.getCConf();
        if (this$cConf == null ? other$cConf != null : !((Object)this$cConf).equals(other$cConf)) {
            return false;
        }
        Double this$fcFactor = this.getFcFactor();
        Double other$fcFactor = other.getFcFactor();
        if (this$fcFactor == null ? other$fcFactor != null : !((Object)this$fcFactor).equals(other$fcFactor)) {
            return false;
        }
        Double this$cFactor = this.getCFactor();
        Double other$cFactor = other.getCFactor();
        if (this$cFactor == null ? other$cFactor != null : !((Object)this$cFactor).equals(other$cFactor)) {
            return false;
        }
        Double this$pcFactor = this.getPcFactor();
        Double other$pcFactor = other.getPcFactor();
        if (this$pcFactor == null ? other$pcFactor != null : !((Object)this$pcFactor).equals(other$pcFactor)) {
            return false;
        }
        Boolean this$fConf = this.getFConf();
        Boolean other$fConf = other.getFConf();
        if (this$fConf == null ? other$fConf != null : !((Object)this$fConf).equals(other$fConf)) {
            return false;
        }
        Long this$fPriceThre = this.getFPriceThre();
        Long other$fPriceThre = other.getFPriceThre();
        if (this$fPriceThre == null ? other$fPriceThre != null : !((Object)this$fPriceThre).equals(other$fPriceThre)) {
            return false;
        }
        Double this$fGiveUpProb = this.getFGiveUpProb();
        Double other$fGiveUpProb = other.getFGiveUpProb();
        if (this$fGiveUpProb == null ? other$fGiveUpProb != null : !((Object)this$fGiveUpProb).equals(other$fGiveUpProb)) {
            return false;
        }
        Boolean this$eConf = this.getEConf();
        Boolean other$eConf = other.getEConf();
        if (this$eConf == null ? other$eConf != null : !((Object)this$eConf).equals(other$eConf)) {
            return false;
        }
        Long this$ePriceThre = this.getEPriceThre();
        Long other$ePriceThre = other.getEPriceThre();
        if (this$ePriceThre == null ? other$ePriceThre != null : !((Object)this$ePriceThre).equals(other$ePriceThre)) {
            return false;
        }
        Double this$eRate = this.getERate();
        Double other$eRate = other.getERate();
        return !(this$eRate == null ? other$eRate != null : !((Object)this$eRate).equals(other$eRate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcpxControlParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $resetType = this.getResetType();
        result = result * 59 + ($resetType == null ? 43 : ((Object)$resetType).hashCode());
        Boolean $cConf = this.getCConf();
        result = result * 59 + ($cConf == null ? 43 : ((Object)$cConf).hashCode());
        Double $fcFactor = this.getFcFactor();
        result = result * 59 + ($fcFactor == null ? 43 : ((Object)$fcFactor).hashCode());
        Double $cFactor = this.getCFactor();
        result = result * 59 + ($cFactor == null ? 43 : ((Object)$cFactor).hashCode());
        Double $pcFactor = this.getPcFactor();
        result = result * 59 + ($pcFactor == null ? 43 : ((Object)$pcFactor).hashCode());
        Boolean $fConf = this.getFConf();
        result = result * 59 + ($fConf == null ? 43 : ((Object)$fConf).hashCode());
        Long $fPriceThre = this.getFPriceThre();
        result = result * 59 + ($fPriceThre == null ? 43 : ((Object)$fPriceThre).hashCode());
        Double $fGiveUpProb = this.getFGiveUpProb();
        result = result * 59 + ($fGiveUpProb == null ? 43 : ((Object)$fGiveUpProb).hashCode());
        Boolean $eConf = this.getEConf();
        result = result * 59 + ($eConf == null ? 43 : ((Object)$eConf).hashCode());
        Long $ePriceThre = this.getEPriceThre();
        result = result * 59 + ($ePriceThre == null ? 43 : ((Object)$ePriceThre).hashCode());
        Double $eRate = this.getERate();
        result = result * 59 + ($eRate == null ? 43 : ((Object)$eRate).hashCode());
        return result;
    }

    public String toString() {
        return "OcpxControlParams(resetType=" + this.getResetType() + ", cConf=" + this.getCConf() + ", fcFactor=" + this.getFcFactor() + ", cFactor=" + this.getCFactor() + ", pcFactor=" + this.getPcFactor() + ", fConf=" + this.getFConf() + ", fPriceThre=" + this.getFPriceThre() + ", fGiveUpProb=" + this.getFGiveUpProb() + ", eConf=" + this.getEConf() + ", ePriceThre=" + this.getEPriceThre() + ", eRate=" + this.getERate() + ")";
    }
}

