/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaRcmdAlg;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaMaterialId;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaMaterialRankInfo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeaRcmdAlg {
    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);
    static double[] weight = new double[]{100.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5};

    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();
        try {
            Long giveUpType = IdeaRcmdAlg.getGiveUpType(rcmdRequestDo);
            rcmdRequestDo = Optional.ofNullable(rcmdRequestDo).orElse(new AdxIdeaRcmdRequestDo());
            Integer putType = Optional.ofNullable(rcmdRequestDo.getPutType()).orElse(3);
            Map ideaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaStatsList()).orElse(new HashMap());
            HashMap<Long, Double> ideaStatCtrMap = new HashMap<Long, Double>();
            HashMap<Long, Double> ideaStatDayCtrMap = new HashMap<Long, Double>();
            HashMap<Long, Double> ideaStatCvaMap = new HashMap<Long, Double>();
            HashMap<Long, Double> ideaStatDayCvaMap = new HashMap<Long, Double>();
            ideaStatsList.forEach((k, v) -> {
                AdxStatsDo ideaStats = Optional.ofNullable(v).orElse(new AdxStatsDo());
                AdxIndexStatsDo idea20MinInfo = AdxStatData.getAdxTimeIndex(ideaStats, "20min");
                AdxIndexStatsDo idea1DayInfo = AdxStatData.getAdxTimeIndex(ideaStats, "1day");
                ideaStatCtrMap.put((Long)k, idea20MinInfo.getCtr());
                ideaStatDayCtrMap.put((Long)k, idea1DayInfo.getCtr());
                ideaStatCvaMap.put((Long)k, idea20MinInfo.getClickValue());
                ideaStatDayCvaMap.put((Long)k, idea1DayInfo.getClickValue());
            });
            Map ideaAppStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaAppStatsList()).orElse(new HashMap());
            HashMap ideaAppStatCtrMap = new HashMap();
            HashMap ideaAppStatCvaMap = new HashMap();
            ideaAppStatsList.forEach((k, v) -> {
                AdxStatsDo ideaAppStats = Optional.ofNullable(v).orElse(new AdxStatsDo());
                AdxIndexStatsDo ideaAppConInfo = AdxStatData.getConTimeIndex(ideaAppStats);
                ideaAppStatCtrMap.put(k, ideaAppConInfo.getCtr());
                ideaAppStatCvaMap.put(k, ideaAppConInfo.getClickValue());
            });
            AdxStatsDo resoStats = Optional.ofNullable(rcmdRequestDo.getResoStats()).orElse(new AdxStatsDo());
            AdxIndexStatsDo reso20MinInfo = AdxStatData.getAdxTimeIndex(resoStats, "20min");
            Double resoStatCtr = reso20MinInfo.getCtr();
            Double resoStatCva = reso20MinInfo.getClickValue();
            AdxStatsDo resoAppStats = Optional.ofNullable(rcmdRequestDo.getResoAppStats()).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
            AdxIndexStatsDo ideaAppConInfo = AdxStatData.getConTimeIndex(resoAppStats);
            Double resoAppStatCtr = ideaAppConInfo.getCtr();
            Double resoAppStatCva = ideaAppConInfo.getClickValue();
            ArrayList<Object> ideaMaterialList = new ArrayList<AdxIdeaMaterialId>();
            Map<Object, Object> featureMap = new HashMap();
            Map<AdxIdeaMaterialId, Double> preCtrMap = new HashMap<AdxIdeaMaterialId, Double>();
            Map<AdxIdeaMaterialId, Double> preCvaMap = new HashMap<AdxIdeaMaterialId, Double>();
            if (AssertUtil.isEmpty((Object)giveUpType)) {
                LocalTFModel ltfModel;
                CODER2 coderModel;
                List<AdxIdeaFeatureDo> ideaList = putType.equals(4) ? IdeaRcmdAlg.getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), rcmdRequestDo.getDynamicIdeaFeatureList()) : IdeaRcmdAlg.getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), null);
                AdxFeatureDo adxFeatureDo = Optional.ofNullable(rcmdRequestDo.getAdxFeatureDo()).orElse(new AdxFeatureDo());
                adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
                adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
                adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
                featureMap = IdeaRcmdAlg.getFeatureMap(adxFeatureDo, ideaList, ideaAppStatsList);
                ideaMaterialList = new ArrayList<Object>(featureMap.keySet());
                FM fmModel = rcmdRequestDo.getFmModel();
                preCtrMap = fmModel.predictsNew(featureMap);
                if (!putType.equals(4) && AssertUtil.isAllNotEmpty((Object[])new Object[]{coderModel = rcmdRequestDo.getCoderModel(), ltfModel = rcmdRequestDo.getLtfModel()})) {
                    preCvaMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                }
            }
            Long bestIdeaId = null;
            Long bestMaterialId = -1L;
            if (putType.equals(0) || putType.equals(1)) {
                bestIdeaId = rcmdRequestDo.getManualIdeaId();
            } else if (putType.equals(2)) {
                Map<Long, Double> preExpValueMap = IdeaRcmdAlg.getPreExpValue(ideaMaterialList, resoStatCtr, resoStatCva, preCtrMap, preCvaMap, ideaStatCtrMap, ideaStatDayCtrMap, ideaStatCvaMap, ideaStatDayCvaMap);
                bestIdeaId = IdeaRcmdAlg.getBestIdeaId(ideaMaterialList, preExpValueMap);
                ret.setIdeaScoreMap(JSONObject.toJSONString(preExpValueMap));
            } else if (putType.equals(3)) {
                AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
                adxIdeaRcmdParam.setIdeaFeatureList(rcmdRequestDo.getStaticIdeaFeatureList());
                adxIdeaRcmdParam.setAdxFeatureDo(rcmdRequestDo.getAdxFeatureDo());
                adxIdeaRcmdParam.setAdxResourceRcmdDo(rcmdRequestDo.getAdxResourceRcmdDo());
                AdxIdeaFeatureDo result = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
                if (AssertUtil.isNotEmpty((Object)result)) {
                    bestIdeaId = result.getIdeaId();
                    Double mergeRpm = result.getMergeRpm();
                    Double pRpm = result.getPRpm();
                    Double sRpm = result.getSRpm();
                    ret.setMergeRpm(mergeRpm);
                    ret.setPRpm(pRpm);
                    ret.setSRpm(sRpm);
                    if (AssertUtil.isAllEmpty((Object[])new Object[]{giveUpType, bestIdeaId})) {
                        giveUpType = 7L;
                    }
                }
            } else if (putType.equals(4)) {
                Map ideaMaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaMaterialStatInfo()).orElse(new HashMap());
                Map resoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getResoMaterialStatInfo()).orElse(new HashMap());
                Map userResoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getUserResoMaterialStatInfo()).orElse(new HashMap());
                AdxMaterialRecallDo maRecallInfo = rcmdRequestDo.getMaterialRecallList();
                List<AdxIdeaMaterialId> recallList = IdeaRcmdAlg.getRecallList(ideaMaterialList, maRecallInfo);
                List<AdxIdeaMaterialId> rawList = IdeaRcmdAlg.getRawList(ideaMaterialList, maRecallInfo, ideaMaStatsList);
                AdxIdeaMaterialRankInfo rankResult = IdeaRcmdAlg.getRank(recallList, preCtrMap, ideaMaStatsList, resoMaStatInfo, userResoMaStatInfo);
                AdxIdeaMaterialId bestResult = IdeaRcmdAlg.getBestIdeaMaterial(ideaMaterialList, rankResult.getIdeaMaterial(), rawList);
                bestIdeaId = bestResult.getIdeaId();
                bestMaterialId = bestResult.getMaterialId();
                ret.setIdeaScoreMap(JSONObject.toJSONString((Object)rankResult));
            }
            HashMap<String, String> combineFeatureMap = new HashMap<String, String>();
            AdxIdeaMaterialId bestIdeaMaterial = new AdxIdeaMaterialId(bestIdeaId, bestMaterialId);
            FeatureMapDo bestFeature = (FeatureMapDo)featureMap.get(bestIdeaMaterial);
            if (AssertUtil.isNotEmpty((Object)bestFeature) && AssertUtil.isAllNotEmpty((Object[])new Object[]{bestFeature.getStaticFeatureMap(), bestFeature.getDynamicFeatureMap()})) {
                combineFeatureMap.putAll(bestFeature.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeature.getDynamicFeatureMap());
            }
            ret.setIdeaId(bestIdeaId);
            ret.setMaterialId(bestMaterialId);
            ret.setGiveUpType(giveUpType);
            ret.setIdeaFeatureMap(combineFeatureMap);
            ret.setPreCtr((Double)preCtrMap.get(bestIdeaMaterial));
            ret.setPreClickValue((Double)preCvaMap.get(bestIdeaMaterial));
            ret.setStatCtr((Double)ideaStatCtrMap.get(bestIdeaId));
            ret.setStatClickValue((Double)ideaStatCvaMap.get(bestIdeaId));
            ret.setStatCtrResource(resoStatCtr);
            ret.setStatClickValueResource(resoStatCva);
            ret.setIdeaAppStatCtr((Double)ideaAppStatCtrMap.get(bestIdeaId));
            ret.setIdeaAppStatCva((Double)ideaAppStatCvaMap.get(bestIdeaId));
            ret.setResoAppStatCtr(resoAppStatCtr);
            ret.setResoAppStatCva(resoAppStatCva);
        }
        catch (Exception e) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd error", (Throwable)e);
        }
        return ret;
    }

    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {
        Long ret = null;
        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxIdeaRcmdRequestDo is null");
            return 1L;
        }
        if (rcmdRequestDo.getPutType() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is null");
            return 1L;
        }
        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params fmModel is null");
            return 2L;
        }
        if (rcmdRequestDo.getPutType() != 4 && rcmdRequestDo.getCoderModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params coderModel is null", (Object)rcmdRequestDo.getPutType());
            return null;
        }
        if (rcmdRequestDo.getPutType() != 4 && rcmdRequestDo.getLtfModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params ltfModel is null", (Object)rcmdRequestDo.getPutType());
            return null;
        }
        if (rcmdRequestDo.getPutType() != 4 && CollectionUtils.isEmpty(rcmdRequestDo.getStaticIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params staticIdeaFeatureList is empty", (Object)rcmdRequestDo.getPutType());
            return 5L;
        }
        if (rcmdRequestDo.getPutType() == 4 && CollectionUtils.isEmpty(rcmdRequestDo.getStaticIdeaFeatureList()) && CollectionUtils.isEmpty(rcmdRequestDo.getDynamicIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params staticIdeaFeatureList and dynamicIdeaFeatureList are empty", (Object)rcmdRequestDo.getPutType());
            return 5L;
        }
        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxFeatureDo is null");
            return 6L;
        }
        return ret;
    }

    public static Map<Long, Double> getPreExpValue(List<AdxIdeaMaterialId> ideaMaList, Double resoStatCtr, Double resoStatCva, Map<AdxIdeaMaterialId, Double> preCtrMap, Map<AdxIdeaMaterialId, Double> preCvaMap, Map<Long, Double> ideaStatCtrMap, Map<Long, Double> ideaStatDayCtrMap, Map<Long, Double> ideaStatCvaMap, Map<Long, Double> ideaStatDayCvaMap) {
        double preCtrWeight = 0.8;
        double preCvaWeight = 0.2;
        HashMap<Long, Double> preExpValueMap = new HashMap<Long, Double>();
        if (CollectionUtils.isEmpty(ideaMaList)) {
            return preExpValueMap;
        }
        for (AdxIdeaMaterialId key : ideaMaList) {
            Long ideaId = key.getIdeaId();
            Double pCtr = preCtrMap.get(key);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCtrMap.get(ideaId), ideaStatDayCtrMap.get(ideaId)), resoStatCtr);
            Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preCtrWeight, 0.0, 4.0, 0.02);
            Double pCva = preCvaMap.get(key);
            Double sCva = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCvaMap.get(ideaId), ideaStatDayCvaMap.get(ideaId)), resoStatCva);
            Double conCva = AdxStatData.getConValue(pCva, sCva, preCvaWeight, 0.0, 2.0, 1.0);
            Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conCva, 0.0);
            preExpValueMap.put(ideaId, DataUtil.formatDouble((Double)preExpValue, (int)6));
        }
        return preExpValueMap;
    }

    public static Long getBestIdeaId(List<AdxIdeaMaterialId> ideaMaList, Map<Long, Double> valueMap) {
        Long ret = null;
        if (AssertUtil.isEmpty(ideaMaList)) {
            return ret;
        }
        if (ideaMaList.size() == 1) {
            ret = ideaMaList.get(0).getIdeaId();
        } else if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {
            Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
            ArrayList<Long> sortedKeyList = new ArrayList<Long>(sortedMap.keySet());
            ArrayList<Double> sortedValueList = new ArrayList<Double>(sortedMap.values());
            ArrayList<Double> flowRateList = new ArrayList<Double>(ideaMaList.size());
            Double maxExpValue = (Double)sortedValueList.get(0);
            Double minExpValue = (Double)sortedValueList.get(ideaMaList.size() - 1);
            for (int ind = 0; ind < ideaMaList.size(); ++ind) {
                if (maxExpValue.equals(minExpValue)) {
                    flowRateList.add(weight[0]);
                    continue;
                }
                if (ind < weight.length) {
                    flowRateList.add(weight[ind]);
                } else {
                    flowRateList.add(weight[weight.length - 1]);
                }
                if (ind < 1 || !((Double)sortedValueList.get(ind)).equals(sortedValueList.get(ind - 1))) continue;
                flowRateList.set(ind, (Double)flowRateList.get(ind - 1));
            }
            Integer retIndex = AdxStatData.flowSplit(flowRateList);
            ret = (Long)sortedKeyList.get(retIndex);
        }
        return ret;
    }

    public static List<AdxIdeaFeatureDo> getIdeaList(List<AdxIdeaFeatureDo> staticIdeaList, List<AdxIdeaFeatureDo> dynamicIdeaList) {
        List<Object> ret = new ArrayList();
        if (CollectionUtils.isNotEmpty(staticIdeaList)) {
            ret = staticIdeaList;
        }
        if (CollectionUtils.isNotEmpty(dynamicIdeaList)) {
            ret = Stream.of(ret, dynamicIdeaList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        return ret;
    }

    public static Map<AdxIdeaMaterialId, FeatureMapDo> getFeatureMap(AdxFeatureDo adxFeatureDo, List<AdxIdeaFeatureDo> ideaList, Map<Long, AdxStatsDo> ideaAppStatsList) {
        HashMap<AdxIdeaMaterialId, FeatureMapDo> featureMap = new HashMap<AdxIdeaMaterialId, FeatureMapDo>();
        Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        if (AssertUtil.isEmpty(ideaList)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : ideaList) {
            Long ideaId = ideaDo.getIdeaId();
            Long materialId = AdxStatData.nullToDefault(ideaDo.getMaterialId(), -1L);
            AdxIdeaMaterialId ideaMaterial = new AdxIdeaMaterialId(ideaId, materialId);
            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            dynamicDo.setIdeaId(ideaId);
            dynamicDo.setButtonText(ideaDo.getButtonText());
            dynamicDo.setIconH(ideaDo.getIconH());
            dynamicDo.setIconW(ideaDo.getIconW());
            dynamicDo.setMjPicType(ideaDo.getMjPicType());
            dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1());
            dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1());
            dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2());
            dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2());
            dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3());
            dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3());
            dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum());
            dynamicDo.setStyleStandard(ideaDo.getStyleStandard());
            dynamicDo.setIdeaType(ideaDo.getIdeaType());
            dynamicDo.setPictureType(ideaDo.getPictureType());
            dynamicDo.setMaterialId(materialId);
            dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo());
            dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo());
            AdxStatsDo ideaAppStats = ideaAppStatsList.get(ideaId);
            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
            dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt());
            dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt());
            dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume());
            Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(ideaMaterial, featureMapDo);
        }
        return featureMap;
    }

    public static List<AdxIdeaMaterialId> getRecallList(List<AdxIdeaMaterialId> ideaMaList, AdxMaterialRecallDo recallInfo) {
        if (CollectionUtils.isEmpty(ideaMaList)) {
            return null;
        }
        if (AssertUtil.isEmpty((Object)recallInfo) || CollectionUtils.isEmpty(recallInfo.getRecallList())) {
            return ideaMaList;
        }
        ArrayList<AdxIdeaMaterialId> ret = new ArrayList<AdxIdeaMaterialId>();
        Set<Long> recallList = recallInfo.getRecallList();
        recallList.add(-1L);
        ideaMaList.forEach(ideaMaterial -> {
            boolean isPresent = recallList.stream().anyMatch(materialId -> materialId.equals(ideaMaterial.getMaterialId()));
            if (isPresent) {
                ret.add((AdxIdeaMaterialId)ideaMaterial);
            }
        });
        return ret;
    }

    public static List<AdxIdeaMaterialId> getRawList(List<AdxIdeaMaterialId> ideaMaList, AdxMaterialRecallDo recallInfo, Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaStatsList) {
        long expLimit = 20L;
        if (CollectionUtils.isEmpty(ideaMaList)) {
            return null;
        }
        if (AssertUtil.isEmpty((Object)recallInfo) || CollectionUtils.isEmpty(recallInfo.getRawList())) {
            return null;
        }
        HashSet ret = new HashSet();
        Set<Long> rawList = recallInfo.getRawList();
        ideaMaList.forEach(ideaMaterial -> {
            AdxStatsDo ideaMaStats;
            AdxIndexStatsDo ma1DayInfo;
            boolean isPresent = rawList.stream().anyMatch(materialId -> materialId.equals(ideaMaterial.getMaterialId()));
            if (isPresent) {
                ret.add(ideaMaterial);
            }
            if ((ma1DayInfo = AdxStatData.getAdxTimeIndex(ideaMaStats = Optional.ofNullable(ideaMaStatsList.get(ideaMaterial)).orElse(new AdxStatsDo()), "1day")).getExpCnt() < expLimit) {
                ret.add(ideaMaterial);
            }
        });
        List<AdxIdeaMaterialId> uniqueRet = ret.stream().collect(Collectors.toList());
        return uniqueRet;
    }

    public static AdxIdeaMaterialRankInfo getRank(List<AdxIdeaMaterialId> ideaMaList, Map<AdxIdeaMaterialId, Double> preCtrMap, Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaStatsList, Map<Long, AdxStatsDo> resoMaStatInfo, Map<Long, AdxStatsDo> userResoMaStatInfo) {
        AdxIdeaMaterialRankInfo ret = new AdxIdeaMaterialRankInfo();
        double preWeight = 0.8;
        double ctrWeight = 0.4;
        long expLimit = 10L;
        double tmpScore = -1000000.0;
        for (AdxIdeaMaterialId ideaMaterial : ideaMaList) {
            Long materialId = ideaMaterial.getMaterialId();
            AdxStatsDo ideaMaStats = Optional.ofNullable(ideaMaStatsList.get(ideaMaterial)).orElse(new AdxStatsDo());
            AdxIndexStatsDo ma20MinInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "20min");
            AdxIndexStatsDo ma1DayInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "1day");
            AdxStatsDo resoMaStats = Optional.ofNullable(resoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoMa20MinInfo = AdxStatData.getAdxTimeIndex(resoMaStats, "20min");
            AdxStatsDo userResoMaStats = Optional.ofNullable(userResoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo userResoMa1DayInfo = AdxStatData.getAdxTimeIndex(userResoMaStats, "1day");
            Double pCtr = preCtrMap.get(ideaMaterial);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getCtr(), ma1DayInfo.getCtr()), resoMa20MinInfo.getCtr());
            Double ctrScore = AdxStatData.getConCtr(pCtr, sCtr, preWeight, 0.0, 4.0, 0.02);
            Double roiScore = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getRoi(), ma1DayInfo.getRoi()), resoMa20MinInfo.getRoi());
            Double rpmScore = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getRpm(), ma1DayInfo.getRpm()), resoMa20MinInfo.getRpm());
            Double rankScore = ctrWeight * ctrScore + (1.0 - ctrWeight) * AdxStatData.nullToDefault(rpmScore, 0.0);
            double d = rankScore >= 0.0 ? rankScore * DataUtil.division((Long)expLimit, (Long)(expLimit + userResoMa1DayInfo.getExpCnt())) : rankScore * (2.0 - DataUtil.division((Long)expLimit, (Long)(expLimit + userResoMa1DayInfo.getExpCnt())));
            Double reRankScore = d;
            if (!(reRankScore > tmpScore)) continue;
            tmpScore = reRankScore;
            ret.setIdeaMaterial(ideaMaterial);
            ret.setCtrScore(DataUtil.formatDouble((Double)ctrScore, (int)6));
            ret.setRoiScore(DataUtil.formatDouble((Double)roiScore, (int)6));
            ret.setRankScore(DataUtil.formatDouble((Double)rankScore, (int)6));
            ret.setReRankScore(DataUtil.formatDouble((Double)reRankScore, (int)6));
        }
        if (AssertUtil.isEmpty((Object)ret.getIdeaMaterial()) && ideaMaList.size() > 0) {
            int randomInd = ThreadLocalRandom.current().nextInt(0, ideaMaList.size());
            ret.setIdeaMaterial(ideaMaList.get(randomInd));
        }
        return ret;
    }

    public static AdxIdeaMaterialId getBestIdeaMaterial(List<AdxIdeaMaterialId> ideaMaList, AdxIdeaMaterialId rankResult, List<AdxIdeaMaterialId> rawList) {
        double rawRate = 0.05;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{ideaMaList, rawList})) {
            return null;
        }
        if (AssertUtil.isEmpty((Object)rankResult)) {
            Random random1 = new Random();
            int n1 = random1.nextInt(rawList.size());
            rankResult = ideaMaList.get(n1);
        }
        if (CollectionUtils.isEmpty(rawList)) {
            return rankResult;
        }
        Random random2 = new Random();
        int n2 = random2.nextInt(rawList.size());
        AdxIdeaMaterialId ret = Math.random() < rawRate ? rawList.get(n2) : rankResult;
        return ret;
    }
}

