/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.CpcControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxCpcAlgoBid {
    private static final Logger logger = LoggerFactory.getLogger(AdxCpcAlgoBid.class);

    public static AdxRtbBidResultDo getAdxAlgoPrice(AdxRtbBidRequestDo bidRequestDo) {
        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();
        try {
            Double defaultCtr = 0.02;
            Double preCtrWeight = 0.8;
            Double flowerLimit = 0.0;
            Double fUpperLimit = 4.0;
            Double defaultFactor = 1.0;
            Double lowerFactor = 0.1;
            Double upperFactor = 1.9;
            Double defaultCpc = 1.0;
            Integer warnLabel = 0;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long adxAlgoPrice = Math.round(Math.floor(defaultCtr * defaultCpc * defaultFactor * 1000.0));
            String adxControlInfo = "";
            if (AssertUtil.isNotEmpty((Object)bidRequestDo)) {
                Integer groupTag;
                AdxDo adxInfo = Optional.ofNullable(bidRequestDo.getAdxDoInfo()).orElse(new AdxDo());
                Double preCtr = adxInfo.getPreCtr();
                Double statCtr = adxInfo.getStatCtr();
                Double resoStatCtr = adxInfo.getStatCtrResource();
                Double ideaAppStatCtr = adxInfo.getIdeaAppStatCtr();
                Double resoAppStatCtr = adxInfo.getResoAppStatCtr();
                Long ideaAdxCostDay = 0L;
                Long ideaAdConsumeDay = 0L;
                Double statCtrDay = null;
                AdxStatsDo ideaStats = adxInfo.getIdeaStats();
                if (AssertUtil.isNotEmpty((Object)ideaStats)) {
                    AdxIndexStatDo last1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatDo last20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);
                    ideaAdxCostDay = ideaStatsDay.getAdxConsume();
                    ideaAdConsumeDay = ideaStatsDay.getAdvertConsume();
                    statCtr = AdxStatData.nullToDefault(statCtr, ideaStatsMin.getCtr());
                    statCtrDay = ideaStatsDay.getCtr();
                }
                Double statConCtr = AdxStatData.nullToDefault(resoStatCtr, statCtrDay);
                statConCtr = AdxStatData.nullToDefault(statCtr, statConCtr);
                Long groupId = adxInfo.getGroupId();
                if (AssertUtil.isAllNotEmpty((Object[])new Object[]{groupId, groupTag = adxInfo.getGroupTag()}) && groupId.equals(129L) && groupTag.equals(2)) {
                    Double[] ctrDefaultList = new Double[]{statCtr, resoAppStatCtr, statCtrDay, resoStatCtr};
                    statConCtr = AdxStatData.nullToDefaultList(ideaAppStatCtr, ctrDefaultList);
                }
                Double conCtr = AdxStatData.getConCtr(preCtr, statConCtr, preCtrWeight, flowerLimit, fUpperLimit, defaultCtr);
                Double targetCpc = AdxStatData.nullToDefault(adxInfo.getTargetCpc(), defaultCpc);
                CpcControlDo cpcControlInfo = Optional.ofNullable(bidRequestDo.getCpcControlInfo()).orElse(new CpcControlDo());
                Map<String, Double> factorMap = cpcControlInfo.getFactorMap();
                Map<String, Double> FlowRateMap = cpcControlInfo.getFlowRateMap();
                Map<String, String> flowSplitResult = StrategyBid.flowSplit(FlowRateMap, factorMap, defaultFactor);
                level = flowSplitResult.get("level");
                Double cpcFactor = AdxStatData.getNormalValue(DataUtil.string2Double((String)flowSplitResult.get("factor")), defaultFactor, lowerFactor, upperFactor);
                adxControlInfo = JSONObject.toJSONString((Object)cpcFactor);
                adxAlgoPrice = Math.round(Math.floor(conCtr * targetCpc * cpcFactor * 1000.0));
                if (ideaAdxCostDay <= 0L && ideaAdConsumeDay > 500L) {
                    warnLabel = 1;
                    logger.warn(String.format("AdxCpcAlgoBid AdxConsume Exception Logging, GroupId: %s; ResourceId: %s; IdeaId: %s]; IdeaAdxConsumeDay: %s; IdeaAdvertConsumeDay: %s;", JSONObject.toJSONString((Object)adxInfo.getGroupId()), JSONObject.toJSONString((Object)adxInfo.getResourceId()), JSONObject.toJSONString((Object)adxInfo.getIdeaId()), JSONObject.toJSONString((Object)ideaAdxCostDay), JSONObject.toJSONString((Object)ideaAdConsumeDay)));
                }
                Double baiduAppFactor = AdxStatData.getBaiduAppFactor(adxInfo);
                Double maxPrice = (double)adxAlgoPrice.longValue() * 1.1;
                adxAlgoPrice = AdxStatData.division(adxAlgoPrice, baiduAppFactor);
                adxAlgoPrice = (long)Math.min(maxPrice, (double)adxAlgoPrice.longValue());
                adxAlgoPrice = AdxStatData.adjustPrice(adxInfo, adxAlgoPrice, cpcFactor - 0.75);
                adxControlInfo = adxControlInfo + "," + DataUtil.double2String((Double)baiduAppFactor);
            }
            ret.setLevel(level);
            ret.setStrategy(strategy);
            ret.setAdxAlgoPrice(adxAlgoPrice);
            ret.setAdxControlInfo(adxControlInfo);
        }
        catch (Exception e) {
            logger.error("AdxCpcAlgoBid.getAdxAlgoPrice error", (Throwable)e);
        }
        return ret;
    }
}

