package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

@Data
public class OcpxControlParams {

    private Integer resetType;// 维稳重置

    /**
     * 成本维稳控制参数
     */

    private Boolean cConf; //维稳置信

    private Double fcFactor=1.0; //跑量控制因子
    private Double cFactor; //二阶成本控制因子
    private Double pcFactor = 1.0; //预估值校准因子


    /**
     * 底价 控制参数
     */
    private Boolean fConf;// 底价置信
    private Long fPriceThre;// 底价阈值
    private Double fGiveUpProb;// 放弃概率


//    /**
//     * 探价控制参数
//     */
//    private Boolean eConf;// 探价置信
//    private Long ePriceThre; // 探价阈值
//    private Double eRate; //探价概率



    private String updateTime;
    /**
     * 获取维稳因子
     *
     * @param params
     * @return
     */
    public static Double getCostAtFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                ret = params.getCFactor();

                if (params.getCFactor() != null && params.getPcFactor() != null) {
                    if(params.getFcFactor()==null){
                        params.setFcFactor(1.0);
                    }
                    ret = Math.max(params.getCFactor(), params.getFcFactor());
                }
            }
        }

        return ret;
    }

    /**
     * 获取维稳因子 取 Max(预估纠偏因子,成本控制因子)
     *
     * @param params
     * @return
     */
    public static Double getCostFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if(params.getFcFactor()==null){
                    params.setFcFactor(1.0);
                }
                ret = params.getPcFactor() * params.getFcFactor();

            }
        }

        return ret;
    }



    /**
     * 二价出价保护因子
     *
     * @param params
     * @return
     */
    public static Double getCostFactorWithProtect(OcpxControlParams params, int costParamsType) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if (params.getCFactor() != null) {
                    ret = params.getCFactor();
                }
            }

            //跑量模式：数据是否置信，二阶因子均生效
            if (costParamsType == 2 && params.getCFactor() != null) {
                ret = params.getCFactor();
            }
        }

        return ret;
    }


    /**
     * 获取重置状态
     *
     * @param ocpxControlParams
     * @return
     */

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {

        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        } else {
            return null;
        }
    }

//    /**
//     * 探价-调整出价
//     */
//    public static Long getExplorePrice(OcpxControlParams ocpxControlParams, Long fee) {
//        Double adjustFee = fee.doubleValue();
//        if (ocpxControlParams != null) {
//            if (ocpxControlParams.getEConf() != null && ocpxControlParams.eConf) {
//                Long ePriceThre = ocpxControlParams.getEPriceThre();
//                if (ePriceThre != null && fee < ePriceThre) {
//                    adjustFee = adjustFee + (ePriceThre - adjustFee) * 0.5;
//                }
//            }
//        }
//        return adjustFee.longValue();
//    }

//    /**
//     * 探价-获取探价比例
//     */
//    public static Double getExploreRate(OcpxControlParams ocpxControlParams) {
//        if (ocpxControlParams != null) {
//            if (ocpxControlParams.getEConf() != null && ocpxControlParams.getEConf()) {
//                return ocpxControlParams.getERate();
//            }
//        }
//        return null;
//    }


}

