/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.enums.PeoplePreferChannel;
import cn.com.duiba.nezha.alg.alg.vo.AdvertRcmdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AdvertRcmder {
    public static List<AdvertRcmdDo> rcmds(IModel model, Map<Long, FeatureMapDo> featureMap, Map<Long, Double> modelThresholdMap, PeoplePreferChannel channel) throws Exception {
        if (AssertUtil.isEmpty(modelThresholdMap)) {
            return AdvertRcmder.modelRcmdsWithoutThreshold(model, featureMap, channel);
        }
        return AdvertRcmder.modelRcmds(model, featureMap, modelThresholdMap, channel);
    }

    public static List<AdvertRcmdDo> modelRcmds(IModel model, Map<Long, FeatureMapDo> featureMap, Map<Long, Double> thresholdMap, PeoplePreferChannel channel) throws Exception {
        Map predicts = model.predictsNew(featureMap);
        List advertRcmdDos = predicts.entrySet().stream().map(entry -> {
            boolean needRemove = (Double)entry.getValue() < thresholdMap.getOrDefault(entry.getKey(), 1.0);
            return new AdvertRcmdDo((Long)entry.getKey(), (Double)entry.getValue(), channel, needRemove);
        }).collect(Collectors.toList());
        return advertRcmdDos.stream().sorted((e1, e2) -> e2.getScore().compareTo(e1.getScore())).collect(Collectors.toList());
    }

    public static List<AdvertRcmdDo> modelRcmdsWithoutThreshold(IModel model, Map<Long, FeatureMapDo> featureMap, PeoplePreferChannel channel) throws Exception {
        Map predicts = model.predictsNew(featureMap);
        List advertRcmdDos = predicts.entrySet().stream().map(entry -> new AdvertRcmdDo((Long)entry.getKey(), (Double)entry.getValue(), channel, false)).collect(Collectors.toList());
        return advertRcmdDos.stream().sorted((e1, e2) -> e2.getScore().compareTo(e1.getScore())).collect(Collectors.toList());
    }

    public static void main(String[] args) throws Exception {
        HashMap<Long, Double> predicts = new HashMap<Long, Double>();
        predicts.put(54228L, 0.1690821256038647);
        predicts.put(49968L, 0.1180555555555555);
        predicts.put(52921L, 0.06754270696452035);
        predicts.put(56238L, 0.008333333333333337);
        predicts.put(59044L, 0.04038004750593824);
        HashMap<Long, Double> thresholdMap = new HashMap<Long, Double>();
        thresholdMap.put(54228L, 0.17);
        thresholdMap.put(49968L, 0.09);
        thresholdMap.put(52921L, 0.02);
        thresholdMap.put(56238L, 0.01);
        List advertRcmdDos = predicts.entrySet().stream().map(entry -> new AdvertRcmdDo((Long)entry.getKey(), (Double)entry.getValue(), PeoplePreferChannel.FM_PREDICT, false)).collect(Collectors.toList());
        List res = advertRcmdDos.stream().sorted((e1, e2) -> e2.getScore().compareTo(e1.getScore())).collect(Collectors.toList());
        for (AdvertRcmdDo re : res) {
            System.out.println(re);
        }
    }
}

