/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickValueRectifyTask {
    private static final Logger logger = LoggerFactory.getLogger(ClickValueRectifyTask.class);
    private static int[] CLICK_VALUE_BUCKET = new int[]{1, 2, 3, 5, 7, 10, 20, 50, 100};

    public static ClickValueRectifyDo getClickValueRectify(ClickValueRectifyReqDo rectifyRequestDo) {
        ClickValueRectifyDo ret = new ClickValueRectifyDo();
        try {
            Double defaultFactor = 1.0;
            boolean isConfident = false;
            Integer bucketLen = CLICK_VALUE_BUCKET.length + 2;
            HashMap<Integer, Double> rectifyFactorMap = new HashMap<Integer, Double>(bucketLen);
            HashMap<Integer, Long> resoClickCntDay = new HashMap<Integer, Long>(bucketLen);
            HashMap<Integer, Long> resoClickCntHour = new HashMap<Integer, Long>(bucketLen);
            HashMap<Integer, Long> resoAdConsumeDay = new HashMap<Integer, Long>(bucketLen);
            HashMap<Integer, Long> resoAdConsumeHour = new HashMap<Integer, Long>(bucketLen);
            HashMap<Integer, Double> resoPreClickValueDay = new HashMap<Integer, Double>(bucketLen);
            HashMap<Integer, Double> resoPreClickValueHour = new HashMap<Integer, Double>(bucketLen);
            boolean isDayConfident = false;
            boolean isMinConfident = false;
            Map<Object, Object> resoLevelStats = new HashMap(bucketLen);
            if (AssertUtil.isNotEmpty((Object)rectifyRequestDo)) {
                resoLevelStats = rectifyRequestDo.getResoClickValueLevelStats();
                AdxStatsDo resoStats = rectifyRequestDo.getResoStats();
                if (AssertUtil.isNotEmpty((Object)resoStats)) {
                    AdxIndexStatDo resoLast1DayStat = resoStats.getLast1DayStat();
                    AdxIndexStatDo resoLast20MinStat = resoStats.getLast20MinStat();
                    AdxIndexStatsDo resoStatsDay = AdxStatData.adxIndexCompute(resoLast1DayStat);
                    AdxIndexStatsDo resoStatsMin = AdxStatData.adxIndexCompute(resoLast20MinStat);
                    isDayConfident = resoStatsDay.getConfident();
                    isMinConfident = resoStatsMin.getConfident();
                }
            }
            for (int key = 0; key < bucketLen; ++key) {
                AdxStatsDo levelStats;
                Double rectifyFactor = defaultFactor;
                if (AssertUtil.isNotEmpty(resoLevelStats) && AssertUtil.isNotEmpty((Object)(levelStats = (AdxStatsDo)resoLevelStats.get(key)))) {
                    AdxIndexStatDo levelLast1DayStat = levelStats.getLast1DayStat();
                    AdxIndexStatDo levelLast1HourStat = levelStats.getLast1HourStat();
                    AdxIndexStatsDo levelStatsDay = AdxStatData.adxIndexCompute(levelLast1DayStat);
                    AdxIndexStatsDo levelStatsHour = AdxStatData.adxIndexCompute(levelLast1HourStat);
                    Double conRectifyFactor = AdxStatData.getConRectifyFactor(levelStatsHour, levelStatsDay);
                    if (isDayConfident && isMinConfident) {
                        isConfident = true;
                        if (AssertUtil.isNotEmpty((Object)conRectifyFactor)) {
                            rectifyFactor = conRectifyFactor;
                        }
                    }
                    resoClickCntDay.put(key, levelStatsDay.getClickCnt());
                    resoClickCntHour.put(key, levelStatsHour.getClickCnt());
                    resoAdConsumeDay.put(key, levelStatsDay.getAdvertConsume());
                    resoAdConsumeHour.put(key, levelStatsHour.getAdvertConsume());
                    resoPreClickValueDay.put(key, levelStatsDay.getPreClickValueSum());
                    resoPreClickValueHour.put(key, levelStatsHour.getPreClickValueSum());
                }
                rectifyFactorMap.put(key, rectifyFactor);
            }
            ret.setRectifyFactorMap(rectifyFactorMap);
            ret.setConfident(isConfident);
            ret.setResoClickCntDay(resoClickCntDay);
            ret.setResoClickCntHour(resoClickCntHour);
            ret.setResoAdConsumeDay(resoAdConsumeDay);
            ret.setResoAdConsumeHour(resoAdConsumeHour);
            ret.setResoPreClickValueDay(resoPreClickValueDay);
            ret.setResoPreClickValueHour(resoPreClickValueHour);
        }
        catch (Exception e) {
            logger.error("ClickValueRectifyTask.getClickValueRectify error", (Throwable)e);
        }
        return ret;
    }
}

