/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.cpcautobidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBidding;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcFilterInfo;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcNegTagParams;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.FilterResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpcNegTagFilter {
    private static final Logger logger = LoggerFactory.getLogger(CpcAutoBidding.class);
    static double[] costWeightBucket = new double[]{0.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0};
    static double[] costWeight = new double[]{0.0, 0.1, 0.2, 0.4, 0.6, 1.0};

    public static FilterResult cpcNegTagFilter(CpcFilterInfo cpcFilterInfo, Double lastGiveupFactor, CpcNegTagParams cpcNegTagParams) {
        FilterResult ret = new FilterResult();
        if (AssertUtil.isEmpty((Object)cpcFilterInfo)) {
            return ret;
        }
        if (Math.random() < 0.001) {
            logger.info("params cpcNegTagParams:{}", (Object)cpcNegTagParams);
        }
        try {
            ret = CpcNegTagFilter.costRatio(cpcFilterInfo);
        }
        catch (Exception e) {
            logger.warn("costRatio happend error,cpcFilterInfo={}", (Object)JSON.toJSONString((Object)cpcFilterInfo), (Object)e);
        }
        if (lastGiveupFactor != null) {
            ret.setGiveupFactor(lastGiveupFactor);
        }
        CpcNegTagFilter.updateFactor(ret, cpcNegTagParams);
        if (Math.random() < 0.001) {
            logger.info("cpcNegTagFilter{}, GiveupFactor:{}", (Object)cpcFilterInfo.getOrientId(), (Object)ret.getGiveupFactor());
        }
        return ret;
    }

    public static FilterResult costRatio(CpcFilterInfo cpcFilterInfo) {
        FilterResult ret = new FilterResult();
        Double costRatio = 1.0;
        Double orientCost = (double)cpcFilterInfo.costDay;
        Double orientCostLastDay = (double)cpcFilterInfo.costLastDay;
        Double orientCostHour = (double)cpcFilterInfo.costHour;
        Double orientCostLastHour = (double)cpcFilterInfo.costLastHour;
        Double orientAppCost = (double)cpcFilterInfo.appCostDay;
        Double orientAppCostLastDay = (double)cpcFilterInfo.appCostLastDay;
        Double orientAppCostHour = (double)cpcFilterInfo.appCostHour;
        Double orientAppCostLastHour = (double)cpcFilterInfo.appCostLastHour;
        Double costConfWeight = MathBase.getConfidenceWeight(orientCost, costWeightBucket, costWeight, 0.5);
        Double costDayRatio = orientCostLastDay != 0.0 ? orientCost / orientCostLastDay : costConfWeight + 1.25;
        Double costHourRatio = orientCostLastHour != 0.0 ? orientCostHour / orientCostLastHour : 1.0;
        Double appCostConfWeight = MathBase.getConfidenceWeight(orientAppCost, costWeightBucket, costWeight, 0.5);
        Double appCostDayRatio = orientAppCostLastDay != 0.0 ? orientAppCost / orientAppCostLastDay : appCostConfWeight + 1.25;
        Double appCostHourRatio = orientAppCostLastHour != 0.0 ? orientAppCostHour / orientAppCostLastHour : 1.0;
        costRatio = orientAppCost > 20000.0 ? Double.valueOf(0.3 * costConfWeight * costDayRatio + 0.7 * appCostConfWeight * appCostDayRatio) : Double.valueOf(costConfWeight * costDayRatio);
        costRatio = Math.min(Math.max(0.1, costRatio), 2.0);
        ret.setCostRatio(costRatio);
        return ret;
    }

    public static void updateFactor(FilterResult filterResult, CpcNegTagParams cpcNegTagParams) {
        Double ret = 0.5;
        Double totalLearnRate = cpcNegTagParams.totalLearnRate;
        Double giveUpLowerLimit = cpcNegTagParams.giveUpLowerLimit;
        Double giveUpUpperLimit = cpcNegTagParams.giveUpUpperLimit;
        Double ratioLimit = cpcNegTagParams.ratioLimit;
        if (filterResult == null) {
            return;
        }
        Double costRatio = filterResult.getCostRatio();
        Double giveUpFactor = filterResult.getGiveupFactor();
        if (giveUpFactor == null) {
            giveUpFactor = 0.6;
        }
        if (costRatio >= ratioLimit) {
            ret = giveUpFactor * costRatio;
            ret = MathBase.noiseSmoother(ret, 0.6, giveUpUpperLimit);
        }
        if (costRatio < ratioLimit) {
            ret = giveUpFactor * costRatio;
            ret = MathBase.noiseSmoother(ret, giveUpLowerLimit, 0.6);
        }
        ret = DataUtil.formatDouble((Double)ret, (int)3);
        filterResult.setGiveupFactor(ret);
    }

    public static <T> Map<T, Boolean> giveUpControl(Map<T, FilterResult> filterResultMap) {
        HashMap<T, Boolean> ret = new HashMap<T, Boolean>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{filterResultMap})) {
            return ret;
        }
        for (Map.Entry<T, FilterResult> entry : filterResultMap.entrySet()) {
            T key = entry.getKey();
            FilterResult filterResult = entry.getValue();
            Double giveupFactor = filterResult.getGiveupFactor();
            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (giveupFactor != null && x <= giveupFactor) {
                giveUp = true;
            }
            if (giveUp == null) continue;
            ret.put(key, giveUp);
        }
        return ret;
    }
}

