/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BiasAndConfidenceDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;

public class NewAdvertSupport {
    static double[] costWeightBucket = new double[]{10.0, 20.0, 50.0, 100.0, 200.0, 500.0};
    static double[] costWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0, 1.1};
    static double[] costEffectWeightBucket = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
    static double[] costEffectWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0, 1.1};
    static double[] slotBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0, 2.0, 3.0, 5.0};
    static double[] slotBiasWeight = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 10.0, 16.0};
    static double[] globalBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0};
    static double[] globalBiasWeight = new double[]{0.1, 0.12, 0.18, 0.5, 1.0, 1.0, 2.0};

    public static <T> Map<T, Double> circuitBreaker(Map<T, AdvertSupportInfoDo> supportAdvertMap) {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        for (Map.Entry<T, AdvertSupportInfoDo> entry : supportAdvertMap.entrySet()) {
            BiasAndConfidenceDo adSlotBias;
            AdvertSupportInfoDo adDo = entry.getValue();
            if (adDo == null || adDo.getAFee() <= 0L) continue;
            BiasAndConfidenceDo adBias = NewAdvertSupport.costBias(adDo.getConsume(), adDo.getLandingPageClickPV(), adDo.getAFee(), 1);
            Double breakerScore = NewAdvertSupport.circuitBreaker(adBias, adSlotBias = NewAdvertSupport.costBias(adDo.getSlotConsume(), adDo.getSlotLandingPageClickPV(), adDo.getAFee(), 2));
            if (breakerScore <= 1.0) {
                ret.put(entry.getKey(), breakerScore);
                continue;
            }
            if (!(adBias.getBias() < 0.1) || !(Math.random() * 5.0 > adSlotBias.getBias()) || !(Math.random() > 0.95)) continue;
            ret.put(entry.getKey(), breakerScore);
        }
        return ret;
    }

    public static Double circuitBreaker(BiasAndConfidenceDo adBias, BiasAndConfidenceDo adSlotBias) {
        Double breakerScore = 0.0;
        Double biasFactor = adBias.getBiasFactor() * adSlotBias.getBiasFactor();
        Double confidenceCostWeight = adBias.getConfidenceCostWeight() * adSlotBias.getConfidenceCostWeight();
        Double confidenceEffectWeight = adBias.getConfidenceCostEffectWeight() * adSlotBias.getConfidenceCostEffectWeight();
        breakerScore = biasFactor * confidenceCostWeight * confidenceEffectWeight;
        return DataUtil.formatDouble((Double)breakerScore, (int)3);
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;
        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = curWeight;
                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static <T> Map<T, Double> biddingFactor(Map<T, Double> supportAdvertCircuitBreakerMap, Map<T, BudgetSmoothDo> budgetSmoothFactorMap, Map<T, Double> statCVRMap, Map<T, Double> preCVRMap) {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{supportAdvertCircuitBreakerMap, statCVRMap, preCVRMap})) {
            return ret;
        }
        for (Map.Entry<T, Double> entry : supportAdvertCircuitBreakerMap.entrySet()) {
            T key = entry.getKey();
            Double breakerScore = entry.getValue();
            Double statCVR = statCVRMap.get(key);
            Double preCVR = preCVRMap.get(key);
            BudgetSmoothDo budgetSmoothDo = budgetSmoothFactorMap.get(key);
            Double factor = NewAdvertSupport.biddingSupportFactor(breakerScore, budgetSmoothDo, statCVR, preCVR);
            if (factor == null) continue;
            ret.put(key, factor);
        }
        return ret;
    }

    public static Double biddingSupportFactor(Double breakerScore, BudgetSmoothDo budgetSmoothDo, Double statCVR, Double preCVR) {
        Double ret = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{breakerScore, budgetSmoothDo, statCVR, preCVR})) {
            return ret;
        }
        Double ratio = budgetSmoothDo.getRatio();
        if (ratio != null && ratio < 0.99 && breakerScore < 0.9) {
            double smoothFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(0.7 - ratio, 0.92, 2.0, 8.0);
            double smoothFactor = 1.0 + (smoothFactor1 - 1.0) * Math.min(Math.max(preCVR / statCVR * 2.0, 0.1), 1.0) * Math.min(Math.max(1.5 - breakerScore, 0.0), 1.0);
            ret = DataUtil.formatDouble((Double)smoothFactor, (int)4);
        }
        return ret;
    }

    public static BiasAndConfidenceDo costBias(Long consume, Long landingPageClickPV, long aFee, int type) {
        BiasAndConfidenceDo ret = new BiasAndConfidenceDo();
        Double bias = 0.0;
        Double confidence = 0.0;
        Double confidenceCostWeight = 1.1;
        Double confidenceCostEffectWeight = 1.1;
        Double globalBiasFactor = 2.0;
        Double slotBiasFactor = 20.0;
        if (aFee > 0L) {
            if (consume == null) {
                consume = 0L;
            }
            if (landingPageClickPV == null) {
                landingPageClickPV = 0L;
            }
            if (consume <= 1L) {
                bias = 0.0;
                confidence = 0.0;
            } else if (landingPageClickPV == null || landingPageClickPV < 1L) {
                bias = DataUtil.division((Long)consume, (Long)aFee, (int)3);
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            } else {
                bias = DataUtil.division((Long)consume, (Long)(aFee * landingPageClickPV), (int)3) - 1.0;
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            }
            if (type == 1) {
                globalBiasFactor = NewAdvertSupport.getConfidenceWeight(bias, globalBiasBucket, globalBiasWeight, globalBiasFactor);
                ret.setBiasFactor(globalBiasFactor);
            } else {
                slotBiasFactor = NewAdvertSupport.getConfidenceWeight(bias, slotBiasBucket, slotBiasWeight, slotBiasFactor);
                ret.setBiasFactor(slotBiasFactor);
            }
            confidenceCostWeight = NewAdvertSupport.getConfidenceWeight(consume / 100L, costWeightBucket, costWeight, confidenceCostWeight);
            confidenceCostEffectWeight = NewAdvertSupport.getConfidenceWeight(confidence, costEffectWeightBucket, costEffectWeight, confidenceCostEffectWeight);
            ret.setConfidenceCostWeight(confidenceCostWeight);
            ret.setConfidenceCostEffectWeight(confidenceCostEffectWeight);
        }
        ret.setConsume(consume);
        ret.setBias(bias);
        ret.setConfidence(confidence);
        return ret;
    }
}

