package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BiasAndConfidenceDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;

/**
 *
 *
 *
 */
public class NewAdvertSupport {

    /**
     * 计费金额置信权重计算
     */
    static double[] costWeightBucket = {10, 20, 50, 100, 200, 500};
    static double[] costWeight = {0, 0.3, 0.8, 1, 1, 1.1};


    /**
     * 计费金额对应转化个数置信权重计算
     */
    static double[] costEffectWeightBucket = {1, 2, 5, 10, 20, 50};
    static double[] costEffectWeight = {0, 0.3, 0.8, 1, 1, 1.1};


    /**
     * 计费偏差-熔断因子计算
     */
    static double[] slotBiasBucket = {0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0, 2.0, 3.0, 5.0};
    static double[] slotBiasWeight = {0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 16};


    static double[] globalBiasBucket = {0, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0};
    static double[] globalBiasWeight = {0.1, 0.12, 0.18, 0.5, 1, 1, 2};


    /**
     * 广告位熔断接口
     *
     * @param supportAdvertMap
     * @param <T>
     * @return
     */
    public static <T> Map<T, Double> circuitBreaker(Map<T, AdvertSupportInfoDo> supportAdvertMap) {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        for (Map.Entry<T, AdvertSupportInfoDo> entry : supportAdvertMap.entrySet()) {

            AdvertSupportInfoDo adDo = entry.getValue();
            if (adDo != null && adDo.getAFee() > 0) {
                /**
                 * 广告全局
                 */
                BiasAndConfidenceDo adBias = costBias(adDo.getConsume(), adDo.getLandingPageClickPV(), adDo.getAFee(), 1);
                /**
                 * 广告位
                 */
                BiasAndConfidenceDo adSlotBias = costBias(adDo.getSlotConsume(), adDo.getSlotLandingPageClickPV(), adDo.getAFee(), 2);
                /**
                 * 融合
                 *
                 */
                Double breakerScore = circuitBreaker(adBias, adSlotBias);


                if (breakerScore <= 1.0) {
                    ret.put(entry.getKey(), breakerScore);
                } else if (adBias.getBias() < 0.1) {
                    // 熔断-恢复策略 整体可控情况下，根据偏差确定恢复概率
                    if ((Math.random() * 5) > adSlotBias.getBias() && Math.random() > 0.95) {
                        ret.put(entry.getKey(), breakerScore);
                    }
                }
            }

        }


        return ret;
    }


    /**
     * 广告位熔断
     */
    public static Double circuitBreaker(BiasAndConfidenceDo adBias, BiasAndConfidenceDo adSlotBias) {

        Double breakerScore = 0.0;
//        if (AssertUtil.isAllEmpty(adBias, adSlotBias)) {
////            return ret;
//        }

        Double biasFactor = adBias.getBiasFactor() * adSlotBias.getBiasFactor();
        Double confidenceCostWeight = adBias.getConfidenceCostWeight() * adSlotBias.getConfidenceCostWeight();
        Double confidenceEffectWeight = adBias.getConfidenceCostEffectWeight() * adSlotBias.getConfidenceCostEffectWeight();

        breakerScore = biasFactor * confidenceCostWeight * confidenceEffectWeight;

        return DataUtil.formatDouble(breakerScore, 3);
    }


    /**
     * 平滑分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;

        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = curWeight;
                    }

                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }

        return DataUtil.formatDouble(ret, 3);
    }


    /**
     * 扶持权重因子
     *
     * @param supportAdvertCircuitBreakerMap 扶持熔断因子Map
     * @param budgetSmoothFactorMap          预算平滑因子Map
     * @param statCVRMap                     统计CVRMap
     * @param preCVRMap                      预估CVRMap
     * @param <T>
     * @return
     */
    public static <T> Map<T, Double> biddingFactor(Map<T, Double> supportAdvertCircuitBreakerMap,
                                                   Map<T, BudgetSmoothDo> budgetSmoothFactorMap,
                                                   Map<T, Double> statCVRMap,
                                                   Map<T, Double> preCVRMap) {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(supportAdvertCircuitBreakerMap, statCVRMap, preCVRMap)) {
            return ret;
        }

        for (Map.Entry<T, Double> entry : supportAdvertCircuitBreakerMap.entrySet()) {
            T key = entry.getKey();
            Double breakerScore = entry.getValue();
            Double statCVR = statCVRMap.get(key);
            Double preCVR = preCVRMap.get(key);
            BudgetSmoothDo budgetSmoothDo = budgetSmoothFactorMap.get(key);
            Double factor = biddingSupportFactor(breakerScore,
                    budgetSmoothDo,
                    statCVR,
                    preCVR);

            if (factor != null) {
                ret.put(key, factor);
            }

        }


        return ret;
    }


    /**
     * 扶持权重因子
     * 扶持前提条件
     * 1、熔断因子小于<0.9才扶持
     * 2、预算消耗速度<0.99才扶持
     * <p>
     * <p>
     * <p>
     * 扶持计算：
     * 1、预算消耗速度：核心指标，越小，扶持力度越大
     * <p>
     * 2、熔断因子：成本偏差稳定性指标，越小，扶持力度越大
     * <p>
     * 3、预估CVR/统计CVR：流量匹配程度指标，越大，扶持因子越大
     *
     * @param breakerScore   熔断因子
     * @param budgetSmoothDo 预算平滑
     * @param statCVR
     * @param preCVR
     * @return
     */
    public static Double biddingSupportFactor(Double breakerScore,
                                              BudgetSmoothDo budgetSmoothDo,
                                              Double statCVR,
                                              Double preCVR) {

        Double ret = 1.0;
        if (AssertUtil.isAnyEmpty(breakerScore, budgetSmoothDo, statCVR, preCVR)) {
            return ret;
        }

        Double ratio = budgetSmoothDo.getRatio();

        if (ratio != null && ratio < 0.99 && breakerScore < 0.99) {

            /**
             * 1、预算消耗速度：核心指标，越小，扶持力度越大,平滑函数[1～2]
             *
             */
            double smoothFactor1 = MathBase.sigmoidWithZoomAndIntervalMap((0.7 - ratio), 0.92, 2, 8);

            /**
             *
             *
             * 2、熔断因子：成本偏差稳定性指标，越小，扶持力度越大,平滑函数[0.1,1]
             *
             * 3、预估CVR/统计CVR：流量匹配程度指标，越大，扶持因子越大,平滑函数[0.0,1]
             *
             */
            double smoothFactor = 1 +
                    (smoothFactor1 - 1) *
                            MathBase.noiseSmoother((preCVR / statCVR * 2), 0.5, 1.0) *
                            MathBase.noiseSmoother((1.5 - breakerScore), 0.1, 1.0);

            ret = DataUtil.formatDouble(smoothFactor, 4);
        }


        return ret;
    }


    /**
     * 计算成本偏差
     *
     * @param consume
     * @param landingPageClickPV
     * @param aFee
     * @return
     */
    public static BiasAndConfidenceDo costBias(Long consume, Long landingPageClickPV, long aFee, int type) {
        BiasAndConfidenceDo ret = new BiasAndConfidenceDo();
        Double bias = 0D;
        Double confidence = 0D;


        Double costConfidenceWeight = 1.1;
        Double costEffectConfidenceWeight = 1.1;

        Double globalBiasFactor = 2.0;
        Double slotBiasFactor = 20.0;

        if (aFee > 0) {

            if (consume == null) {
                consume = 0L;
            }

            if (landingPageClickPV == null) {
                landingPageClickPV = 0L;
            }

            if (consume <= 1) {
                bias = 0D;
                confidence = 0D;
            } else if (landingPageClickPV == null || landingPageClickPV < 1) {

                bias = DataUtil.division(consume, aFee, 3);
                confidence = DataUtil.division(consume, aFee, 2);

            } else {
                bias = DataUtil.division(consume, aFee * landingPageClickPV, 3) - 1.0;
                confidence = DataUtil.division(consume, aFee, 2);

            }

            /**
             * 偏差-因子
             */
            if (type == 1) {
                globalBiasFactor = getConfidenceWeight(bias, globalBiasBucket, globalBiasWeight, globalBiasFactor);
                ret.setBiasFactor(globalBiasFactor);
            } else {
                slotBiasFactor = getConfidenceWeight(bias, slotBiasBucket, slotBiasWeight, slotBiasFactor);
                ret.setBiasFactor(slotBiasFactor);
            }

            /**
             * 消耗金额 置信因子
             */
            costConfidenceWeight = getConfidenceWeight(consume / 100, costWeightBucket, costWeight, costConfidenceWeight);

            /**
             * 消耗对应转换个数 置信因子
             */
            costEffectConfidenceWeight = getConfidenceWeight(confidence, costEffectWeightBucket, costEffectWeight, costEffectConfidenceWeight);


            ret.setConfidenceCostWeight(costConfidenceWeight);
            ret.setConfidenceCostEffectWeight(costEffectConfidenceWeight);


        }


        /**
         * 消耗金额
         */
        ret.setConsume(consume);
        /**
         * 偏差比例
         */
        ret.setBias(bias);
        /**
         * 消耗对应转化个数
         */
        ret.setConfidence(confidence);


        return ret;
    }


}
