package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

// todo
//  写完后查一遍所有方法的边界条件的考虑情况，重点是判空及除零问题；
//  该版本中所有涉及到的阈值等都放在一个静态类中，每次修改都需要在代码中修改后重新发布，较为麻烦，所以后续将所以阈值剥离出来写在一个新的类中，做成可配置的，可热更新的；
//  该版本中没有对非定向广告做区分：普通非定向广告；新广告；所以后续对该部分重新写一下；
//  该版本中线性函数/分段函数的斜率和偏置是没有严格结合数据表现考虑；所以后续需要结合数据重新确定函数的斜率和偏置

public class NdAdvertSupportV1 {
    private static final Logger logger= LoggerFactory.getLogger(NdAdvertSupportV1.class);

    static class Constance {
        static int CLICK_CONFIDENCE_THRESHOLD = 5000;  // 数据充分阈值(点击数，用于辅助判断数据置信的最小维度)
        static int SEP_STAGE_THRESHOLD = 300;    // 冷启动和起量两阶段的划分阈值
        static int COLD_START_THRESHOLD1 = 50;   // 冷启动阶段阈值1
        static int COLD_START_THRESHOLD2 = 100;  // 冷启动阶段阈值2
        static int COLD_START_THRESHOLD3 = 150;  // 冷启动阶段阈值3
        static int APP_CONVERT_THRESHOLD = 50;   // 媒体历史总转化数阈值
        static double APP_CVR_THRESHOLD = 0.03;  // 媒体历史转化率阈值
        static double APP_CONSUME_THRESHOLD = 500;  // 媒体历史总消耗阈值
        static int EXPOSE_CONFIDENCE_THRESHOLD = 20000;  // 数据充分阈值(曝光数，用于辅助判断对非定向广告是否做拓量/冷启动扶持)
        static double EXPLORE_CONSUME_PERCENT_THRESHOLD = 0.1;  // 探索消耗占比
        static int EXPOSE_CONFIDENCE_THRESHOLD2 = 500;  // 数据充分阈值(曝光数，用于辅助判断是否用f(曝光次数加权))
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;   // 修正后的bid，用于调权因子制定阶段的辅助排序
        NdAdvertResultDo ndAdvertResult;
    }

    /**
     * 出价降序排
     * @param NdAdvertResultDo
     * @return
     */
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>() {
        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) { return (int) (r2.rectifyBid- r1.rectifyBid >= 0 ? 1 : -1); }
    };

    /**
     * @description 非定向广告拓量/冷启动策略
     * @param
     * @return
     */
    public static List<NdAdvertResultDo> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo,
                                                                    List<NdAdvertFilterInfo> ndAdvertFilterInfoList,
                                                                    List<NdAdvertInfo> ndAdvertInfoList) {

        // 拓量/冷启动结果初始化
        List<NdAdvertResultDo> res = new ArrayList<>();
        // 按修正后的bid降序活动队列
        Queue<RectifyNdAdvertResInfo> candis = new PriorityQueue<>(iComparator);

        if (AssertUtil.isAnyEmpty(ndAdvertFilterInfoList, ndAdvertInfoList) || ndAdvertFilterInfoList.size() != ndAdvertInfoList.size()) {
            return res;
        }

        // 筛选媒体，在小媒体或较差的媒体不做非定向广告的拓量/冷启动
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= Constance.APP_CONVERT_THRESHOLD || hisAppCVR <= Constance.APP_CVR_THRESHOLD || hisAppConsume <= Constance.APP_CONSUME_THRESHOLD) {
            return res;
        }

        // 将要计算调权因子的广告按降序（curRectifyBid）添加到candis（Queen）中，不用调权因子的直接修正CVR后添加到res.
        for (int i=0; i < ndAdvertInfoList.size(); i++) {
            double curRectifyBid = 0.0;
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();

            if (AssertUtil.isAnyEmpty(ndAdvertInfoList.get(i), ndAdvertFilterInfoList.get(i))) { continue; }      // 未获取到当前非定向广告信息时跳过当前广告进行下一个非定向广告计算

            Long hisSlotAdvExpose = ndAdvertFilterInfoList.get(i).getHisSlotAdvExpose();
            Long hisAdvertExploreConsume = ndAdvertFilterInfoList.get(i).getHisAdvertExploreConsume();
            Long hisAdvertConsume = ndAdvertFilterInfoList.get(i).getHisAdvertConsume();
            Map<String, Double> AdjustCVRRes = getAdjustCVR(ndAdvertInfoList.get(i));
            double adjustWeight = AdjustCVRRes.get("adjustWeight");
            double adjustCvr = AdjustCVRRes.get("adjustCvr");
            double preCtr = ndAdvertInfoList.get(i).getPreCtr();      // 注：本版本中未对CTR进行修正
            Long bid = ndAdvertInfoList.get(i).getBid();

            if (hisSlotAdvExpose <= Constance.EXPOSE_CONFIDENCE_THRESHOLD && hisAdvertExploreConsume <= Constance.EXPLORE_CONSUME_PERCENT_THRESHOLD * hisAdvertConsume) {    // 需要做扶持
                if (hisSlotAdvExpose <= Constance.EXPOSE_CONFIDENCE_THRESHOLD2) {
                    curRectifyBid = preCtr * adjustCvr * bid * functionOfExpose(hisSlotAdvExpose);
                }else {
                    curRectifyBid = preCtr * adjustCvr * bid;
                }

                rectifyNdAdvertResInfo.ndAdvertResult = fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);     // 放到降序队列中，稍后用于调权因子制定时使用
            }else {     // 不需要做扶持
                res.add(fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr));
            }
        }

        // 对candis（Queen）中的广告，利用求取调权因子
        for (int idx=0; idx < candis.size(); idx ++) {
            double curFactor = functionOfRectifyFac(candis.size()).get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo= candis.poll();
            curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }

        return res;
    }

    /**
     * @description 对非定向广告的CVR进行修正；目的：打压高点击低转化广告
     * @param ndAdvertInfo
     * @return CVR修正因子及修正后的CVR值
     */
    public static Map<String, Double> getAdjustCVR(NdAdvertInfo ndAdvertInfo){

        Map<String, Double> res = new HashMap<>();
        if (AssertUtil.isEmpty(ndAdvertInfo)) {
            return null;
        }

        // 获取统计信息
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = MathUtil.division(hisConvert, hisClick, 6);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();

        double minDimsStatCvr = 0.0;
        Long[] clickList = {advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick,
                advTradeAppTriDayClick, advTradeAppTradeTriDayClick};
        NdAdvertStatusDo[] itemList = {ndAdvertInfo.getAdvTradeSlotDayStats(), ndAdvertInfo.getAdvTradeAppDayStats(),
                ndAdvertInfo.getAdvTradeAppTradeDayStats(), ndAdvertInfo.getAdvTradeSlotTriDayStats(),
                ndAdvertInfo.getAdvTradeAppTriDayStats(), ndAdvertInfo.getAdvTradeAppTradeTriDayStats()};

        // 确定满足数据充分的最小维度，若均不满足则用最大维度数据，求取StaCVR
        if (clickList[clickList.length -1] <= Constance.CLICK_CONFIDENCE_THRESHOLD) {
            minDimsStatCvr = MathUtil.division(itemList[clickList.length -1].getConvert(), clickList[clickList.length -1], 6);
        }else {
            for (int index=0; index<clickList.length; index++) {
                if (clickList[index] >= Constance.CLICK_CONFIDENCE_THRESHOLD) {
                    minDimsStatCvr = MathUtil.division(itemList[index].getConvert(), clickList[index], 6);
                    break;
                }
            }
        }

        // CVR调整策略。各变量与文档中的对应关系：preCvr ==> pcvr；hisClick ==> x；staCvr ==> y1；minDimsStatCvr ==> y2；adjustWeight ==> a
        double adjustWeight = 1.0;
        double adjustCvr = preCvr;
        if (hisClick < Constance.SEP_STAGE_THRESHOLD) {     // 冷启阶段
            if (Constance.COLD_START_THRESHOLD1 <= hisClick && hisClick < Constance.COLD_START_THRESHOLD2) {
                adjustWeight = staCvr == 0 || staCvr < 0.4 * minDimsStatCvr ? 0.9 : 1.0;
            }else if (Constance.COLD_START_THRESHOLD2 <= hisClick && hisClick < Constance.COLD_START_THRESHOLD3) {
                if (staCvr == 0 || staCvr < 0.4 * minDimsStatCvr) {
                    adjustWeight = 0.8;
                }else if (staCvr < 0.7 * minDimsStatCvr) {
                    adjustWeight = 0.9;
                }else {adjustWeight = 1.0;}
            }else if (hisClick >= Constance.COLD_START_THRESHOLD3) {
                if (staCvr == 0 || staCvr < 0.4 * minDimsStatCvr) {
                    adjustWeight = 0.7;
                }else if (staCvr < 0.7 * minDimsStatCvr) {
                    adjustWeight = 0.8;
                }else {adjustWeight = 1.0;}
            }else { adjustWeight = 1.0; }   // hisClick < Constance.COLD_START_THRESHOLD1的情况
        }else {     // 起量阶段
            if (staCvr == 0) { adjustWeight = 0.1; } else { adjustWeight = 0.3 + 0.4 * Math.min(1, MathUtil.division(hisClick, 2000, 6));}
        }

        if (hisClick >= Constance.SEP_STAGE_THRESHOLD && staCvr != 0) {         // 根据CVR调整系数计算得到调整后的adjustCvr
            adjustCvr = (1 - adjustWeight) * preCvr + adjustWeight * staCvr;
        } else { adjustCvr *= adjustWeight; }

        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);

        return res;
    }

    /**
     * 曝光次数加权函数
     */
    //todo 需要看数据确定该函数具体参数值,现在先临时写成一个线性函数，最好最好做成分段函数或者1/sigmoid函数
    public static double functionOfExpose(Long exposeCnt) {
        double res = 1.0;

        double k = -4 * Math.exp(-4);
        double b = 1.2;
        res = k * exposeCnt + b;

        return res;
    }

    /**
     * 调权因子加权函数
     */
    //todo 需要看数据确定该函数具体参数值
    public static List<Double> functionOfRectifyFac(int size) {
        List<Double> res = new ArrayList<>();
        double weight = 1.0;
        Map<String, Double> KBMap1 = calculateKAndB(0, (int) (0.1 * size), 1.2, 1.1);
        Map<String, Double> KBMap2 = calculateKAndB((int) (0.1 * size) + 1, (int) (0.2 * size), 1.1, 1.0);
        double k1 = KBMap1.get("K");
        double k2 = KBMap2.get("K");
        double b1 = KBMap1.get("B");
        double b2 = KBMap1.get("B");

        for (int i=0; i<size; i++) {
            if (i <= (int) (0.1 * size)) {
                weight = k1 * i + b1;
                res.add(weight);
            }else if((int) (0.1 * size) < i && i <= (int) (0.2 * size)) {
                weight = k2 * i + b2;
                res.add(weight);
            }else {
                weight = 1.0;
                res.add(weight);}
        }

        return res;
    }

    /**
     * 调权因子加权函数斜率及偏置的计算
     */
    //todo 后续需要添加判空，除零等边界条件的处理
    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        Map<String, Double> res = new HashMap<>();

        double k = MathUtil.division(y1 - y0, x1 - x0, 6);
        double b = y0 - k * x0;
        res.put("K", k);
        res.put("B", b);

        return res;
    }

    /**
     * 封装拓量/冷启动对非定向广告扶持结果数据
     */
    private static NdAdvertResultDo fillData(NdAdvertInfo ndAdvertInfo,
                                             double adjustFactor,
                                             double ctrRectifyFactor,
                                             double cvrRectifyFactor,
                                             double rectifyCtr,
                                             double rectifyCvr) {
        NdAdvertResultDo ndAdvertRes = new NdAdvertResultDo();

        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);

        return ndAdvertRes;
    }

}
