package cn.com.duiba.nezha.alg.alg.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 拓量/冷启动的配置项，支持热更新
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class NdAdvertParams {

    // 媒体维度 => 用于媒体筛选
    private Integer appConvertThreshold = 50;              // 历史总转化数阈值
    private Double appCVRThreshold = 0.03;                 // 历史转化率阈值
    private Double appConsumeThreshold =  500.0;           // 历史总消耗阈值

    // 数据置信最小维度上统计CVR的阈值 => 用于辅助判断是走哪套扶持参数
    private Double minDimStatsCvrThreshold = 0.01;         //

    // 数据置信最小维度上统计CVR大于设定的阈值
    private Integer clickConfidenceThreshold = 5000;       // 数据充分阈值(点击数，用于辅助判断数据置信的最小维度)
    private Integer sepStageThreshold = 300;               // 冷启动和起量两阶段的划分阈值
    private Integer coldStartThreshold1 = 50;              // 冷启动阶段阈值1
    private Integer coldStartThreshold2 = 100;             // 冷启动阶段阈值2
    private Integer coldStartThreshold3 = 150;             // 冷启动阶段阈值3
    private Integer exposeConfidenceThreshold = 10000;     // 数据充分阈值(曝光数，用于辅助判断对非定向广告是否做拓量/冷启动扶持)
    private Integer exposeConfidenceThreshold1 = 15000;    // 数据充分阈值(曝光数，用于辅助判断对非定向广告是否做拓量/冷启动扶持)
    private Double exposeConsumePercentThreshold = 0.1;    // 探索消耗占比
    private Integer exposeConfidenceThreshold2 = 2000;     // 数据充分阈值(曝光数，用于辅助判断是否用f(曝光次数加权))

    // 数据置信最小维度上统计CVR小于设定的阈值 => 参数与上个快中相同，目前暂定值大4倍
    private Integer clickConfidenceThresholdSet2 = 20000;
    private Integer sepStageThresholdSet2 = 1200;
    private Integer coldStartThresholdSet4 = 200;
    private Integer coldStartThresholdSet5 = 400;
    private Integer coldStartThresholdSet6 = 600;
    private Integer exposeConfidenceThresholdSet3 = 20000;
    private Integer exposeConfidenceThresholdSet4 = 30000;
    private Double exposeConsumePercentThresholdSet2 = 0.1;
    private Integer exposeConfidenceThresholdSet5 = 5000;

}

