/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advertexploitbak;

import cn.com.duiba.nezha.alg.alg.advertexploitbak.CandidateDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ExploitData;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ExploitDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ExploitInfo;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ExploitParams;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ExploitResult;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.MatcherEnum;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.MatcherWeightInfo;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.OrientationDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.ResultDto;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class AdvertExploit {
    public static ExploitResult exploit(ExploitInfo exploitInfo, Map<MatcherEnum, List<CandidateDto>> matcherOrientMap, Map<String, OrientationDto> orientInfoMap, ExploitParams params) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exploitInfo, matcherOrientMap, params})) {
            return null;
        }
        ExploitDto expData = AdvertExploit.dataMerge(exploitInfo.getExpData(), params);
        HashMap<MatcherEnum, ExploitDto> matcherDataMap = new HashMap<MatcherEnum, ExploitDto>(exploitInfo.getExpMatcherData().size());
        for (Map.Entry<MatcherEnum, ExploitData> entry : exploitInfo.getExpMatcherData().entrySet()) {
            matcherDataMap.put(entry.getKey(), AdvertExploit.dataMerge(entry.getValue(), params));
        }
        HashMap<MatcherEnum, ExploitDto> slotMatcherDataMap = new HashMap<MatcherEnum, ExploitDto>(exploitInfo.getSlotMatcherData().size());
        for (Map.Entry<MatcherEnum, ExploitData> entry : exploitInfo.getSlotMatcherData().entrySet()) {
            slotMatcherDataMap.put(entry.getKey(), AdvertExploit.dataMerge(entry.getValue(), params));
        }
        HashMap<MatcherEnum, Double> hashMap = new HashMap<MatcherEnum, Double>();
        HashMap<MatcherEnum, Double> hashMap2 = new HashMap<MatcherEnum, Double>();
        for (Map.Entry entry : matcherDataMap.entrySet()) {
            if (slotMatcherDataMap.containsKey(entry.getKey()) && ((ExploitDto)slotMatcherDataMap.get(entry.getKey())).getOcpcConsume() > params.getConfidentConsume()) {
                hashMap.put((MatcherEnum)((Object)entry.getKey()), ((ExploitDto)slotMatcherDataMap.get(entry.getKey())).getCostBias());
                hashMap2.put((MatcherEnum)((Object)entry.getKey()), ((ExploitDto)slotMatcherDataMap.get(entry.getKey())).getCpm());
                continue;
            }
            if (((ExploitDto)entry.getValue()).getOcpcConsume() <= params.getConfidentConsume()) continue;
            hashMap.put((MatcherEnum)((Object)entry.getKey()), ((ExploitDto)entry.getValue()).getCostBias());
            hashMap2.put((MatcherEnum)((Object)entry.getKey()), ((ExploitDto)entry.getValue()).getCpm());
        }
        double maxCostWeight = params.getCostDefaultWeight();
        double maxCpmWeight = params.getCpmDefaultWeight();
        if (expData.getOcpcConsume() != null && expData.getOcpcConsume() > params.getExpConfidentConsume() && expData.getExposure() != null && expData.getExposure() > params.getExpConfidentExposure()) {
            double tmpCostWeight = AdvertExploit.calSigmoid(params.getThetaCost(), params.getBetaCost(), expData.getCostBias());
            maxCostWeight = Math.min(params.getCostWeightUpperBound(), Math.max(params.getCostWeightLowerBound(), tmpCostWeight));
            maxCpmWeight = 1.0 - maxCostWeight;
        }
        Map<MatcherEnum, MatcherWeightInfo> costWeightInfoMap = AdvertExploit.getMatcherWeightInfo1(hashMap, maxCostWeight, true);
        Map<MatcherEnum, MatcherWeightInfo> cpmWeightInfoMap = AdvertExploit.getMatcherWeightInfo1(hashMap2, maxCpmWeight, false);
        HashMap<MatcherEnum, MatcherWeightInfo> resultWeightInfoMap = new HashMap<MatcherEnum, MatcherWeightInfo>();
        HashMap<String, ResultDto> resultDtoMap = new HashMap<String, ResultDto>();
        for (Map.Entry<MatcherEnum, List<CandidateDto>> entry : matcherOrientMap.entrySet()) {
            MatcherWeightInfo costWeightInfo = costWeightInfoMap.getOrDefault((Object)entry.getKey(), new MatcherWeightInfo(params.getMatcherDefaultWeight(), 0));
            MatcherWeightInfo cpmWeightInfo = cpmWeightInfoMap.getOrDefault((Object)entry.getKey(), new MatcherWeightInfo(params.getMatcherDefaultWeight(), 0));
            double weight = Math.min(1.0, Math.max(params.getMatcherWeightLowerBound(), AdvertExploit.add(costWeightInfo.getWeight(), cpmWeightInfo.getWeight())));
            int num = (int)(weight * (double)entry.getValue().size());
            resultWeightInfoMap.put(entry.getKey(), new MatcherWeightInfo(weight, num));
            boolean isScored = entry.getKey().isScored();
            List<CandidateDto> matchList = AdvertExploit.candidateSampling(entry.getValue(), orientInfoMap, num, isScored, params.getNewAdvertFactor());
            for (CandidateDto dto : matchList) {
                String key = dto.getKey();
                OrientationDto orientInfo = orientInfoMap.get(key);
                ResultDto resultDto = resultDtoMap.getOrDefault(key, new ResultDto(dto.getAdvertId(), dto.getOrientationId(), new HashMap<MatcherEnum, Double>(matcherOrientMap.size()), orientInfo.getNewAdvert(), orientInfo.getExploreFlag(), orientInfo.getPredictBias()));
                if (isScored) {
                    resultDto.getScoreMap().put(entry.getKey(), dto.getScore());
                } else {
                    resultDto.getScoreMap().put(entry.getKey(), null);
                }
                resultDtoMap.put(key, resultDto);
            }
        }
        return new ExploitResult(resultDtoMap, maxCostWeight, maxCpmWeight, costWeightInfoMap, cpmWeightInfoMap, resultWeightInfoMap);
    }

    private static List<CandidateDto> candidateSampling(List<CandidateDto> candidates, Map<String, OrientationDto> orientInfoMap, int samplingNum, boolean isScored, Double newAdvertFactor) {
        if (samplingNum >= candidates.size()) {
            return candidates;
        }
        Random random = new Random();
        return candidates.stream().peek(c -> {
            double factor = ((OrientationDto)orientInfoMap.get(c.getKey())).getNewAdvert() == null || ((OrientationDto)orientInfoMap.get(c.getKey())).getNewAdvert().equals(0) ? 1.0 : newAdvertFactor;
            double newScore = isScored ? AdvertExploit.multiply(c.getScore(), factor).doubleValue() : AdvertExploit.multiply(random.nextDouble(), factor).doubleValue();
            c.setScore(newScore);
        }).sorted(Comparator.comparing(CandidateDto::getScore).reversed()).collect(Collectors.toList()).subList(0, samplingNum);
    }

    private static Map<MatcherEnum, MatcherWeightInfo> getMatcherWeightInfo(Map<MatcherEnum, Double> map, Double maxWeight, boolean reversed) {
        return null;
    }

    private static Map<MatcherEnum, MatcherWeightInfo> getMatcherWeightInfo1(Map<MatcherEnum, Double> map, Double maxWeight, boolean reversed) {
        AtomicInteger index = new AtomicInteger(1);
        Integer matcherSize = map.size();
        Map<MatcherEnum, MatcherWeightInfo> matcherInfoMap = map.entrySet().stream().sorted(reversed ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toMap(n -> n, n -> new MatcherWeightInfo((double)index.getAndIncrement() * AdvertExploit.divide(maxWeight, matcherSize), 0)));
        return matcherInfoMap;
    }

    private static Map<MatcherEnum, MatcherWeightInfo> getMatcherWeightInfo2(Map<MatcherEnum, Double> map, Double maxWeight, boolean reversed) {
        if (map.size() == 0) {
            return new HashMap<MatcherEnum, MatcherWeightInfo>();
        }
        List entryList = map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        double minValue = (Double)((Map.Entry)entryList.get(0)).getValue();
        double maxValue = (Double)((Map.Entry)entryList.get(entryList.size() - 1)).getValue();
        return entryList.stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            double tmpWeight = reversed ? 1.0 - ((Double)e.getValue() - minValue) / (maxValue - minValue) : ((Double)e.getValue() - minValue) / (maxValue - minValue);
            return new MatcherWeightInfo(maxWeight * tmpWeight, 0);
        }));
    }

    private static ExploitDto dataMerge(ExploitData data, ExploitParams params) {
        ExploitDto res = new ExploitDto();
        ExploitDto data3day = data.getData3day();
        ExploitDto dataToday = data.getDataToday();
        ExploitDto dataLastHour = data.getDataLastHour();
        res.setExposure(AdvertExploit.add(data3day.getExposure(), dataToday.getExposure()));
        res.setClick(AdvertExploit.add(data3day.getClick(), dataToday.getClick()));
        res.setTargetConvert(AdvertExploit.add(data3day.getTargetConvert(), dataToday.getTargetConvert()));
        res.setConv(AdvertExploit.mergeMap(data3day.getConv(), dataToday.getConv(), 8));
        res.setOcpcConsume(AdvertExploit.add(data3day.getOcpcConsume(), dataToday.getOcpcConsume()));
        res.setAdjOcpcConsume(AdvertExploit.add(data3day.getAdjOcpcConsume(), dataToday.getAdjOcpcConsume()));
        double data3dayWeight = data3day.getOcpcConsume() == null || data3day.getOcpcConsume() < params.getConfidentConsume() ? 0.0 : params.getData3dayWeight();
        double dataTodayWeight = dataToday.getOcpcConsume() == null || dataToday.getOcpcConsume() < params.getConfidentConsume() ? 0.0 : params.getDataTodayWeight();
        double dataLastHourWeight = dataLastHour.getOcpcConsume() == null || dataLastHour.getOcpcConsume() < params.getConfidentConsume() ? 0.0 : params.getDataLastHourWeight();
        Double data3dayBiasPart = AdvertExploit.multiply(data3dayWeight, data3day.getCostBias());
        Double dataTodayBiasPart = AdvertExploit.multiply(dataTodayWeight, dataToday.getCostBias());
        Double dataLastHourBiasPart = AdvertExploit.multiply(dataLastHourWeight, dataLastHour.getCostBias());
        Double costBias = AdvertExploit.divide((Double)(data3dayBiasPart + dataTodayBiasPart + dataLastHourBiasPart), data3dayWeight + dataTodayWeight + dataLastHourWeight);
        res.setCostBias(costBias);
        Double data3dayCpmPart = AdvertExploit.multiply(data3dayWeight, AdvertExploit.divide(data3day.getOcpcConsume(), data3day.getExposure()));
        Double dataTodayCpmPart = AdvertExploit.multiply(dataTodayWeight, AdvertExploit.divide(dataToday.getOcpcConsume(), dataToday.getExposure()));
        Double dataLastHourCpmPart = AdvertExploit.multiply(dataLastHourWeight, AdvertExploit.divide(dataLastHour.getOcpcConsume(), dataLastHour.getExposure()));
        Double cpm = AdvertExploit.divide((Double)(data3dayCpmPart + dataTodayCpmPart + dataLastHourCpmPart), data3dayWeight + dataTodayWeight + dataLastHourWeight);
        res.setCpm(cpm);
        return res;
    }

    private static Map<Integer, Long> mergeMap(Map<Integer, Long> map1, Map<Integer, Long> map2, int initCapacity) {
        HashMap<Integer, Long> resMap = new HashMap<Integer, Long>(initCapacity);
        resMap.putAll(map1);
        resMap.putAll(map2);
        resMap.forEach((k, v) -> {
            Long finalV = AdvertExploit.add((Long)map1.get(k), (Long)map2.get(k));
            resMap.put((Integer)k, finalV);
        });
        return resMap;
    }

    public static double calSigmoid(double theta, double beta, double value) {
        return 1.0 / (1.0 + Math.exp(-1.0 * theta * value + beta));
    }

    private static Long add(Long v1, Long v2) {
        Long v1New = v1 == null ? 0L : v1;
        Long v2New = v2 == null ? 0L : v2;
        return v1New + v2New;
    }

    private static Double add(Double v1, Double v2) {
        Double v1New = v1 == null ? 0.0 : v1;
        Double v2New = v2 == null ? 0.0 : v2;
        return v1New + v2New;
    }

    private static Double multiply(Double v1, Double v2) {
        return v1 != null && v2 != null ? v1 * v2 : 0.0;
    }

    private static Double divide(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / (double)v2.longValue() : 0.0;
    }

    private static Double divide(Double v1, Integer v2) {
        return v1 != null && v2 != null && v2 != 0 ? v1 / (double)v2.intValue() : 0.0;
    }

    private static Double divide(Double v1, Double v2) {
        return v1 != null && v2 != null && v2 != 0.0 ? v1 / v2 : 0.0;
    }

    public static void main(String[] args) {
        HashMap<MatcherEnum, Double> map = new HashMap<MatcherEnum, Double>();
        Map<MatcherEnum, MatcherWeightInfo> resMap = AdvertExploit.getMatcherWeightInfo(map, 0.5, true);
        for (Map.Entry<MatcherEnum, MatcherWeightInfo> entry : resMap.entrySet()) {
            System.out.println((Object)((Object)entry.getKey()) + ": " + entry.getValue());
        }
    }
}

