/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertInfo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultDo;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdAdvertSupportV2 {
    private static final Logger logger = LoggerFactory.getLogger(NdAdvertSupportV2.class);
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>(){

        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) {
            return r2.rectifyBid - r1.rectifyBid >= 0.0 ? 1 : -1;
        }
    };

    public static List<NdAdvertResultDo> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo, NdAdvertParams ndAdvertParams, List<NdAdvertInfo> ndAdvertInfoList) {
        ArrayList<NdAdvertResultDo> res = new ArrayList<NdAdvertResultDo>();
        PriorityQueue<RectifyNdAdvertResInfo> candis = new PriorityQueue<RectifyNdAdvertResInfo>(iComparator);
        HashSet<Long> tmpSet = new HashSet<Long>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertInfoList, ndFilterAppInfo, ndAdvertParams})) {
            return res;
        }
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= (long)ndAdvertParams.getAppConvertThreshold().intValue() || hisAppCVR <= ndAdvertParams.getAppCVRThreshold() || (double)hisAppConsume.longValue() <= ndAdvertParams.getAppConsumeThreshold()) {
            return res;
        }
        for (int i = 0; i < ndAdvertInfoList.size(); ++i) {
            Integer exposeConfidenceThreshold2;
            Double exposeConsumePercentThreshold;
            Integer exposeConfidenceThreshold;
            double curRectifyBid = 0.0;
            NdAdvertInfo curNdAdvertInfo = ndAdvertInfoList.get(i);
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Long hisSlotAdvExpose = curNdAdvertInfo.getHisExpose();
            Long hisAdvertExploreConsume = curNdAdvertInfo.getHisAdvertExploreConsume();
            Long hisAdvertConsume = curNdAdvertInfo.getHisAdvertConsume();
            Map<String, Double> AdjustCVRRes = NdAdvertSupportV2.getAdjustCVR(ndAdvertParams, curNdAdvertInfo);
            double adjustWeight = AdjustCVRRes.get("adjustWeight");
            double adjustCvr = AdjustCVRRes.get("adjustCvr");
            String paramType = AdjustCVRRes.get("paramType") == 1.0 ? "firstSet" : "secondSet";
            double preCtr = curNdAdvertInfo.getPreCtr();
            Long bid = curNdAdvertInfo.getBid();
            if (paramType.equals("firstSet")) {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThreshold();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThreshold2();
            } else {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet3();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThresholdSet2();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThresholdSet5();
            }
            if (hisSlotAdvExpose <= (long)exposeConfidenceThreshold.intValue() || (double)hisAdvertExploreConsume.longValue() <= exposeConsumePercentThreshold * (double)hisAdvertConsume.longValue()) {
                if (hisSlotAdvExpose <= (long)exposeConfidenceThreshold2.intValue()) {
                    curRectifyBid = preCtr * adjustCvr * (double)bid.longValue() * NdAdvertSupportV2.functionOfExpose(hisSlotAdvExpose);
                } else {
                    curRectifyBid = preCtr * adjustCvr * (double)bid.longValue();
                    tmpSet.add(curNdAdvertInfo.getAdvertId());
                }
                rectifyNdAdvertResInfo.ndAdvertResult = NdAdvertSupportV2.fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);
                continue;
            }
            res.add(NdAdvertSupportV2.fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr));
        }
        int lengthOfCandis = candis.size();
        List<Double> functionOfRectifyFacList = NdAdvertSupportV2.functionOfRectifyFac(lengthOfCandis);
        for (int idx = 0; idx < lengthOfCandis; ++idx) {
            double curFactor = functionOfRectifyFacList.get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = (RectifyNdAdvertResInfo)candis.poll();
            if (tmpSet.contains(curRectifyNdAdvertResInfo.ndAdvertResult.getAdvertId())) {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(1.0);
            } else {
                curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            }
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }
        return res;
    }

    public static Map<String, Double> getAdjustCVR(NdAdvertParams ndAdvertParams, NdAdvertInfo ndAdvertInfo) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertParams, ndAdvertInfo})) {
            return null;
        }
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division((Long)hisConvert, (Long)hisClick, (int)6)).orElse(0.0);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = ndAdvertInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = ndAdvertInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = ndAdvertInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = ndAdvertInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = ndAdvertInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getConvert();
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotDayConvert, (Long)advTradeSlotDayClick, (int)6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppDayConvert, (Long)advTradeAppDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeDayConvert, (Long)advTradeAppTradeDayClick, (int)6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotTriDayConvert, (Long)advTradeSlotTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTriDayConvert, (Long)advTradeAppTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeTriDayConvert, (Long)advTradeAppTradeTriDayClick, (int)6)).orElse(0.0);
        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick, advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr, advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        paramType = Collections.max(cvrList) < ndAdvertParams.getMinDimStatsCvrThreshold() ? "secondSet" : "firstSet";
        adjustWeight = NdAdvertSupportV2.getAdjustWeight(ndAdvertParams, clickList, cvrList, paramType, hisClick, staCvr);
        double adjustCvr = preCvr;
        if (hisClick >= (long)(paramType.equals("firstSet") ? ndAdvertParams.getSepStageThreshold() : ndAdvertParams.getSepStageThresholdSet2()).intValue() && staCvr >= Math.pow(10.0, -8.0)) {
            adjustWeight = 1.0;
        } else {
            adjustCvr *= adjustWeight;
        }
        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", paramType.equals("firstSet") ? 1.0 : 2.0);
        return res;
    }

    public static Double getMinDimsStatCvr(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;
        if (clickList.get(clickList.size() - 1) <= (long)(paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold()).intValue()) {
            minDimsStatCvr = cvrList.get(clickList.size() - 1);
        } else {
            for (int index = 0; index < clickList.size(); ++index) {
                if (clickList.get(index) < (long)(paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold()).intValue()) continue;
                minDimsStatCvr = cvrList.get(index);
                break;
            }
        }
        return minDimsStatCvr;
    }

    public static Double getAdjustWeight(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        Integer coldStartThreshold3;
        Integer coldStartThreshold2;
        Integer coldStartThreshold1;
        Integer sepStageThreshold;
        double adjustWeight = 1.0;
        double minDimsStatCvr = NdAdvertSupportV2.getMinDimsStatCvr(ndAdvertParams, clickList, cvrList, paramType);
        if (paramType.equals("firstSet")) {
            sepStageThreshold = ndAdvertParams.getSepStageThreshold();
            coldStartThreshold1 = ndAdvertParams.getColdStartThreshold1();
            coldStartThreshold2 = ndAdvertParams.getColdStartThreshold2();
            coldStartThreshold3 = ndAdvertParams.getColdStartThreshold3();
        } else {
            sepStageThreshold = ndAdvertParams.getSepStageThresholdSet2();
            coldStartThreshold1 = ndAdvertParams.getColdStartThresholdSet4();
            coldStartThreshold2 = ndAdvertParams.getColdStartThresholdSet5();
            coldStartThreshold3 = ndAdvertParams.getColdStartThresholdSet6();
        }
        if (hisClick < (long)sepStageThreshold.intValue()) {
            boolean b;
            boolean bl = b = staCvr <= Math.pow(10.0, -8.0) || staCvr < 0.4 * minDimsStatCvr;
            adjustWeight = (long)coldStartThreshold1.intValue() <= hisClick && hisClick < (long)coldStartThreshold2.intValue() ? (b ? 0.9 : 1.0) : ((long)coldStartThreshold2.intValue() <= hisClick && hisClick < (long)coldStartThreshold3.intValue() ? (b ? 0.8 : (staCvr < 0.7 * minDimsStatCvr ? 0.9 : 1.0)) : (hisClick >= (long)coldStartThreshold3.intValue() ? (b ? 0.7 : (staCvr < 0.7 * minDimsStatCvr ? 0.8 : 1.0)) : 1.0));
        } else {
            adjustWeight = staCvr <= Math.pow(10.0, -8.0) ? 0.1 : 0.3 + 0.4 * Math.min(1.0, MathUtil.division((double)hisClick.longValue(), (int)2000, (int)6));
        }
        return adjustWeight;
    }

    public static double functionOfExpose(Long exposeCnt) {
        double res = 1.0;
        if (exposeCnt <= 3000L) {
            double k = -7.0 * Math.pow(10.0, -4.0);
            double b = 1.21;
            res = k * (double)exposeCnt.longValue() + b;
        }
        return res;
    }

    public static List<Double> functionOfRectifyFac(int size) {
        ArrayList<Double> res = new ArrayList<Double>();
        double weight = 1.0;
        Map<String, Double> KBMap1 = NdAdvertSupportV2.calculateKAndB(0, (int)(0.1 * (double)size), 1.2, 1.1);
        Map<String, Double> KBMap2 = NdAdvertSupportV2.calculateKAndB((int)(0.1 * (double)size), (int)(0.2 * (double)size), 1.1, 1.0);
        double k1 = KBMap1.get("K");
        double k2 = KBMap2.get("K");
        double b1 = KBMap1.get("B");
        double b2 = KBMap1.get("B");
        for (int i = 0; i < size; ++i) {
            weight = i <= (int)(0.1 * (double)size) ? k1 * (double)i + b1 : ((int)(0.1 * (double)size) < i && i <= (int)(0.2 * (double)size) ? k2 * (double)i + b2 : 1.0);
            weight = (double)Math.round(weight * 1000000.0) / 1000000.0;
            res.add(Math.max(weight, 1.0));
        }
        return res;
    }

    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double k = MathUtil.division((double)(y1 - y0), (int)(x1 - x0), (int)6);
        double b = y0 - k * (double)x0;
        res.put("K", k);
        res.put("B", b);
        return res;
    }

    private static NdAdvertResultDo fillData(NdAdvertInfo ndAdvertInfo, double adjustFactor, double ctrRectifyFactor, double cvrRectifyFactor, double rectifyCtr, double rectifyCvr) {
        NdAdvertResultDo ndAdvertRes = new NdAdvertResultDo();
        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);
        return ndAdvertRes;
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;
        NdAdvertResultDo ndAdvertResult;

        RectifyNdAdvertResInfo() {
        }
    }
}

