/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.recall.recaller;

import cn.com.duiba.nezha.alg.alg.advertexploitbak.CandidateDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.OrientationDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.matcher.MatcherParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExploitRecaller {
    public static List<CandidateDto> recall(List<ExploreInfo> exploreInfos, Map<String, OrientationDto> orientInfoMap, MatcherParams params) {
        ArrayList<CandidateDto> resList = new ArrayList<CandidateDto>();
        for (ExploreInfo exploreInfo : exploreInfos) {
            ExploreData data14day = exploreInfo.getAppAdvertInfo().getData14day();
            String key = exploreInfo.getAdvertId() + "_" + exploreInfo.getOrientationId();
            OrientationDto orientationDto = orientInfoMap.getOrDefault(key, new OrientationDto());
            if (!ExploitRecaller.exploitFilter(data14day.getOcpcConsume(), data14day.getExposure(), orientationDto.getNewAdvert(), orientationDto.getExploreFlag(), params.getConsumeThreshold(), params.getExposureThreshold(), params.getNewAdvertFactor())) continue;
            resList.add(new CandidateDto(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), null));
        }
        return resList;
    }

    private static boolean exploitFilter(Long consume, Long exposure, Integer newAdvert, Integer exploreFlag, Long consumeThreshold, Long exposureThreshold, Double newAdvertFactor) {
        if (exploreFlag != null && !exploreFlag.equals(0)) {
            return true;
        }
        double factor = newAdvert == null || newAdvert.equals(0) ? 1.0 : newAdvertFactor;
        return consume != null && (double)consume.longValue() > (double)consumeThreshold.longValue() / factor && exposure != null && (double)exposure.longValue() > (double)exposureThreshold.longValue() / factor;
    }
}

